/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.jest.JestConsoleProperties;
import com.intellij.javascript.jest.JestFailedTest;
import com.intellij.javascript.jest.JestFilter;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.coverage.JestCoverageRunState;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.javascript.testing.AngularCliConfig;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final Logger LOG = Logger.getInstance(JestRunProfileState.class);
    private static final String TEST_RESULTS_PROCESSOR = "jest-intellij/lib/jest-intellij-test-results-processor.js";
    private static final String REPORTER = "jest-intellij/lib/jest-intellij-reporter.js";
    private static final String STDIN_FIX = "jest-intellij/lib/jest-intellij-stdin-fix.js";
    private static volatile File TEMP_INPUT_FILE;
    private final Project myProject;
    private final JestRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myJestPackage;
    private final JestRunSettings myRunSettings;
    private final JestCoverageRunState myCoverageRunState;
    private final ConsoleCommandLineFolder myFolder;
    private List<JestFailedTest> myFailedTests;

    public JestRunProfileState(@NotNull JestRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage jestPackage) {
        if (runConfiguration == null) {
            JestRunProfileState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            JestRunProfileState.$$$reportNull$$$0(1);
        }
        if (jestPackage == null) {
            JestRunProfileState.$$$reportNull$$$0(2);
        }
        this.myFolder = new ConsoleCommandLineFolder(new String[0]);
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myJestPackage = jestPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
        this.myCoverageRunState = JestCoverageRunState.create(environment);
    }

    @Nullable
    public JestCoverageRunState getCoverageRunState() {
        return this.myCoverageRunState;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        JestConsoleProperties consoleProperties = new JestConsoleProperties(this.myRunConfiguration, this.myEnvironment.getExecutor(), (SMTestLocator)new JSTestLocationProvider(true), (ProcessHandler)processHandler);
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory(), consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        JestUtil.emitNewLineToFlushTrailingOutput((ProcessHandler)processHandler);
        if (!NodeCommandLineUtil.isTerminalCommandLine(commandLine)) {
            JestRunProfileState.sendInput(processHandler, consoleView);
        }
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{consoleProperties.createRerunFailedTestsAction(consoleView)});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            JestRunProfileState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    public void setFailedTests(@NotNull List<JestFailedTest> failedTests) {
        if (failedTests == null) {
            JestRunProfileState.$$$reportNull$$$0(4);
        }
        this.myFailedTests = failedTests;
    }

    @NotNull
    public JestRunSettings getRunSettings() {
        JestRunSettings jestRunSettings = this.myRunSettings;
        if (jestRunSettings == null) {
            JestRunProfileState.$$$reportNull$$$0(5);
        }
        return jestRunSettings;
    }

    private static void sendInput(final @NotNull OSProcessHandler processHandler, @NotNull ConsoleView consoleView) {
        SMTRunnerConsoleView testConsole;
        ConsoleViewImpl consoleImpl;
        Editor editor;
        if (processHandler == null) {
            JestRunProfileState.$$$reportNull$$$0(6);
        }
        if (consoleView == null) {
            JestRunProfileState.$$$reportNull$$$0(7);
        }
        if ((editor = (consoleImpl = (ConsoleViewImpl)(testConsole = (SMTRunnerConsoleView)consoleView).getConsole()).getEditor()) == null) {
            LOG.warn("Cannot send input to jest process: no editor");
            return;
        }
        final Map keyCodeMapping = ContainerUtil.newHashMap((Pair)Pair.create((Object)40, (Object)1792834), (Pair[])new Pair[]{Pair.create((Object)37, (Object)1792836), Pair.create((Object)39, (Object)1792835), Pair.create((Object)38, (Object)1792833), Pair.create((Object)8, (Object)(SystemInfo.isWindows ? 8 : 127)), Pair.create((Object)10, (Object)13), Pair.create((Object)27, (Object)27)});
        editor.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (event.getKeyChar() != '\u0000') {
                    this.sendCode(event.getKeyChar());
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
                Integer newKeyCode = (Integer)keyCodeMapping.get(event.getKeyCode());
                if (newKeyCode != null) {
                    this.sendCode(newKeyCode);
                }
            }

            private void sendCode(int keyCode) {
                OutputStream input;
                if (!processHandler.isProcessTerminated() && (input = processHandler.getProcessInput()) != null) {
                    try {
                        input.write(keyCode);
                        input.flush();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to send input to jest process", (Throwable)e);
                    }
                }
            }
        });
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, int debugPort) throws ExecutionException {
        List<String> testFilePaths;
        JestScopeKind scopeKind;
        String testNamePattern;
        SemVer jestVersion;
        if (interpreter == null) {
            JestRunProfileState.$$$reportNull$$$0(8);
        }
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine(SystemInfo.isWindows ? Boolean.valueOf(false) : null);
        if (SystemInfo.isWindows && !NodeCommandLineUtil.isTerminalCommandLine(commandLine)) {
            commandLine.withInput(JestRunProfileState.getOrCreateEmptyInputFile());
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (!workingDir.isEmpty()) {
            commandLine.setWorkDirectory(workingDir);
        }
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptionList, debugPort, true, interpreter, true);
        if (!NodeCommandLineUtil.isTerminalCommandLine(commandLine)) {
            commandLine.addParameters(new String[]{"--require", HelperFilesLocator.resolvePathForExecution(STDIN_FIX)});
        }
        commandLine.addParameter(JestUtil.getJestMainJsFile(this.myJestPackage).getAbsolutePath());
        String packageName = this.myJestPackage.getName();
        if ("@angular/cli".equals(packageName)) {
            this.myFolder.addPlaceholderTexts("ng", "test");
            commandLine.addParameter("test");
            String contextAngularProjectName = this.findContextAngularProject();
            if (contextAngularProjectName != null) {
                commandLine.addParameter(contextAngularProjectName);
                this.myFolder.addPlaceholderText(contextAngularProjectName);
            }
        } else {
            this.myFolder.addPlaceholderText(packageName);
            if ("@vue/cli-service".equals(packageName)) {
                commandLine.addParameter("test:unit");
                this.myFolder.addLastParameterFrom(commandLine);
            }
        }
        this.configureEnvironment(commandLine);
        if (!this.myRunSettings.getConfigFileSystemDependentPath().trim().isEmpty()) {
            commandLine.addParameter("--config");
            commandLine.addParameter(this.myRunSettings.getConfigFileSystemDependentPath());
            this.myFolder.addPlaceholderTexts("--config=" + PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath()));
        }
        if (StringUtil.isNotEmpty((String)this.myRunSettings.getJestOptions())) {
            String[] options = ParametersList.parse((String)this.myRunSettings.getJestOptions());
            commandLine.addParameters(options);
            this.myFolder.addPlaceholderTexts(options);
        }
        if (debugPort != -1) {
            commandLine.addParameter("--runInBand");
            this.myFolder.addLastParameterFrom(commandLine);
        }
        if (this.myRunConfiguration.isOptionUpdateSnapshot()) {
            commandLine.addParameter("--updateSnapshot");
            this.myFolder.addLastParameterFrom(commandLine);
            this.myRunConfiguration.clearOptionUpdateSnapshot();
        }
        commandLine.addParameter("--colors");
        SemVer semVer = jestVersion = JestUtil.isJestOrJestCliPackage(packageName) ? this.myJestPackage.getVersion() : null;
        if (jestVersion == null || jestVersion.isGreaterOrEqualThan(20, 0, 0)) {
            commandLine.addParameter("--reporters");
            commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(REPORTER));
            commandLine.addParameter("--verbose");
        } else {
            commandLine.addParameter("--testResultsProcessor");
            commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(TEST_RESULTS_PROCESSOR));
        }
        if (this.myCoverageRunState != null) {
            this.myCoverageRunState.configure(commandLine);
        }
        if ((testNamePattern = this.getTestNamePattern(scopeKind = this.myRunSettings.getScopeKind())) != null) {
            commandLine.addParameter("--testNamePattern=" + testNamePattern);
            JestFailedTest failedTest = (JestFailedTest)ContainerUtil.getFirstItem(this.myFailedTests);
            List<String> anyTestName = failedTest != null ? failedTest.getTestNames() : this.myRunSettings.getTestNames();
            String extra = this.myFailedTests != null && this.myFailedTests.size() > 1 ? "|..." : "";
            this.myFolder.addPlaceholderTexts("--testNamePattern=" + StringUtil.join(anyTestName, (String)" ") + extra);
        }
        if ((testFilePaths = this.getTestFilePaths(scopeKind, interpreter)) != null) {
            if (this.isRunTestsByPathSupported(jestVersion)) {
                commandLine.addParameter("--runTestsByPath");
                commandLine.addParameters(ContainerUtil.map(testFilePaths, path -> FileUtil.toSystemIndependentName((String)path)));
            } else {
                commandLine.addParameters(new String[]{"--testPathPattern=" + JestRunProfileState.getTestFilePathPattern(testFilePaths)});
            }
            if (scopeKind == JestScopeKind.TEST_FILE) {
                this.myFolder.addPlaceholderText(PathUtil.getFileName((String)this.myRunSettings.getTestFileSystemDependentPath()));
            }
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            JestRunProfileState.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @Nullable
    private String findContextAngularProject() {
        VirtualFile contextFile;
        AngularCliConfig config2;
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (FileUtil.isAbsolute((String)workingDir) && (config2 = AngularCliConfig.findProjectConfig(new File(workingDir))) != null && (contextFile = JestUtil.findContextFile(this.myRunSettings)) != null) {
            return config2.getProjectContainingFile(contextFile);
        }
        return null;
    }

    private boolean isRunTestsByPathSupported(@Nullable SemVer jestVersion) {
        ResolvedModuleInfo info;
        VirtualFile pkgRoot;
        if (this.myJestPackage.nameMatches("@angular/cli")) {
            return false;
        }
        if (jestVersion == null && JestUtil.isReactScriptsFamilyPackage(this.myJestPackage) && (pkgRoot = LocalFileSystem.getInstance().findFileByPath(this.myJestPackage.getSystemIndependentPath())) != null && (info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(pkgRoot, "jest", NodeModuleDirectorySearchProcessor.PROCESSOR)) != null) {
            jestVersion = new NodePackage(info.getModuleSourceRoot().getPath()).getVersion();
        }
        return jestVersion == null || jestVersion.isGreaterOrEqualThan(22, 0, 0);
    }

    @Nullable
    private List<String> getTestFilePaths(@NotNull JestScopeKind scopeKind, @NotNull NodeJsInterpreter interpreter) {
        if (scopeKind == null) {
            JestRunProfileState.$$$reportNull$$$0(10);
        }
        if (interpreter == null) {
            JestRunProfileState.$$$reportNull$$$0(11);
        }
        if (this.myFailedTests != null) {
            List paths = ContainerUtil.map(this.myFailedTests, failedTest -> NodeInterpreterUtil.convertLocalPathToRemote(failedTest.getTestFilePath(), interpreter));
            return new ArrayList<String>(new HashSet(paths));
        }
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return Collections.singletonList(NodeInterpreterUtil.convertLocalPathToRemote(this.myRunSettings.getTestFileSystemDependentPath(), interpreter));
        }
        return null;
    }

    @NotNull
    private static String getTestFilePathPattern(@NotNull List<String> testFilePaths) {
        if (testFilePaths == null) {
            JestRunProfileState.$$$reportNull$$$0(12);
        }
        if (testFilePaths.size() == 1) {
            String string = JestUtil.getTestFilePathPattern(testFilePaths.get(0));
            if (string == null) {
                JestRunProfileState.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = "^(" + StringUtil.join(testFilePaths, path -> JestUtil.escapeJavaScriptRegexp(path), (String)"|") + ")$";
        if (string == null) {
            JestRunProfileState.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private String getTestNamePattern(@NotNull JestScopeKind testKind) {
        if (testKind == null) {
            JestRunProfileState.$$$reportNull$$$0(15);
        }
        if (this.myFailedTests != null) {
            return JestRunProfileState.getTestNamesPattern(ContainerUtil.map(this.myFailedTests, failedTest -> failedTest.getTestNames()));
        }
        if (JestScopeKind.SUITE == testKind) {
            return "^" + JestUtil.escapeJavaScriptRegexp(StringUtil.join(this.myRunSettings.getTestNames(), (String)" ")) + " ";
        }
        if (JestScopeKind.TEST == testKind) {
            return JestRunProfileState.getTestNamesPattern(Collections.singletonList(this.myRunSettings.getTestNames()));
        }
        return null;
    }

    @NotNull
    private static String getTestNamesPattern(@NotNull List<List<String>> testNames) {
        List patterns;
        if (testNames == null) {
            JestRunProfileState.$$$reportNull$$$0(16);
        }
        if ((patterns = ContainerUtil.map(testNames, testFqn -> {
            List escaped = ContainerUtil.mapNotNull((Collection)testFqn, s -> JestUtil.escapeJavaScriptRegexp(s));
            return StringUtil.join((Collection)escaped, (String)" ");
        })).isEmpty()) {
            if ("$^" == null) {
                JestRunProfileState.$$$reportNull$$$0(17);
            }
            return "$^";
        }
        String result2 = patterns.size() == 1 ? (String)patterns.get(0) : "(" + StringUtil.join((Collection)patterns, (String)")|(") + ")";
        String string = "^" + result2 + "$";
        if (string == null) {
            JestRunProfileState.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    private static File getOrCreateEmptyInputFile() {
        File input = TEMP_INPUT_FILE;
        if (input == null || !input.isFile()) {
            try {
                input = FileUtil.createTempFile((String)"intellij-jest-empty-input", null, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("jest: cannot create temp file", (Throwable)e);
            }
            TEMP_INPUT_FILE = input;
        }
        return input;
    }

    private void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            JestRunProfileState.$$$reportNull$$$0(19);
        }
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        if (JestUtil.isReactScriptsFamilyPackage(this.myJestPackage)) {
            commandLine.getEnvironment().put("CI", "1");
        }
        if (!Registry.is((String)"jest.test.tree.use.jasmine.reporter", (boolean)true)) {
            commandLine.getEnvironment().put("_JB_INTELLIJ_JASMINE_REPORTER_DISABLED", Boolean.toString(true));
        }
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory, @NotNull JestConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            JestRunProfileState.$$$reportNull$$$0(20);
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)consoleProperties.getTestFrameworkName(), (TestConsoleProperties)consoleProperties);
        consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        for (Filter filter : consoleProperties.getStackTrackFilters()) {
            consoleView.addMessageFilter(filter);
        }
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new JestFilter());
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            JestRunProfileState.$$$reportNull$$$0(21);
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            JestRunProfileState.$$$reportNull$$$0(22);
        }
        if (processHandler == null) {
            JestRunProfileState.$$$reportNull$$$0(23);
        }
        this.myFolder.foldCommandLine(consoleView, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunProfileState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTests";
                break;
            }
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePaths";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFilePathPattern";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamesPattern";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmtRunnerConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendInput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTestFilePaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestFilePathPattern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamePattern";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamesPattern";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSmtRunnerConsoleView";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

