/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.services;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.AuthorizedPublishingAction;
import com.jetbrains.intellij.datalore.api.DataloreController;
import com.jetbrains.intellij.datalore.api.DataloreViewController;
import com.jetbrains.intellij.datalore.models.DataloreApiTokenResponse;
import com.jetbrains.intellij.datalore.models.DatalorePublishingTokenResponse;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DataloreAuthService", storages={@Storage(value="datalore.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000278B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\n\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020(J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0002H\u0016J\u000e\u0010-\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020!J\u0006\u0010/\u001a\u00020!J\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u00103\u001a\u0004\u0018\u0001012\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u00104\u001a\u00020!2\u0006\u00105\u001a\u000206R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR(\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\n\u00a8\u00069"}, d2={"Lcom/jetbrains/intellij/datalore/services/AuthService;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/jetbrains/intellij/datalore/services/AuthService$AuthState;", "()V", "value", "", "email", "getEmail", "()Ljava/lang/String;", "setEmail", "(Ljava/lang/String;)V", "myState", "myValidationLock", "Ljava/lang/Object;", "publishingToken", "getPublishingToken", "setPublishingToken", "publishingTokenOwner", "getPublishingTokenOwner", "setPublishingTokenOwner", "timerTask", "Ljava/util/TimerTask;", "getTimerTask", "()Ljava/util/TimerTask;", "setTimerTask", "(Ljava/util/TimerTask;)V", "token", "getToken", "setToken", "createTimerTask", "client", "Lorg/apache/http/client/HttpClient;", "fireInvalidTokenNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "getState", "getStateModificationCount", "", "hasPublishingToken", "", "isLoggedIn", "isPublishedSignedIn", "loadState", "state", "logIn", "logOut", "publishingSignOut", "receivePublishingToken", "Lcom/jetbrains/intellij/datalore/models/DatalorePublishingTokenResponse;", "receiveToken", "validatePublishingToken", "waitForValidation", "timer", "Ljava/util/Timer;", "AuthState", "Companion", "datalore-intellij-plugin"})
public final class AuthService
implements PersistentStateComponentWithModificationTracker<AuthState> {
    private AuthState myState = new AuthState();
    private final Object myValidationLock = new Object();
    @NotNull
    public TimerTask timerTask;
    private static final long CHECK_TOKEN_INTERVAL = 3000L;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getEmail() {
        return this.myState.getEmail();
    }

    public final void setEmail(@Nullable String value) {
        CharSequence charSequence = value;
        AuthState authState = this.myState;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        authState.setEmail(bl3 ? null : value);
    }

    @Nullable
    public final String getToken() {
        return this.myState.getToken();
    }

    public final void setToken(@Nullable String value) {
        this.myState.setToken(value);
    }

    @Nullable
    public final String getPublishingToken() {
        return this.myState.getPublishingToken();
    }

    public final void setPublishingToken(@Nullable String value) {
        CharSequence charSequence = value;
        AuthState authState = this.myState;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        authState.setPublishingToken(bl3 ? null : value);
    }

    @Nullable
    public final String getPublishingTokenOwner() {
        return this.myState.getPublishingTokenOwner();
    }

    public final void setPublishingTokenOwner(@Nullable String value) {
        CharSequence charSequence = value;
        AuthState authState = this.myState;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        authState.setPublishingTokenOwner(bl3 ? null : value);
    }

    @NotNull
    public final TimerTask getTimerTask() {
        TimerTask timerTask = this.timerTask;
        if (timerTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timerTask");
        }
        return timerTask;
    }

    public final void setTimerTask(@NotNull TimerTask timerTask) {
        Intrinsics.checkParameterIsNotNull((Object)timerTask, (String)"<set-?>");
        this.timerTask = timerTask;
    }

    private final TimerTask createTimerTask(HttpClient client) {
        return new TimerTask(this, client){
            final /* synthetic */ AuthService this$0;
            final /* synthetic */ HttpClient $client;

            public void run() {
                DatalorePublishingTokenResponse receivedResponse;
                DatalorePublishingTokenResponse datalorePublishingTokenResponse = receivedResponse = this.this$0.validatePublishingToken(this.$client);
                if (datalorePublishingTokenResponse != null) {
                    if (datalorePublishingTokenResponse.isValidated()) {
                        this.cancel();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                Object object = AuthService.access$getMyValidationLock$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    AuthService.access$getMyValidationLock$p(this.this$0).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
                return super.cancel();
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
            }
        };
    }

    @Nullable
    public AuthState getState() {
        return this.myState;
    }

    public void loadState(@NotNull AuthState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        this.myState = state;
    }

    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    public final boolean isLoggedIn() {
        return this.myState.getToken() != null;
    }

    public final boolean logIn(@NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        this.myState.setEmail(email);
        String string = this.receiveToken(email);
        if (string == null) {
            return false;
        }
        this.myState.setToken(string);
        return true;
    }

    public final void logOut() {
        this.myState.setToken(null);
    }

    public final boolean isPublishedSignedIn() {
        return this.myState.getPublishingToken() != null && this.myState.getPublishingTokenOwner() != null;
    }

    public final void publishingSignOut() {
        String token = this.myState.getPublishingToken();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(token){
            final /* synthetic */ String $token;

            public final void run() {
                if (this.$token != null) {
                    DataloreViewController.INSTANCE.callRevokeToken(this.$token);
                }
            }
            {
                this.$token = string;
            }
        });
        this.myState.setPublishingToken(null);
        this.myState.setPublishingTokenOwner(null);
    }

    public final boolean hasPublishingToken() {
        return this.myState.getPublishingToken() != null;
    }

    @Nullable
    public final DatalorePublishingTokenResponse receivePublishingToken(@NotNull HttpClient client) {
        DatalorePublishingTokenResponse response;
        DatalorePublishingTokenResponse datalorePublishingTokenResponse;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.publishingSignOut();
        String string = DataloreViewController.INSTANCE.callGetToken(client);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            datalorePublishingTokenResponse = DatalorePublishingTokenResponse.Companion.fromString(it);
        } else {
            datalorePublishingTokenResponse = null;
        }
        DatalorePublishingTokenResponse datalorePublishingTokenResponse2 = response = datalorePublishingTokenResponse;
        this.myState.setPublishingToken(datalorePublishingTokenResponse2 != null ? datalorePublishingTokenResponse2.getValue() : null);
        return response;
    }

    @Nullable
    public final DatalorePublishingTokenResponse validatePublishingToken(@NotNull HttpClient client) {
        DatalorePublishingTokenResponse response;
        DatalorePublishingTokenResponse datalorePublishingTokenResponse;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        String string = this.myState.getPublishingToken();
        if (string == null) {
            return null;
        }
        String token = string;
        String string2 = DataloreViewController.INSTANCE.callGetTokenStatus(token, client);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            datalorePublishingTokenResponse = DatalorePublishingTokenResponse.Companion.fromString(it);
        } else {
            datalorePublishingTokenResponse = response = null;
        }
        if (response != null) {
            this.myState.setPublishingToken(response.getValue());
            this.myState.setPublishingTokenOwner(response.getOwnerId());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForValidation(@NotNull Timer timer) {
        CloseableHttpClient client;
        Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
        CloseableHttpClient closeableHttpClient = client = HttpClients.createDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
        TimerTask timerTask = this.timerTask = this.createTimerTask((HttpClient)closeableHttpClient);
        if (timerTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timerTask");
        }
        timer.scheduleAtFixedRate(timerTask, 0L, 3000L);
        Object object = this.myValidationLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.myValidationLock.wait();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void fireInvalidTokenNotification(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Notification notification = new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getFAIL_ICON(), DataloreBundle.INSTANCE.message("datalore.publishing.notification.invalid_token.title", new Object[0]), null, DataloreBundle.INSTANCE.message("datalore.publishing.notification.invalid_token.description", new Object[0]), NotificationType.ERROR, null);
        notification.addAction((AnAction)new AuthorizedPublishingAction(notification, DataloreBundle.INSTANCE.message("datalore.publishing.notification.invalid_token.action.try_again", new Object[0]), false){
            final /* synthetic */ Notification $notification;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$notification.expire();
                super.actionPerformed(e);
            }
            {
                this.$notification = $captured_local_variable$0;
                super($super_call_param$1, null, null, $super_call_param$2, 6, null);
            }
        });
        notification.notify(project);
    }

    private final String receiveToken(String email) {
        String string = DataloreController.INSTANCE.callApiToken(email);
        if (string == null) {
            return null;
        }
        String response = string;
        Json json = new Json(JsonConfiguration.Companion.getStable(), null, 2, null);
        DataloreApiTokenResponse parsed = (DataloreApiTokenResponse)json.parse((DeserializationStrategy)DataloreApiTokenResponse.Companion.serializer(), response);
        return parsed.getToken();
    }

    private AuthService() {
    }

    public static final /* synthetic */ Object access$getMyValidationLock$p(AuthService $this) {
        return $this.myValidationLock;
    }

    @JvmStatic
    @NotNull
    public static final AuthService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR/\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR/\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR/\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u000b\u001a\u0004\b\u0015\u0010\u0007\"\u0004\b\u0016\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/intellij/datalore/services/AuthService$AuthState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "email", "getEmail", "()Ljava/lang/String;", "setEmail", "(Ljava/lang/String;)V", "email$delegate", "Lkotlin/properties/ReadWriteProperty;", "publishingToken", "getPublishingToken", "setPublishingToken", "publishingToken$delegate", "publishingTokenOwner", "getPublishingTokenOwner", "setPublishingTokenOwner", "publishingTokenOwner$delegate", "token", "getToken", "setToken", "token$delegate", "datalore-intellij-plugin"})
    public static final class AuthState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @Nullable
        private final ReadWriteProperty email$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @Nullable
        private final ReadWriteProperty token$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
        @Nullable
        private final ReadWriteProperty publishingToken$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[2]);
        @Nullable
        private final ReadWriteProperty publishingTokenOwner$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[3]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthState.class), "email", "getEmail()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthState.class), "token", "getToken()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthState.class), "publishingToken", "getPublishingToken()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthState.class), "publishingTokenOwner", "getPublishingTokenOwner()Ljava/lang/String;"))};
        }

        @Nullable
        public final String getEmail() {
            return (String)this.email$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setEmail(@Nullable String string) {
            this.email$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @Nullable
        public final String getToken() {
            return (String)this.token$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setToken(@Nullable String string) {
            this.token$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        @Nullable
        public final String getPublishingToken() {
            return (String)this.publishingToken$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setPublishingToken(@Nullable String string) {
            this.publishingToken$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
        }

        @Nullable
        public final String getPublishingTokenOwner() {
            return (String)this.publishingTokenOwner$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        public final void setPublishingTokenOwner(@Nullable String string) {
            this.publishingTokenOwner$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/intellij/datalore/services/AuthService$Companion;", "", "()V", "CHECK_TOKEN_INTERVAL", "", "getInstance", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "datalore-intellij-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AuthService getInstance() {
            boolean $i$f$service = false;
            Object object = ServiceManager.getService(AuthService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (AuthService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

