/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing.handlers;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.NotebookUpdateException;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.PublishingActionWithResultHandler;
import com.jetbrains.intellij.datalore.api.InvalidTokenException;
import com.jetbrains.intellij.datalore.api.NotExistingNotebookException;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.statistics.DataloreActionsCounterCollector;
import com.jetbrains.intellij.datalore.statistics.LoggedActionWithResult;
import com.jetbrains.intellij.datalore.util.BackgroundableCancellableTaskWithTimer;
import com.jetbrains.intellij.datalore.util.StringUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/handlers/PublishingUpdateHandler;", "Lcom/jetbrains/intellij/datalore/actions/publishing/handlers/PublishingActionWithResultHandler;", "project", "Lcom/intellij/openapi/project/Project;", "notebook", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "fireDeleted", "", "handle", "update", "datalore-intellij-plugin"})
public final class PublishingUpdateHandler
extends PublishingActionWithResultHandler {
    @Override
    public void handle() {
        CloseableHttpClient client = HttpClients.createDefault();
        BackgroundableCancellableTaskWithTimer checkStatusTask2 = new BackgroundableCancellableTaskWithTimer(this, client, this.getMyProject(), DataloreBundle.INSTANCE.message("datalore.publishing.common.getting_meta.progress", new Object[0])){
            final /* synthetic */ PublishingUpdateHandler this$0;
            final /* synthetic */ CloseableHttpClient $client;

            protected void doRun(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                try {
                    PublishingService publishingService = this.this$0.getMyPublishingService();
                    VirtualFile virtualFile = this.this$0.getMyNotebook();
                    CloseableHttpClient closeableHttpClient = this.$client;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
                    if (publishingService.fetchAndUpdateNotebookStatus(virtualFile, (HttpClient)closeableHttpClient) == null) {
                        throw (Throwable)new NotebookUpdateException();
                    }
                }
                catch (NotExistingNotebookException e) {
                    PublishingUpdateHandler.access$fireDeleted(this.this$0);
                    throw (Throwable)e;
                }
                catch (InvalidTokenException e) {
                    AuthService authService = this.this$0.getMyAuthService();
                    Project project = this.myProject;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                    authService.fireInvalidTokenNotification(project);
                    throw (Throwable)e;
                }
            }

            protected void doOnCancel() {
                DataloreActionsCounterCollector.INSTANCE.countCancel(LoggedActionWithResult.UPDATE);
                this.$client.close();
            }

            public void onSuccess() {
                super.onSuccess();
                PublishingService.PublishedNotebookState state = this.this$0.getMyPublishingService().getNotebookState(this.this$0.getMyNotebook());
                if (state == null) {
                    PublishingUpdateHandler.access$fireDeleted(this.this$0);
                } else {
                    PublishingUpdateHandler.access$update(this.this$0);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.UPDATE);
                if (error instanceof NotebookUpdateException) {
                    this.this$0.onFail();
                }
                super.onThrowable(error);
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, 0L, 0L, false, 28, null);
            }
        };
        checkStatusTask2.queue();
    }

    private final void update() {
        CloseableHttpClient client = HttpClients.createDefault();
        BackgroundableCancellableTaskWithTimer updateTask2 = new BackgroundableCancellableTaskWithTimer(this, client, this.getMyProject(), DataloreBundle.INSTANCE.message("datalore.publishing.update.progress", this.getMyNotebookTrimmedName())){
            final /* synthetic */ PublishingUpdateHandler this$0;
            final /* synthetic */ CloseableHttpClient $client;

            protected void doRun(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                try {
                    PublishingService publishingService = this.this$0.getMyPublishingService();
                    VirtualFile virtualFile = this.this$0.getMyNotebook();
                    CloseableHttpClient closeableHttpClient = this.$client;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
                    if (publishingService.callUpdate(virtualFile, closeableHttpClient) == null) {
                        throw (Throwable)new NotebookUpdateException();
                    }
                }
                catch (InvalidTokenException e) {
                    AuthService authService = this.this$0.getMyAuthService();
                    Project project = this.myProject;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                    authService.fireInvalidTokenNotification(project);
                    throw (Throwable)e;
                }
                catch (NotExistingNotebookException e) {
                    PublishingUpdateHandler.access$fireDeleted(this.this$0);
                    throw (Throwable)e;
                }
            }

            protected void doOnCancel() {
                DataloreActionsCounterCollector.INSTANCE.countCancel(LoggedActionWithResult.UPDATE);
                this.$client.close();
            }

            public void onSuccess() {
                super.onSuccess();
                PublishingService.PublishedNotebookState notebookState = this.this$0.getMyPublishingService().getNotebookState(this.this$0.getMyNotebook());
                if (notebookState == null) {
                    DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.UPDATE);
                    this.this$0.onFail();
                } else {
                    DataloreActionsCounterCollector.INSTANCE.countSuccess(LoggedActionWithResult.UPDATE);
                    this.this$0.onSuccess(notebookState);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                DataloreActionsCounterCollector.INSTANCE.countError(LoggedActionWithResult.UPDATE);
                if (error instanceof NotebookUpdateException) {
                    this.this$0.onFail();
                }
                super.onThrowable(error);
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, 0L, 0L, false, 28, null);
            }
        };
        updateTask2.queue();
    }

    private final void fireDeleted() {
        this.getMyPublishingService().fireNotebookDeletedNotification(this.getMyNotebook(), DataloreBundle.INSTANCE.message("datalore.publishing.update.notification.error.title", this.getMyNotebookTrimmedName()));
    }

    public PublishingUpdateHandler(@NotNull Project project, @NotNull VirtualFile notebook) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
        super(project, notebook, DataloreBundle.INSTANCE.message("datalore.publishing.update.notification.ok.title", StringUtilKt.trimInMiddle$default(notebook, 0, 1, null)), DataloreBundle.INSTANCE.message("datalore.publishing.update.notification.error.title", StringUtilKt.trimInMiddle(notebook, 23)), DataloreBundle.INSTANCE.message("datalore.publishing.update.notification.error.description", new Object[0]));
    }

    public static final /* synthetic */ void access$fireDeleted(PublishingUpdateHandler $this) {
        $this.fireDeleted();
    }

    public static final /* synthetic */ void access$update(PublishingUpdateHandler $this) {
        $this.update();
    }
}

