/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.completion.tracker.PositionTrackingListener;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.reporting.PermissionsKt;
import com.intellij.stats.completion.CompletionActionsTracker;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.CompletionLoggerProvider;
import com.intellij.stats.completion.CompletionPopupListener;
import com.intellij.stats.completion.CompletionTrackerInitializer;
import com.intellij.stats.completion.CompletionUtil;
import com.intellij.stats.completion.LookupActionsListener;
import com.intellij.stats.completion.LookupCompletedTracker;
import com.intellij.stats.completion.LookupExtensionsKt;
import com.intellij.stats.completion.LookupStartedTracker;
import com.intellij.stats.completion.TimeBetweenTypingTracker;
import com.intellij.stats.experiment.WebServiceStatus;
import com.intellij.stats.personalization.UserFactor;
import com.intellij.stats.personalization.UserFactorDescriptions;
import com.intellij.stats.personalization.UserFactorStorage;
import com.intellij.stats.personalization.UserFactorsManager;
import com.intellij.util.messages.MessageBusConnection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/stats/completion/CompletionTrackerInitializer;", "Lcom/intellij/openapi/Disposable;", "experimentHelper", "Lcom/intellij/stats/experiment/WebServiceStatus;", "(Lcom/intellij/stats/experiment/WebServiceStatus;)V", "actionListener", "Lcom/intellij/stats/completion/LookupActionsListener;", "lookupTrackerInitializer", "Ljava/beans/PropertyChangeListener;", "actionsTracker", "Lcom/intellij/stats/completion/CompletionActionsTracker;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "dispose", "", "initComponent", "processUserFactors", "sessionShouldBeLogged", "", "language", "Lcom/intellij/lang/Language;", "shouldInitialize", "shouldTrackSession", "shouldUseUserFactors", "Companion", "intellij.statsCollector"})
public final class CompletionTrackerInitializer
implements Disposable {
    private final LookupActionsListener actionListener;
    private final PropertyChangeListener lookupTrackerInitializer;
    private static boolean isEnabledInTests;
    private static final Map<String, Double> LOGGED_SESSIONS_RATIO;
    public static final Companion Companion;

    private final CompletionActionsTracker actionsTracker(LookupImpl lookup, WebServiceStatus experimentHelper) {
        CompletionLogger logger = CompletionLoggerProvider.Companion.getInstance().newCompletionLogger();
        return new CompletionActionsTracker(lookup, logger, experimentHelper);
    }

    private final boolean shouldInitialize() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        return application.isEAP() && StatisticsUploadAssistant.isSendAllowed() || PermissionsKt.isUnitTestMode();
    }

    private final boolean shouldTrackSession() {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        return completionMLRankingSettings.isCompletionLogsSendAllowed() || PermissionsKt.isUnitTestMode();
    }

    private final boolean shouldUseUserFactors() {
        return UserFactorsManager.Companion.getENABLE_USER_FACTORS();
    }

    private final boolean sessionShouldBeLogged(WebServiceStatus experimentHelper, Language language) {
        Application application = ApplicationManager.getApplication();
        if (Registry.is((String)"completion.stats.show.ml.ranking.diff")) {
            return false;
        }
        Application application2 = application;
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
        if (application2.isUnitTestMode() || experimentHelper.isExperimentOnCurrentIDE()) {
            return true;
        }
        double logSessionChance = 0.0;
        if (language != null) {
            String string = language.getDisplayName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"language.displayName");
            String string2 = string;
            Map<String, Double> map = LOGGED_SESSIONS_RATIO;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            String string5 = string4;
            logSessionChance = ((Number)map.getOrDefault(string5, 1.0)).doubleValue();
        }
        return Random.Default.nextDouble() < logSessionChance;
    }

    private final void processUserFactors(LookupImpl lookup) {
        UserFactor it;
        Map map;
        if (!this.shouldUseUserFactors()) {
            return;
        }
        List<UserFactor> userFactors = UserFactorsManager.Companion.getInstance().getAllFactors();
        boolean bl = false;
        Map userFactorValues = new LinkedHashMap();
        Iterable $this$associateTo$iv = userFactors;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            map = userFactorValues;
            it = (UserFactor)element$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)(it.getId() + ":App"), (Object)it.compute(UserFactorStorage.Companion.getInstance()));
            bl2 = false;
            map.put(it.getFirst(), it.getSecond());
        }
        $this$associateTo$iv = userFactors;
        $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            map = userFactorValues;
            it = (UserFactor)element$iv;
            boolean bl3 = false;
            String string = it.getId() + ":Project";
            Project project = lookup.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"lookup.project");
            Pair pair = TuplesKt.to((Object)string, (Object)it.compute(UserFactorStorage.Companion.getInstance(project)));
            boolean bl4 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        lookup.putUserData(UserFactorsManager.Companion.getUSER_FACTORS_KEY(), (Object)userFactorValues);
        Project project = lookup.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"lookup.project");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_USAGE(), processUserFactors.3.INSTANCE);
        Project project2 = lookup.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"lookup.project");
        lookup.setPrefixChangeListener((PrefixChangeListener)new TimeBetweenTypingTracker(project2));
        lookup.addLookupListener((LookupListener)new LookupCompletedTracker());
        lookup.addLookupListener((LookupListener)new LookupStartedTracker());
    }

    private final void initComponent() {
        if (!this.shouldInitialize()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026.messageBus.connect(this)");
        MessageBusConnection busConnection = messageBusConnection;
        busConnection.subscribe(AnActionListener.TOPIC, (Object)this.actionListener);
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(this){
            final /* synthetic */ CompletionTrackerInitializer this$0;

            public void projectOpened(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                LookupManager lookupManager = LookupManager.getInstance((Project)project);
                lookupManager.addPropertyChangeListener(CompletionTrackerInitializer.access$getLookupTrackerInitializer$p(this.this$0));
            }

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                LookupManager lookupManager = LookupManager.getInstance((Project)project);
                lookupManager.removePropertyChangeListener(CompletionTrackerInitializer.access$getLookupTrackerInitializer$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void dispose() {
    }

    public CompletionTrackerInitializer(@NotNull WebServiceStatus experimentHelper) {
        Intrinsics.checkParameterIsNotNull((Object)experimentHelper, (String)"experimentHelper");
        this.actionListener = new LookupActionsListener();
        this.lookupTrackerInitializer = new PropertyChangeListener(this, experimentHelper){
            final /* synthetic */ CompletionTrackerInitializer this$0;
            final /* synthetic */ WebServiceStatus $experimentHelper;

            public final void propertyChange(PropertyChangeEvent it) {
                PropertyChangeEvent propertyChangeEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyChangeEvent, (String)"it");
                Object lookup = propertyChangeEvent.getNewValue();
                if (lookup == null || !CompletionTrackerInitializer.access$shouldTrackSession(this.this$0)) {
                    CompletionTrackerInitializer.access$getActionListener$p(this.this$0).setListener(new CompletionPopupListener.Adapter());
                } else if (lookup instanceof LookupImpl) {
                    if (PermissionsKt.isUnitTestMode() && !CompletionTrackerInitializer.Companion.isEnabledInTests()) {
                        return;
                    }
                    ((LookupImpl)lookup).putUserData(CompletionUtil.INSTANCE.getCOMPLETION_STARTING_TIME_KEY(), (Object)System.currentTimeMillis());
                    CompletionTrackerInitializer.access$processUserFactors(this.this$0, (LookupImpl)lookup);
                    PositionTrackingListener shownTimesTracker = new PositionTrackingListener((LookupImpl)lookup);
                    ((LookupImpl)lookup).setPrefixChangeListener((PrefixChangeListener)shownTimesTracker);
                    if (CompletionTrackerInitializer.access$sessionShouldBeLogged(this.this$0, this.$experimentHelper, LookupExtensionsKt.language((LookupImpl)lookup))) {
                        CompletionActionsTracker tracker = CompletionTrackerInitializer.access$actionsTracker(this.this$0, (LookupImpl)lookup, this.$experimentHelper);
                        CompletionTrackerInitializer.access$getActionListener$p(this.this$0).setListener(tracker);
                        ((LookupImpl)lookup).addLookupListener((LookupListener)tracker);
                        ((LookupImpl)lookup).setPrefixChangeListener((PrefixChangeListener)tracker);
                    }
                }
            }
            {
                this.this$0 = completionTrackerInitializer;
                this.$experimentHelper = webServiceStatus;
            }
        };
        this.initComponent();
    }

    static {
        Companion = new Companion(null);
        LOGGED_SESSIONS_RATIO = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"python", (Object)0.5), TuplesKt.to((Object)"scala", (Object)0.3), TuplesKt.to((Object)"php", (Object)0.3), TuplesKt.to((Object)"kotlin", (Object)0.2), TuplesKt.to((Object)"java", (Object)0.1)});
    }

    public static final /* synthetic */ PropertyChangeListener access$getLookupTrackerInitializer$p(CompletionTrackerInitializer $this) {
        return $this.lookupTrackerInitializer;
    }

    public static final /* synthetic */ boolean access$shouldTrackSession(CompletionTrackerInitializer $this) {
        return $this.shouldTrackSession();
    }

    public static final /* synthetic */ LookupActionsListener access$getActionListener$p(CompletionTrackerInitializer $this) {
        return $this.actionListener;
    }

    public static final /* synthetic */ void access$processUserFactors(CompletionTrackerInitializer $this, LookupImpl lookup) {
        $this.processUserFactors(lookup);
    }

    public static final /* synthetic */ boolean access$sessionShouldBeLogged(CompletionTrackerInitializer $this, WebServiceStatus experimentHelper, Language language) {
        return $this.sessionShouldBeLogged(experimentHelper, language);
    }

    public static final /* synthetic */ CompletionActionsTracker access$actionsTracker(CompletionTrackerInitializer $this, LookupImpl lookup, WebServiceStatus experimentHelper) {
        return $this.actionsTracker(lookup, experimentHelper);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/stats/completion/CompletionTrackerInitializer$Companion;", "", "()V", "LOGGED_SESSIONS_RATIO", "", "", "", "isEnabledInTests", "", "()Z", "setEnabledInTests", "(Z)V", "intellij.statsCollector"})
    public static final class Companion {
        public final boolean isEnabledInTests() {
            return isEnabledInTests;
        }

        public final void setEnabledInTests(boolean bl) {
            isEnabledInTests = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

