/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.string;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public class JSJoinConcatenatedStringLiteralsIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        StringConcatPredicate stringConcatPredicate = new StringConcatPredicate();
        if (stringConcatPredicate == null) {
            JSJoinConcatenatedStringLiteralsIntention.$$$reportNull$$$0(0);
        }
        return stringConcatPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSJoinConcatenatedStringLiteralsIntention.$$$reportNull$$$0(1);
        }
        JSBinaryExpression expression = (JSBinaryExpression)element;
        JSLiteralExpression lhs = (JSLiteralExpression)expression.getLOperand();
        JSLiteralExpression rhs = (JSLiteralExpression)expression.getROperand();
        boolean needTemplateString = lhs instanceof JSStringTemplateExpression || rhs instanceof JSStringTemplateExpression;
        char quoteChar = needTemplateString ? (char)'`' : (char)String.valueOf(lhs.getText()).charAt(0);
        String newStr = quoteChar + lhs.getText().substring(1, lhs.getTextLength() - 1) + rhs.getText().substring(1, rhs.getTextLength() - 1) + quoteChar;
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expression, (String)newStr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/string/JSJoinConcatenatedStringLiteralsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/string/JSJoinConcatenatedStringLiteralsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringConcatPredicate
    implements JSElementPredicate {
        private StringConcatPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                StringConcatPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression expression = (JSBinaryExpression)element;
            IElementType sign = expression.getOperationSign();
            if (sign == null || !sign.equals(JSTokenTypes.PLUS)) {
                return false;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            if (!StringConcatPredicate.isApplicableLiteral(lhs)) {
                return false;
            }
            return StringConcatPredicate.isApplicableLiteral(rhs);
        }

        private static boolean isApplicableLiteral(JSExpression lhs) {
            return lhs instanceof JSLiteralExpression && ((JSLiteralExpression)lhs).isQuotedLiteral();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/string/JSJoinConcatenatedStringLiteralsIntention$StringConcatPredicate", "satisfiedBy"));
        }
    }
}

