/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.constant;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.constant.JSConstantExpressionIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConstantSubexpressionIntention
extends JSMutablyNamedIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        ConstantSubexpressionPredicate constantSubexpressionPredicate = new ConstantSubexpressionPredicate();
        if (constantSubexpressionPredicate == null) {
            JSConstantSubexpressionIntention.$$$reportNull$$$0(0);
        }
        return constantSubexpressionPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiElement parent = element.getParent();
        JSBinaryExpression binaryExpression = (JSBinaryExpression)(parent instanceof JSBinaryExpression ? parent : element);
        JSExpression lhs = binaryExpression.getLOperand();
        JSExpression leftSide = lhs instanceof JSBinaryExpression ? ((JSBinaryExpression)lhs).getROperand() : lhs;
        JSExpression rhs = binaryExpression.getROperand();
        assert (rhs != null);
        assert (leftSide != null);
        String optionalSign = lhs instanceof JSBinaryExpression && ((JSBinaryExpression)lhs).getOperationSign() == JSTokenTypes.MINUS ? "-" : "";
        return this.getText(optionalSign + leftSide.getText(), binaryExpression.getOperationNode().getText(), rhs.getText());
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        Object constantValue;
        PsiElement parent;
        if (element == null) {
            JSConstantSubexpressionIntention.$$$reportNull$$$0(1);
        }
        JSExpression expression = (JSExpression)((parent = element.getParent()) instanceof JSBinaryExpression ? parent : element);
        String newExpression = "";
        if (expression instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            JSExpression lhs = binaryExpression.getLOperand();
            constantValue = ExpressionUtil.computeConstantExpression((JSExpression)JSConstantSubexpressionIntention.getSubexpression(binaryExpression));
            if (lhs instanceof JSBinaryExpression) {
                JSBinaryExpression lhsBinaryExpression = (JSBinaryExpression)lhs;
                JSExpression rightSide = lhsBinaryExpression.getROperand();
                newExpression = newExpression + lhsBinaryExpression.getLOperand().getText();
                if (constantValue instanceof Number && JSTokenTypes.ADDITIVE_OPERATIONS.contains(lhsBinaryExpression.getOperationSign())) {
                    if (((Number)constantValue).doubleValue() >= 0.0) {
                        newExpression = newExpression + "+";
                    }
                } else {
                    newExpression = newExpression + lhsBinaryExpression.getOperationNode().getText();
                }
                assert (rightSide != null);
            }
        } else {
            constantValue = ExpressionUtil.computeConstantExpression((JSExpression)expression);
        }
        newExpression = newExpression + JSConstantExpressionIntention.formatValue(constantValue, expression);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expression, (String)newExpression);
    }

    @Nullable
    private static JSBinaryExpression getSubexpression(JSBinaryExpression expression) {
        if (expression instanceof JSCommaExpression) {
            return null;
        }
        JSExpression rhs = expression.getROperand();
        int parentPrecendence = JSParenthesesUtils.getPrecedence((JSExpression)expression);
        if (rhs == null) {
            return null;
        }
        JSExpression lhs = expression.getLOperand();
        if (!(lhs instanceof JSBinaryExpression)) {
            return expression;
        }
        JSBinaryExpression lhsBinaryExpression = (JSBinaryExpression)lhs;
        int childPrecendence = JSParenthesesUtils.getPrecedence((JSExpression)lhsBinaryExpression);
        JSExpression leftSide = lhsBinaryExpression.getROperand();
        if (leftSide == null) {
            return null;
        }
        if (parentPrecendence > childPrecendence) {
            return null;
        }
        try {
            String optionalSign = lhsBinaryExpression.getOperationSign() == JSTokenTypes.MINUS ? "-" : "";
            String leftSideText = InjectedLanguageManager.getInstance((Project)leftSide.getProject()).getUnescapedText((PsiElement)leftSide);
            String rightSideText = InjectedLanguageManager.getInstance((Project)leftSide.getProject()).getUnescapedText((PsiElement)rhs);
            String subExpressionText = optionalSign + leftSideText + expression.getOperationNode().getText() + rightSideText;
            return (JSBinaryExpression)JSPsiElementFactory.createJSExpression((String)subExpressionText, (PsiElement)expression, JSBinaryExpression.class);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/constant/JSConstantSubexpressionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/constant/JSConstantSubexpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstantSubexpressionPredicate
    implements JSElementPredicate {
        private ConstantSubexpressionPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSBinaryExpression binaryExpression;
            JSBinaryExpression subexpression;
            if (element == null) {
                ConstantSubexpressionPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSElement) && !(element.getPrevSibling() instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSBinaryExpression)) {
                if (element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getLOperand() instanceof JSBinaryExpression) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if ((subexpression = JSConstantSubexpressionIntention.getSubexpression(binaryExpression = (JSBinaryExpression)parent)) == null) {
                return false;
            }
            if (binaryExpression.equals(subexpression) && !ConstantSubexpressionPredicate.isPartOfConstantExpression(binaryExpression)) {
                return false;
            }
            if (!ExpressionUtil.isConstantExpression((JSExpression)subexpression, (boolean)false)) {
                return false;
            }
            return ExpressionUtil.computeConstantExpression((JSExpression)subexpression) != null;
        }

        private static boolean isPartOfConstantExpression(JSBinaryExpression binaryExpression) {
            PsiElement containingElement = binaryExpression.getParent();
            return containingElement instanceof JSExpression && ExpressionUtil.isConstantExpression((JSExpression)((JSExpression)containingElement), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantSubexpressionIntention$ConstantSubexpressionPredicate", "satisfiedBy"));
        }
    }
}

