/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.DockerIcons;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeDeploymentSourceType
extends DockerSingletonDeploymentSourceType {
    private static final String DEFAULT_FILE_NAME = "docker-compose.yml";
    static final String ID = "docker-compose.yml";
    private static final String CLI_OPTION_FORCE_BUILD = "--build";

    public static DockerComposeDeploymentSourceType getInstance() {
        return (DockerComposeDeploymentSourceType)DockerComposeDeploymentSourceType.findExtension(DockerComposeDeploymentSourceType.class);
    }

    public DockerComposeDeploymentSourceType() {
        super("docker-compose.yml", DockerBundle.getText("DockerComposeDeploymentSourceType.name", new Object[0]), DockerIcons.DockerComposeDeploymentSource);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerApplicationRuntime runtime) {
        if (configuration == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(0);
        }
        String[] folderAndFile = DockerComposeDeploymentSourceType.lastTwoSegments(configuration.getSourceFilePath()).split("/+");
        String string = DockerBundle.getText("DockerComposeDeploymentSourceType.deploymentName", folderAndFile[0]);
        if (string == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(3);
        }
        super.checkDeploymentConfiguration(project, configuration);
        File composeFile = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(project, configuration);
        if (composeFile == null) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerComposeDeploymentSourceType.error.path.required", new Object[0]));
        }
        if (!composeFile.exists() || !composeFile.isFile()) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerComposeDeploymentSourceType.error.file.does.not.exist", composeFile));
        }
    }

    @Override
    @Nullable
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        String sourceFilePath;
        if (configuration == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)(sourceFilePath = configuration.getSourceFilePath()))) {
            return null;
        }
        StringBuilder name = new StringBuilder(StringUtil.trimEnd((String)DockerComposeDeploymentSourceType.lastTwoSegments(sourceFilePath), (String)"/docker-compose.yml"));
        List<String> services = configuration.getServices();
        switch (services.size()) {
            case 0: {
                break;
            }
            case 1: {
                name.append('.').append(services.get(0));
                break;
            }
            default: {
                name.append(services.toString());
            }
        }
        return DockerBundle.getText("DockerComposeDeploymentSourceType.suggestRunConfigurationName", name.toString());
    }

    public void applyForceBuild(@NotNull DockerDeploymentConfiguration configuration, boolean forceBuild) {
        if (configuration == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(5);
        }
        configuration.setRunCliOptions(forceBuild ? CLI_OPTION_FORCE_BUILD : null);
    }

    public boolean isForceBuild(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerComposeDeploymentSourceType.$$$reportNull$$$0(6);
        }
        return CLI_OPTION_FORCE_BUILD.equals(configuration.getRunCliOptions());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDeploymentName";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyForceBuild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isForceBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

