/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.action.ImageActionBase;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateContainerAction
extends ImageActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        String theOnlyTag;
        Project project;
        if (e == null) {
            CreateContainerAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DeploymentNode node = ApplicationActionUtils.getDeploymentTarget((AnActionEvent)e);
        DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)node, DockerApplicationRuntime.class));
        if (applicationRuntime == null) {
            return;
        }
        Set tags = (Set)ObjectUtils.notNull(applicationRuntime.getImageRepoTags(), Collections.emptySet());
        String string = theOnlyTag = tags.size() == 1 ? (String)ContainerUtil.getFirstItem((Collection)tags) : null;
        if ("<none>:<none>".equals(theOnlyTag)) {
            theOnlyTag = null;
        }
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        ListPopup popup = new Case(project, (RemoteServer<DockerCloudConfiguration>)server, applicationRuntime.getImageId(), theOnlyTag).createPopup();
        if (e.getInputEvent() instanceof MouseEvent && e.getInputEvent().getComponent() instanceof ActionButton) {
            popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/CreateContainerAction", "actionPerformed"));
    }

    private static class Case {
        private final DockerCloudType myCloudType = DockerCloudType.getInstance();
        private final Project myProject;
        private final RemoteServer<DockerCloudConfiguration> myServer;
        private final String myImageId;
        private final String myOptionalImageTag;

        Case(Project project, RemoteServer<DockerCloudConfiguration> server, String imageId, @Nullable String optionalImageTag) {
            this.myProject = project;
            this.myServer = server;
            this.myImageId = imageId;
            this.myOptionalImageTag = optionalImageTag;
        }

        public ListPopup createPopup() {
            DeploymentConfigurationManager configurationManager = DeploymentConfigurationManager.getInstance((Project)this.myProject);
            List list = ContainerUtil.filter((Collection)configurationManager.getDeploymentConfigurations((ServerType)this.myCloudType), this::isForTheSameServerAndImage);
            list = ContainerUtil.concat((List)list, Collections.singletonList(null));
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<RunnerAndConfigurationSettings>("Create container", list){

                public Icon getIconFor(RunnerAndConfigurationSettings value) {
                    return null;
                }

                @NotNull
                public String getTextFor(RunnerAndConfigurationSettings value) {
                    String string = value != null ? value.getName() : "Create...";
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(RunnerAndConfigurationSettings selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (selectedValue != null) {
                            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)selectedValue, (Executor)DefaultRunExecutor.getRunExecutorInstance());
                        } else {
                            this.createAndRunImageConfiguration();
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/action/CreateContainerAction$Case$1", "getTextFor"));
                }
            });
        }

        private void createAndRunImageConfiguration() {
            DeploymentSource imageSource = DockerImageDeploymentSourceType.getInstance().getSingletonSource();
            DockerDeploymentConfiguration deploymentConfiguration = this.myCloudType.createDeploymentConfigurator(this.myProject).createDefaultConfiguration(imageSource);
            deploymentConfiguration.setImageTag((String)ObjectUtils.notNull((Object)this.myOptionalImageTag, (Object)this.myImageId));
            new DockerRunConfigurationCreator(this.myProject).setupAndFireDeployment(imageSource, deploymentConfiguration, this.myServer);
        }

        private boolean isForTheSameServerAndImage(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                Case.$$$reportNull$$$0(0);
            }
            DeployToServerRunConfiguration configuration = (DeployToServerRunConfiguration)settings.getConfiguration();
            return StringUtil.equals((CharSequence)this.myServer.getName(), (CharSequence)configuration.getServerName()) && configuration.getDeploymentSource() != null && configuration.getDeploymentSource().getType() instanceof DockerImageDeploymentSourceType && this.isForTheSameImage((DockerDeploymentConfiguration)configuration.getDeploymentConfiguration());
        }

        private boolean isForTheSameImage(@NotNull DockerDeploymentConfiguration configuration) {
            String thatIdOrTag;
            if (configuration == null) {
                Case.$$$reportNull$$$0(1);
            }
            return this.myImageId.equals(thatIdOrTag = configuration.getImageTag()) || this.myOptionalImageTag != null && this.myOptionalImageTag.equals(thatIdOrTag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/action/CreateContainerAction$Case";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isForTheSameServerAndImage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isForTheSameImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

