/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.util.IconLoader;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.impl.TaskUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

abstract class TaskListItem {
    private final String myText;
    private final Icon myIcon;
    private final String mySeparator;
    private final boolean myTemp;
    private final LocalTask myTask;

    TaskListItem(String text, Icon icon) {
        this.myText = text;
        this.myIcon = icon;
        this.mySeparator = null;
        this.myTask = null;
        this.myTemp = false;
    }

    protected TaskListItem(LocalTask task, String separator, boolean temp) {
        this.myTask = task;
        this.mySeparator = separator;
        this.myTemp = temp;
        this.myText = TaskUtil.getTrimmedSummary((Task)task);
        this.myIcon = temp ? IconLoader.getTransparentIcon((Icon)task.getIcon(), (float)0.5f) : task.getIcon();
    }

    public String getText() {
        return this.myText;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public String getSeparator() {
        return this.mySeparator;
    }

    abstract void select();

    @Nullable
    public LocalTask getTask() {
        return this.myTask;
    }

    public boolean isTemp() {
        return this.myTemp;
    }
}

