/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.refactoring.introduceVariable;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssExtractVariableDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiFile myFile;
    private final JBTextField myNameTextField;
    private final JBCheckBox myAllOccurrencesCheckBox;

    public CssExtractVariableDialog(@NotNull Project project, @NotNull PsiFile file, @NotNull String name, int occurrencesCount) {
        if (project == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(1);
        }
        if (name == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myNameTextField = new JBTextField();
        this.myAllOccurrencesCheckBox = new JBCheckBox();
        this.myProject = project;
        this.myFile = file;
        this.myNameTextField.setText(name);
        if (name.startsWith("--")) {
            this.myNameTextField.select(2, name.length());
            this.myNameTextField.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, (Object)true);
        }
        this.myAllOccurrencesCheckBox.setText(occurrencesCount == 1 ? RefactoringBundle.message((String)"replace.all.occurences.checkbox") : RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{occurrencesCount}));
        this.myAllOccurrencesCheckBox.setEnabled(occurrencesCount > 1);
        this.setTitle(RefactoringBundle.message((String)"introduce.variable.title"));
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent("Name:", (JComponent)this.myNameTextField).addComponent((JComponent)this.myAllOccurrencesCheckBox).getPanel();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.getName().startsWith("--")) {
            return new ValidationInfo("Custom property name must start with '--'", (JComponent)this.myNameTextField);
        }
        if (this.getName().equals("--")) {
            return new ValidationInfo("Custom property name can't be '--'", (JComponent)this.myNameTextField);
        }
        if (!((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)CSSLanguage.INSTANCE)).isIdentifier(this.getName(), this.myProject)) {
            return new ValidationInfo("Invalid custom property name", (JComponent)this.myNameTextField);
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)this.myFile);
        if (!StubIndex.getElements(CssCustomPropertyIndex.KEY, (Object)this.getName(), (Project)this.myProject, (GlobalSearchScope)scope, CssDeclaration.class).isEmpty()) {
            return new ValidationInfo("Custom property with this name already exists in the file", (JComponent)this.myNameTextField);
        }
        return null;
    }

    @NotNull
    String getName() {
        String string = this.myNameTextField.getText().trim();
        if (string == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    boolean isReplaceAllOccurrences() {
        return this.myAllOccurrencesCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

