/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.Timer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AsyncProfilerCommandBuilder {
    public static final List<String> DEFAULT_PROFILING_OPTIONS = ContainerUtil.immutableList((Object[])new String[]{"event=cpu", "framebuf=10000000", "interval=10000000"});
    private final String snapshotsPath = System.getProperty("snapshots.path") != null ? System.getProperty("snapshots.path") : FileUtil.createTempDirectory((String)"async", (String)"snapshot", (boolean)false).getAbsolutePath();

    public String getSnapshotsPath() {
        return this.snapshotsPath;
    }

    @NotNull
    public static String buildStartCommand(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(0);
        }
        if (options.isEmpty()) {
            String string = AsyncProfilerCommandBuilder.buildCommand("start", DEFAULT_PROFILING_OPTIONS);
            if (string == null) {
                AsyncProfilerCommandBuilder.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = AsyncProfilerCommandBuilder.buildCommand("start", AsyncProfilerCommandBuilder.mergeParameters(options, DEFAULT_PROFILING_OPTIONS));
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String buildCommand(String initialCommand, @NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(3);
        }
        StringBuilder builder = new StringBuilder(initialCommand);
        for (String option : options) {
            builder.append(",").append(option);
        }
        String string = builder.toString();
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    public List<String> buildStopAndDumpCommands(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(5);
        }
        if (options.isEmpty()) {
            return Collections.singletonList(AsyncProfilerCommandBuilder.buildCommand("stop", Arrays.asList("collapsed", "file=" + this.getDumpFileName("collapsed"))));
        }
        ArrayList<String> dumpOptions = new ArrayList<String>();
        ArrayList<String> profilingOptions = new ArrayList<String>();
        for (String option : options) {
            String trimmedOption;
            List<String> myDumpOptions = Arrays.asList("summary", "traces", "flat", "jfr", "collapsed", "svg", "tree");
            if (myDumpOptions.contains(trimmedOption = option.split("=")[0].trim())) {
                dumpOptions.add(option + ",file=" + this.getDumpFileName(trimmedOption));
                continue;
            }
            profilingOptions.add(option);
        }
        ArrayList<String> stopCommands = new ArrayList<String>();
        for (String option : dumpOptions) {
            stopCommands.add(AsyncProfilerCommandBuilder.buildCommand("stop", AsyncProfilerCommandBuilder.mergeParameters(profilingOptions, Arrays.asList(option.split(",")))));
        }
        return stopCommands;
    }

    private static Map<String, String> parseParametersList(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(6);
        }
        return options.stream().map(option -> option.split("=")).collect(Collectors.toMap(element -> element[0].trim(), element -> ((String[])element).length > 1 ? element[1].trim() : ""));
    }

    @NotNull
    private String getDumpFileName(@NotNull String profilingType) {
        if (profilingType == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(7);
        }
        String time = new SimpleDateFormat("yyyyMMddHHmm").format(new Date(Timer.instance.getStopTime()));
        String fullPath = this.snapshotsPath + File.separator + Timer.instance.getActivityName() + '-' + profilingType + '-' + time;
        switch (profilingType) {
            case "jfr": {
                String string = fullPath + ".jfr";
                if (string == null) {
                    AsyncProfilerCommandBuilder.$$$reportNull$$$0(8);
                }
                return string;
            }
            case "svg": {
                String string = fullPath + ".svg";
                if (string == null) {
                    AsyncProfilerCommandBuilder.$$$reportNull$$$0(9);
                }
                return string;
            }
            case "tree": {
                String string = fullPath + ".html";
                if (string == null) {
                    AsyncProfilerCommandBuilder.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        String string = fullPath + ".txt";
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static List<String> mergeParameters(@NotNull List<String> options, @NotNull List<String> defaultOptions) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(12);
        }
        if (defaultOptions == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(13);
        }
        Map<String, String> userOptions = AsyncProfilerCommandBuilder.parseParametersList(options);
        Map<String, String> defOptions = AsyncProfilerCommandBuilder.parseParametersList(defaultOptions);
        HashMap<String, String> mergedOptions = new HashMap<String, String>(defOptions);
        mergedOptions.putAll(userOptions);
        return ContainerUtil.map(mergedOptions.keySet(), key -> ((String)mergedOptions.get(key)).isEmpty() ? key : key + "=" + (String)mergedOptions.get(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/utils/AsyncProfilerCommandBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilingType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/utils/AsyncProfilerCommandBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStartCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumpFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStartCommand";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildStopAndDumpCommands";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseParametersList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDumpFileName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

