/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.ui.FinishScriptDialog;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;

public class ProjectIndexingComponent
implements ProjectComponent {
    public static final String PROFILE_INDEXING_COMPONENT = "performancePlugin.isProfileIndexing";
    public static final String PROFILE_WITH_ASYNC = "performancePlugin.isProfileIndexingWithAsync";
    private final Project myProject;

    public ProjectIndexingComponent(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new ProjectIndexingListener());
    }

    private class ProjectIndexingListener
    implements DumbService.DumbModeListener {
        private ProjectIndexingListener() {
        }

        public void enteredDumbMode() {
            try {
                if (this.isProfilingEnabled()) {
                    if (!this.profileWithAsync()) {
                        YourKitProfilerHandler.getInstance().startProfiling(ProjectIndexingComponent.this.myProject.getName(), new ArrayList<String>());
                    } else {
                        AsyncProfilerHandler.getInstance().startProfiling(ProjectIndexingComponent.this.myProject.getName(), new ArrayList<String>());
                    }
                }
            }
            catch (Exception e) {
                new ActionCallbackProfilerStopper().reject(e.getMessage());
            }
        }

        public void exitDumbMode() {
            if (this.isProfilingEnabled()) {
                PropertiesComponent.getInstance((Project)ProjectIndexingComponent.this.myProject).setValue(ProjectIndexingComponent.PROFILE_INDEXING_COMPONENT, false);
                PropertiesComponent.getInstance((Project)ProjectIndexingComponent.this.myProject).setValue(ProjectIndexingComponent.PROFILE_WITH_ASYNC, false);
                if (ProfilersController.getInstance().isProfilingStarted()) {
                    try {
                        ProfilersController.getInstance().getCurrentProfilerHandler().stopProfiling(new ArrayList<String>());
                        ProfilersController.getInstance().setStoppedByScript(true);
                    }
                    catch (Exception e) {
                        new ActionCallbackProfilerStopper().setRejected();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> new FinishScriptDialog(ProjectIndexingComponent.this.myProject).show());
                }
            }
        }

        private boolean isProfilingEnabled() {
            return PropertiesComponent.getInstance((Project)ProjectIndexingComponent.this.myProject).getBoolean(ProjectIndexingComponent.PROFILE_INDEXING_COMPONENT);
        }

        private boolean profileWithAsync() {
            return PropertiesComponent.getInstance((Project)ProjectIndexingComponent.this.myProject).getBoolean(ProjectIndexingComponent.PROFILE_WITH_ASYNC);
        }
    }
}

