/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import git4idea.GitVcs;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateProjectInfoLogProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcsPanel
implements ConfigurableUi<GitVcsConfigurable.GitVcsSettingsHolder> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitExecutableManager myExecutableManager;
    private String myApplicationGitPath;
    private volatile boolean versionCheckRequested;
    private JButton myTestButton;
    private JComponent myRootPanel;
    private TextFieldWithBrowseButton myGitField;
    private JBCheckBox myProjectGitPathCheckBox;
    private JCheckBox myAutoUpdateIfPushRejected;
    private JBCheckBox mySyncControl;
    private JCheckBox myAutoCommitOnCherryPick;
    private JCheckBox myAddCherryPickSuffix;
    private JBCheckBox myWarnAboutCrlf;
    private JCheckBox myWarnAboutDetachedHead;
    private JTextField myProtectedBranchesField;
    private JBLabel myProtectedBranchesLabel;
    private JComboBox<UpdateMethod> myUpdateMethodComboBox;
    private JBLabel mySupportedBranchUpLabel;
    private JBCheckBox myPreviewPushOnCommitAndPush;
    private JBCheckBox myPreviewPushProtectedOnly;
    private JPanel myPreviewPushProtectedOnlyBorder;
    private JComboBox<GitIncomingCheckStrategy> myIncomingStrategyComboBox;
    private JPanel myCheckIncomingPanel;
    private JBCheckBox myUseCredHelperCheckbox;
    private JComponent myUpdateProjectInfoFilter;
    private JBLabel myUpdateProjectInfoFilterLabel;

    public GitVcsPanel(@NotNull Project project, @NotNull GitExecutableManager executableManager) {
        if (project == null) {
            GitVcsPanel.$$$reportNull$$$0(0);
        }
        if (executableManager == null) {
            GitVcsPanel.$$$reportNull$$$0(1);
        }
        this.versionCheckRequested = false;
        this.myProject = project;
        this.myExecutableManager = executableManager;
        this.$$$setupUI$$$();
        this.myTestButton.addActionListener(e -> this.testExecutable());
        this.myGitField.addBrowseFolderListener(GitBundle.getString("find.git.title"), GitBundle.getString("find.git.description"), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myProjectGitPathCheckBox.addActionListener(e -> this.handleProjectOverrideStateChanged());
        if (!project.isDefault()) {
            GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
            this.mySyncControl.setVisible(repositoryManager.moreThanOneRoot());
        } else {
            this.mySyncControl.setVisible(true);
        }
        this.mySyncControl.setToolTipText(DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{"Git"}));
        this.myProtectedBranchesLabel.setLabelFor((Component)this.myProtectedBranchesField);
        this.myPreviewPushOnCommitAndPush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitVcsPanel.this.updateEnabled();
            }
        });
        Insets insets = this.myPreviewPushProtectedOnly.getBorder().getBorderInsets((Component)this.myPreviewPushProtectedOnly);
        this.myPreviewPushProtectedOnlyBorder.setBorder((Border)JBUI.Borders.emptyLeft((int)(UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myPreviewPushOnCommitAndPush) - insets.left)));
    }

    private void updateEnabled() {
        this.myPreviewPushProtectedOnly.setEnabled(this.myPreviewPushOnCommitAndPush.isSelected());
    }

    private void testExecutable() {
        final String pathToGit = (String)ObjectUtils.notNull((Object)this.getCurrentExecutablePath(), (Object)this.myExecutableManager.getDetectedExecutable());
        new Task.Modal(this.myProject, GitBundle.getString("git.executable.version.progress.title"), true){
            private GitVersion myVersion;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitVcsPanel.this.myExecutableManager.dropVersionCache(pathToGit);
                this.myVersion = GitVcsPanel.this.myExecutableManager.identifyVersion(pathToGit);
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    2.$$$reportNull$$$0(1);
                }
                GitExecutableProblemsNotifier.showExecutionErrorDialog(error, this.myProject);
            }

            public void onSuccess() {
                if (this.myVersion.isSupported()) {
                    Messages.showInfoMessage((Component)GitVcsPanel.this.myRootPanel, (String)GitBundle.message("git.executable.version.is", this.myVersion.getPresentation()), (String)GitBundle.getString("git.executable.version.success.title"));
                } else {
                    GitExecutableProblemsNotifier.showUnsupportedVersionDialog(this.myVersion, this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/config/GitVcsPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    private void handleProjectOverrideStateChanged() {
        if (!this.myProjectGitPathCheckBox.isSelected() && !Objects.equals(this.getCurrentExecutablePath(), this.myApplicationGitPath)) {
            switch (Messages.showYesNoCancelDialog((Component)this.myRootPanel, (String)VcsBundle.getString((String)"executable.project.override.reset.message"), (String)VcsBundle.getString((String)"executable.project.override.reset.title"), (String)VcsBundle.getString((String)"executable.project.override.reset.globalize"), (String)VcsBundle.getString((String)"executable.project.override.reset.revert"), (String)Messages.CANCEL_BUTTON, null)) {
                case 1: {
                    this.myGitField.setText(this.myApplicationGitPath);
                    break;
                }
                case 2: {
                    this.myProjectGitPathCheckBox.setSelected(true);
                }
            }
        }
    }

    @Nullable
    private String getCurrentExecutablePath() {
        return StringUtil.nullize((String)this.myGitField.getText().trim());
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            GitVcsPanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void reset(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(3);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        this.myApplicationGitPath = applicationSettings.getSavedPathToGit();
        String projectSettingsPathToGit = projectSettings.getPathToGit();
        this.myGitField.setText((String)ObjectUtils.coalesce((Object)projectSettingsPathToGit, (Object)this.myApplicationGitPath));
        this.myProjectGitPathCheckBox.setSelected(projectSettingsPathToGit != null);
        this.myAutoUpdateIfPushRejected.setSelected(projectSettings.autoUpdateIfPushRejected());
        this.mySyncControl.setSelected(projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC);
        this.myAutoCommitOnCherryPick.setSelected(applicationSettings.isAutoCommitOnCherryPick());
        this.myUseCredHelperCheckbox.setSelected(applicationSettings.isUseCredentialHelper());
        this.myAddCherryPickSuffix.setSelected(projectSettings.shouldAddSuffixToCherryPicksOfPublishedCommits());
        this.myWarnAboutCrlf.setSelected(projectSettings.warnAboutCrlf());
        this.myWarnAboutDetachedHead.setSelected(projectSettings.warnAboutDetachedHead());
        this.myUpdateMethodComboBox.setSelectedItem((Object)projectSettings.getUpdateMethod());
        this.myProtectedBranchesField.setText((String)ParametersListUtil.COLON_LINE_JOINER.fun(sharedSettings.getForcePushProhibitedPatterns()));
        this.myIncomingStrategyComboBox.setSelectedItem((Object)projectSettings.getIncomingCheckStrategy());
        this.updateBranchInfoPanel();
        this.myPreviewPushOnCommitAndPush.setSelected(projectSettings.shouldPreviewPushOnCommitAndPush());
        this.myPreviewPushProtectedOnly.setSelected(projectSettings.isPreviewPushProtectedOnly());
        this.updateEnabled();
    }

    private void updateBranchInfoPanel() {
        UIUtil.setEnabled((Component)this.myCheckIncomingPanel, (Registry.is((String)"git.update.incoming.outgoing.info") && this.isBranchInfoSupported() ? 1 : 0) != 0, (boolean)true);
        this.updateBranchSupportedHint();
    }

    private void updateBranchSupportedHint() {
        boolean branchInfoSupported = this.isBranchInfoSupported();
        this.mySupportedBranchUpLabel.setVisible(!branchInfoSupported);
        this.mySupportedBranchUpLabel.setForeground(!branchInfoSupported && this.myIncomingStrategyComboBox.getSelectedItem() != GitIncomingCheckStrategy.Never ? DialogWrapper.ERROR_FOREGROUND_COLOR : UIUtil.getContextHelpForeground());
    }

    private boolean isBranchInfoSupported() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public boolean isModified(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(4);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        return this.isGitPathModified(applicationSettings, projectSettings) || !projectSettings.autoUpdateIfPushRejected() == this.myAutoUpdateIfPushRejected.isSelected() || projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC != this.mySyncControl.isSelected() || applicationSettings.isAutoCommitOnCherryPick() != this.myAutoCommitOnCherryPick.isSelected() || applicationSettings.isUseCredentialHelper() != this.myUseCredHelperCheckbox.isSelected() || projectSettings.shouldAddSuffixToCherryPicksOfPublishedCommits() != this.myAddCherryPickSuffix.isSelected() || projectSettings.warnAboutCrlf() != this.myWarnAboutCrlf.isSelected() || projectSettings.warnAboutDetachedHead() != this.myWarnAboutDetachedHead.isSelected() || projectSettings.shouldPreviewPushOnCommitAndPush() != this.myPreviewPushOnCommitAndPush.isSelected() || projectSettings.isPreviewPushProtectedOnly() != this.myPreviewPushProtectedOnly.isSelected() || projectSettings.getUpdateMethod() != this.myUpdateMethodComboBox.getModel().getSelectedItem() || projectSettings.getIncomingCheckStrategy() != this.myIncomingStrategyComboBox.getSelectedItem() || !ContainerUtil.sorted(sharedSettings.getForcePushProhibitedPatterns()).equals(ContainerUtil.sorted(this.getProtectedBranchesPatterns()));
    }

    private boolean isGitPathModified(@NotNull GitVcsApplicationSettings applicationSettings, @NotNull GitVcsSettings projectSettings) {
        if (applicationSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(5);
        }
        if (projectSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(6);
        }
        return this.myProjectGitPathCheckBox.isSelected() ? !Objects.equals(this.getCurrentExecutablePath(), projectSettings.getPathToGit()) : !Objects.equals(this.getCurrentExecutablePath(), applicationSettings.getSavedPathToGit()) || projectSettings.getPathToGit() != null;
    }

    public void apply(@NotNull GitVcsConfigurable.GitVcsSettingsHolder settings) {
        if (settings == null) {
            GitVcsPanel.$$$reportNull$$$0(7);
        }
        GitVcsApplicationSettings applicationSettings = settings.getApplicationSettings();
        GitVcsSettings projectSettings = settings.getProjectSettings();
        GitSharedSettings sharedSettings = settings.getSharedSettings();
        if (this.myProjectGitPathCheckBox.isSelected()) {
            projectSettings.setPathToGit(this.getCurrentExecutablePath());
        } else {
            this.myApplicationGitPath = this.getCurrentExecutablePath();
            applicationSettings.setPathToGit(this.getCurrentExecutablePath());
            projectSettings.setPathToGit(null);
        }
        projectSettings.setAutoUpdateIfPushRejected(this.myAutoUpdateIfPushRejected.isSelected());
        projectSettings.setSyncSetting(this.mySyncControl.isSelected() ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        applicationSettings.setAutoCommitOnCherryPick(this.myAutoCommitOnCherryPick.isSelected());
        applicationSettings.setUseCredentialHelper(this.myUseCredHelperCheckbox.isSelected());
        projectSettings.setAddSuffixToCherryPicks(this.myAddCherryPickSuffix.isSelected());
        projectSettings.setWarnAboutCrlf(this.myWarnAboutCrlf.isSelected());
        projectSettings.setWarnAboutDetachedHead(this.myWarnAboutDetachedHead.isSelected());
        projectSettings.setUpdateMethod((UpdateMethod)((Object)this.myUpdateMethodComboBox.getSelectedItem()));
        projectSettings.setPreviewPushOnCommitAndPush(this.myPreviewPushOnCommitAndPush.isSelected());
        projectSettings.setPreviewPushProtectedOnly(this.myPreviewPushProtectedOnly.isSelected());
        sharedSettings.setForcePushProhibitedPatters(this.getProtectedBranchesPatterns());
        this.applyBranchUpdateInfo(projectSettings);
        this.validateExecutableOnceAfterClose();
    }

    public void validateExecutableOnceAfterClose() {
        if (!this.versionCheckRequested) {
            ApplicationManager.getApplication().invokeLater(() -> {
                new Task.Backgroundable(this.myProject, GitBundle.getString("git.executable.version.progress.title"), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        GitVcsPanel.this.myExecutableManager.testGitExecutableVersionValid(this.myProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/config/GitVcsPanel$3", "run"));
                    }
                }.queue();
                this.versionCheckRequested = false;
            }, ModalityState.NON_MODAL);
            this.versionCheckRequested = true;
        }
    }

    private void applyBranchUpdateInfo(@NotNull GitVcsSettings projectSettings) {
        if (projectSettings == null) {
            GitVcsPanel.$$$reportNull$$$0(8);
        }
        if (!Registry.is((String)"git.update.incoming.outgoing.info")) {
            return;
        }
        this.updateBranchInfoPanel();
        GitIncomingCheckStrategy selectedStrategy = Objects.requireNonNull((GitIncomingCheckStrategy)((Object)this.myIncomingStrategyComboBox.getSelectedItem()));
        if (projectSettings.getIncomingCheckStrategy() != selectedStrategy) {
            projectSettings.setIncomingCheckStrategy(selectedStrategy);
            if (!this.myProject.isDefault()) {
                GitBranchIncomingOutgoingManager.getInstance(this.myProject).updateIncomingScheduling();
            }
        }
    }

    @NotNull
    private List<String> getProtectedBranchesPatterns() {
        List list = (List)ParametersListUtil.COLON_LINE_PARSER.fun((Object)this.myProtectedBranchesField.getText());
        if (list == null) {
            GitVcsPanel.$$$reportNull$$$0(9);
        }
        return list;
    }

    private void createUIComponents() {
        JBTextField textField = new JBTextField();
        textField.getEmptyText().setText("Auto-detected: " + this.myExecutableManager.getDetectedExecutable());
        this.myGitField = new TextFieldWithBrowseButton((JTextField)textField);
        this.myProtectedBranchesField = new ExpandableTextField(ParametersListUtil.COLON_LINE_PARSER, ParametersListUtil.COLON_LINE_JOINER);
        this.myUpdateMethodComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(UpdateMethod.class));
        this.myUpdateMethodComboBox.setRenderer((ListCellRenderer<UpdateMethod>)SimpleListCellRenderer.create((String)"", value -> StringUtil.capitalize((String)StringUtil.toLowerCase((String)value.name().replace('_', ' ')))));
        this.myIncomingStrategyComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(GitIncomingCheckStrategy.class));
        this.mySupportedBranchUpLabel = new JBLabel("Supported from Git 2.9+");
        this.mySupportedBranchUpLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        GitUpdateProjectInfoLogProperties updateInfoProperties = (GitUpdateProjectInfoLogProperties)((Object)ServiceManager.getService((Project)this.myProject, GitUpdateProjectInfoLogProperties.class));
        HashSet roots = ContainerUtil.newHashSet((Object[])ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(this.myProject)));
        VcsLogClassicFilterUi.FileFilterModel model = new VcsLogClassicFilterUi.FileFilterModel((Set)roots, (MainVcsLogUiProperties)updateInfoProperties, null);
        VcsLogColorManagerImpl colorManager = new VcsLogColorManagerImpl((Collection)roots);
        this.myUpdateProjectInfoFilter = new StructureFilterPopupComponent((MainVcsLogUiProperties)updateInfoProperties, model, (VcsLogColorManager)colorManager){

            @NotNull
            protected Color getDefaultSelectorForeground() {
                Color color = UIUtil.getLabelForeground();
                if (color == null) {
                    4.$$$reportNull$$$0(0);
                }
                return color;
            }

            protected boolean shouldIndicateHovering() {
                return false;
            }

            protected boolean shouldDrawLabel() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsPanel$4", "getDefaultSelectorForeground"));
            }
        }.initUi();
        this.myUpdateProjectInfoFilterLabel = new JBLabel("Filter Update Project information by paths: ");
        if (!AbstractCommonUpdateAction.showsCustomNotification(Collections.singletonList(GitVcs.getInstance(this.myProject)))) {
            this.myUpdateProjectInfoFilter.setVisible(false);
            this.myUpdateProjectInfoFilterLabel.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableManager";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVcsPanel";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationSettings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVcsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtectedBranchesPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isGitPathModified";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyBranchUpdateInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JBCheckBox jBCheckBox4;
        JBLabel jBLabel;
        JCheckBox jCheckBox3;
        JBCheckBox jBCheckBox5;
        JCheckBox jCheckBox4;
        JBCheckBox jBCheckBox6;
        JButton jButton;
        this.createUIComponents();
        JPanel jPanel3 = new JPanel();
        this.myRootPanel = jPanel3;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 7, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.path.label"));
        jLabel.setVerifyInputWhenFocusTarget(false);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myGitField;
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setHorizontalAlignment(0);
        jButton.setLabel(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test.label"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test"));
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 2, null, null, null));
        this.myProjectGitPathCheckBox = jBCheckBox6 = new JBCheckBox();
        jBCheckBox6.setEnabled(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("executable.path.project.override"));
        jPanel4.add((Component)jBCheckBox6, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myAutoCommitOnCherryPick = jCheckBox4 = new JCheckBox();
        jCheckBox4.setIconTextGap(4);
        jCheckBox4.setText("Commit automatically on cherry-pick");
        jPanel6.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myWarnAboutCrlf = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setText("Warn if CRLF line separators are about to be committed");
        jBCheckBox5.setMnemonic('C');
        jBCheckBox5.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jBCheckBox5, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myWarnAboutDetachedHead = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        jCheckBox3.setText("Warn when committing in detached HEAD or during rebase");
        jPanel6.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JTextField jTextField = this.myProtectedBranchesField;
        jTextField.setText("");
        jPanel6.add((Component)jTextField, new GridConstraints(10, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myProtectedBranchesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Protected branches:");
        jPanel6.add((Component)jBLabel, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.mySyncControl = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("sync.setting"));
        jBCheckBox4.setToolTipText("");
        jPanel6.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Update method:");
        jPanel6.add((Component)jBLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myAutoUpdateIfPushRejected = jCheckBox2 = new JCheckBox();
        jCheckBox2.setIconTextGap(4);
        jCheckBox2.setText("Auto-update if push of the current branch was rejected");
        jCheckBox2.setMnemonic('P');
        jCheckBox2.setDisplayedMnemonicIndex(15);
        jPanel6.add((Component)jCheckBox2, new GridConstraints(7, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        JComboBox<UpdateMethod> jComboBox = this.myUpdateMethodComboBox;
        jPanel6.add(jComboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null, 1));
        this.myCheckIncomingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Explicitly check for incoming commits on remotes: ");
        jPanel2.add((Component)jBLabel3, "West");
        JComboBox<GitIncomingCheckStrategy> jComboBox2 = this.myIncomingStrategyComboBox;
        jPanel2.add(jComboBox2, "East");
        JBLabel jBLabel4 = this.mySupportedBranchUpLabel;
        jBLabel4.setAlignmentX(0.0f);
        jBLabel4.setForeground(new Color(-8355712));
        jBLabel4.setHorizontalAlignment(2);
        jBLabel4.setHorizontalTextPosition(2);
        jBLabel4.setText(" Supported for Git 2.9+");
        jPanel7.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(6, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreviewPushOnCommitAndPush = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Show Push dialog for Commit and Push");
        jPanel6.add((Component)jBCheckBox3, new GridConstraints(8, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myPreviewPushProtectedOnlyBorder = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(9, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPreviewPushProtectedOnly = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show Push dialog only when committing to protected branches");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddCherryPickSuffix = jCheckBox = new JCheckBox();
        jCheckBox.setIconTextGap(4);
        jCheckBox.setSelected(true);
        jCheckBox.setText("Add the 'cherry-picked from <hash>' suffix when picking commits pushed to protected branches");
        jPanel6.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myUseCredHelperCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(true);
        jBCheckBox.setSelected(false);
        jBCheckBox.setText("Use credential helper");
        jPanel6.add((Component)jBCheckBox, new GridConstraints(11, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.myUpdateProjectInfoFilter;
        jPanel3.add((Component)jComponent, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel5 = this.myUpdateProjectInfoFilterLabel;
        jBLabel5.setText("Filter Update Project information by paths: ");
        jPanel3.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

