/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.base.Joiner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantFileConfig;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import com.jetbrains.plugins.vagrant.cli.VagrantCli;
import com.jetbrains.plugins.vagrant.cli.VagrantStatus;
import com.jetbrains.plugins.vagrant.state.FileCache;
import com.jetbrains.plugins.vagrant.state.FileCacheWithDefaultResolver;
import com.jetbrains.plugins.vagrant.state.FileCacheWithValidityPeriodFallback;
import com.jetbrains.plugins.vagrant.state.Resolver;
import com.jetbrains.plugins.vagrant.state.global.MachineData;
import com.jetbrains.plugins.vagrant.state.global.MachineIndex;
import com.jetbrains.plugins.vagrant.state.vm.SyncedFolder;
import com.jetbrains.plugins.vagrant.state.vm.SyncedFolderData;
import com.jetbrains.plugins.vagrant.state.vm.SyncedFolders;
import com.jetbrains.plugins.vagrant.state.vm.VmStatusUtil;
import java.awt.Component;
import java.awt.MouseInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantInstance {
    private static final Logger LOG = Logger.getInstance(VagrantInstance.class);
    public static final String DEFAULT_SHARED_FOLDER = "/vagrant";
    private static final long SSH_CONFIG_VALIDITY_PERIOD_IN_SECONDS = 30L;
    @NotNull
    private final String myFolder;
    private final Map<String, FileCacheWithValidityPeriodFallback<VagrantSshConfig>> mySshConfigCacheMap;
    private final FileCache<List<VagrantStatus>> myVagrantStatusCache;
    private final Map<Path, FileCacheWithDefaultResolver<SyncedFolders>> mySyncedFoldersCache;

    public VagrantInstance(@NotNull String folder) {
        if (folder == null) {
            VagrantInstance.$$$reportNull$$$0(0);
        }
        this.mySshConfigCacheMap = new ConcurrentHashMap<String, FileCacheWithValidityPeriodFallback<VagrantSshConfig>>();
        this.mySyncedFoldersCache = new ConcurrentHashMap<Path, FileCacheWithDefaultResolver<SyncedFolders>>();
        this.myFolder = folder;
        this.myVagrantStatusCache = new FileCache(Paths.get(folder, "Vagrantfile"));
    }

    @NotNull
    public VagrantSshConfig getSshConfig(@Nullable String machineName) throws IOException, VagrantSupport.MultipleMachinesException {
        if (machineName == null) {
            machineName = this.getDefaultMachine();
        }
        VagrantSshConfig vagrantSshConfig = this.mySshConfigCacheMap.computeIfAbsent(machineName, name -> VagrantInstance.createVagrantSshConfigFileCache()).getContent(this.createVagrantSshConfigResolver(machineName));
        if (vagrantSshConfig == null) {
            VagrantInstance.$$$reportNull$$$0(1);
        }
        return vagrantSshConfig;
    }

    @NotNull
    private String getDefaultMachine() throws VagrantSupport.MultipleMachinesException {
        String string;
        try {
            string = VagrantInstance.getDefaultMachineName(this.getUpdatedVagrantStatus());
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to use new Vagrant ssh-config caching strategy for \"" + this.myFolder + "\"", (Throwable)e);
            } else {
                LOG.info("Failed to use new Vagrant ssh-config caching strategy for \"" + this.myFolder + "\": " + e);
            }
            String string2 = VagrantInstance.getDefaultMachine(VagrantUtil.getVagrantMachines(this.myFolder));
            if (string2 == null) {
                VagrantInstance.$$$reportNull$$$0(3);
            }
            return string2;
        }
        if (string == null) {
            VagrantInstance.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static FileCacheWithValidityPeriodFallback<VagrantSshConfig> createVagrantSshConfigFileCache() {
        Path machineIndexPath = VagrantService.getInstance().getGlobalStatus().getMachineIndexPath();
        FileCacheWithValidityPeriodFallback<VagrantSshConfig> fileCacheWithValidityPeriodFallback = new FileCacheWithValidityPeriodFallback<VagrantSshConfig>(machineIndexPath, 30L, TimeUnit.SECONDS);
        if (fileCacheWithValidityPeriodFallback == null) {
            VagrantInstance.$$$reportNull$$$0(4);
        }
        return fileCacheWithValidityPeriodFallback;
    }

    @NotNull
    private Resolver<VagrantSshConfig> createVagrantSshConfigResolver(@NotNull String machineName) {
        if (machineName == null) {
            VagrantInstance.$$$reportNull$$$0(5);
        }
        Resolver<VagrantSshConfig> resolver2 = path -> {
            String vagrantExecutable = VagrantService.getInstance().getVagrantExecutable();
            try {
                return VagrantCli.execSshConfigCommand(null, vagrantExecutable, this.myFolder, machineName);
            }
            catch (VagrantSupport.MultipleMachinesException e) {
                throw new IllegalStateException(e);
            }
        };
        if (resolver2 == null) {
            VagrantInstance.$$$reportNull$$$0(6);
        }
        return resolver2;
    }

    @NotNull
    private static String getDefaultMachine(@NotNull List<String> machines) throws VagrantSupport.MultipleMachinesException {
        if (machines == null) {
            VagrantInstance.$$$reportNull$$$0(7);
        }
        if (machines.size() == 0) {
            if ("default" == null) {
                VagrantInstance.$$$reportNull$$$0(8);
            }
            return "default";
        }
        if (machines.size() > 1) {
            throw new VagrantSupport.MultipleMachinesException();
        }
        String string = machines.get(0);
        if (string == null) {
            VagrantInstance.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getDefaultMachineName(@NotNull List<VagrantStatus> machines) throws VagrantSupport.MultipleMachinesException {
        if (machines == null) {
            VagrantInstance.$$$reportNull$$$0(10);
        }
        if (machines.size() == 0) {
            if ("default" == null) {
                VagrantInstance.$$$reportNull$$$0(11);
            }
            return "default";
        }
        if (machines.size() > 1) {
            throw new VagrantSupport.MultipleMachinesException();
        }
        String string = machines.get(0).getMachineName();
        if (string == null) {
            VagrantInstance.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static VagrantStatus findVagrantStatusForMachine(@NotNull List<VagrantStatus> vagrantStatus, @NotNull String machineName) {
        if (vagrantStatus == null) {
            VagrantInstance.$$$reportNull$$$0(13);
        }
        if (machineName == null) {
            VagrantInstance.$$$reportNull$$$0(14);
        }
        return (VagrantStatus)ContainerUtil.find(vagrantStatus, status -> machineName.equals(status.getMachineName()));
    }

    @NotNull
    private List<VagrantStatus> getUpdatedVagrantStatus() throws IOException {
        List<VagrantStatus> cachedCliVagrantStatuses = this.myVagrantStatusCache.getContent(this.createVagrantMachinesResolver());
        MachineIndex machineIndex = VagrantService.getInstance().getGlobalStatus().getMachineIndex();
        List<VagrantStatus> updatedVagrantStatuses = VagrantInstance.toVagrantStatus(machineIndex, this.myFolder);
        List list = ContainerUtil.map(cachedCliVagrantStatuses, status -> {
            String name = status.getMachineName();
            VagrantStatus updatedStatus = (VagrantStatus)ContainerUtil.find((Iterable)updatedVagrantStatuses, s -> s.getMachineName().equals(name));
            return updatedStatus == null ? status : updatedStatus;
        });
        if (list == null) {
            VagrantInstance.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static List<VagrantStatus> getCliVagrantStatus(@NotNull String folder) throws IOException {
        if (folder == null) {
            VagrantInstance.$$$reportNull$$$0(16);
        }
        LOG.debug("Getting Vagrant status for \"" + folder + "\"");
        String vagrantExecutable = VagrantService.getInstance().getVagrantExecutable();
        List<VagrantStatus> statuses = VagrantCli.execVagrantStatusCommand(vagrantExecutable, folder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Vagrant status obtained for \"" + folder + "\": " + Joiner.on((String)", ").join((Iterable)ContainerUtil.map(statuses, s -> s.getMachineName() + ":" + s.getStatus() + ":" + s.getProvider())));
        }
        List<VagrantStatus> list = statuses;
        if (list == null) {
            VagrantInstance.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static List<VagrantStatus> toVagrantStatus(@NotNull MachineIndex machineIndex, @NotNull String vagrantFolder) {
        if (machineIndex == null) {
            VagrantInstance.$$$reportNull$$$0(18);
        }
        if (vagrantFolder == null) {
            VagrantInstance.$$$reportNull$$$0(19);
        }
        ArrayList<VagrantStatus> result = new ArrayList<VagrantStatus>();
        if (machineIndex.getMachines() != null) {
            Path vagrantFolderPath = Paths.get(vagrantFolder, new String[0]);
            for (MachineData data : machineIndex.getMachines().values()) {
                if (data.getName() == null || data.getState() == null || data.getProvider() == null || data.getVagrantfilePath() == null || !vagrantFolderPath.equals(Paths.get(data.getVagrantfilePath(), new String[0]))) continue;
                result.add(new VagrantStatus(data.getName(), data.getState(), data.getProvider()));
            }
        }
        ArrayList<VagrantStatus> arrayList = result;
        if (arrayList == null) {
            VagrantInstance.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private PathMappingSettings collectMappingsFromSyncedFolders(@Nullable String machineName) throws IOException, VagrantSupport.MultipleMachinesException {
        VagrantStatus status;
        PathMappingSettings settings = new PathMappingSettings();
        List<VagrantStatus> statuses = this.getUpdatedVagrantStatus();
        if (machineName == null) {
            machineName = VagrantInstance.getDefaultMachineName(statuses);
        }
        if ((status = VagrantInstance.findVagrantStatusForMachine(statuses, machineName)) != null) {
            for (Pair<String, String> pair : this.getSyncedPath(machineName, status.getProvider())) {
                settings.addMapping((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        return settings;
    }

    @NotNull
    private List<Pair<String, String>> getSyncedPath(@NotNull String machineName, @NotNull String provider) throws IOException {
        if (machineName == null) {
            VagrantInstance.$$$reportNull$$$0(21);
        }
        if (provider == null) {
            VagrantInstance.$$$reportNull$$$0(22);
        }
        Path syncedFoldersPath = VmStatusUtil.INSTANCE.getSyncedFoldersPath(this.myFolder, machineName, provider);
        FileCacheWithDefaultResolver cache = this.mySyncedFoldersCache.computeIfAbsent(syncedFoldersPath, path -> new FileCacheWithDefaultResolver<SyncedFolders>((Path)path, p -> VagrantInstance.parseSyncedFolders(p)));
        ArrayList<Pair<String, String>> syncedPaths = new ArrayList<Pair<String, String>>();
        if (((SyncedFolders)cache.getContent()).getImplementations() != null) {
            for (SyncedFolder syncedFolder : ((SyncedFolders)cache.getContent()).getImplementations().values()) {
                if (syncedFolder.getSyncedFolders() == null) continue;
                for (SyncedFolderData data : syncedFolder.getSyncedFolders().values()) {
                    if (!StringUtil.isNotEmpty((String)data.getHostpath()) || !StringUtil.isNotEmpty((String)data.getGuestpath())) continue;
                    syncedPaths.add((Pair<String, String>)Pair.create((Object)data.getHostpath(), (Object)data.getGuestpath()));
                }
            }
        }
        ArrayList<Pair<String, String>> arrayList = syncedPaths;
        if (arrayList == null) {
            VagrantInstance.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    public PathMappingSettings getPathMapping(@Nullable String machineName) {
        PathMappingSettings pathMappingSettings;
        try {
            pathMappingSettings = this.collectMappingsFromSyncedFolders(machineName);
        }
        catch (VagrantSupport.MultipleMachinesException | IOException | RuntimeException e) {
            LOG.debug("Failed to read synced_folders file for Vagrant instance located at \"" + this.myFolder + "\"", e);
            PathMappingSettings pathMappingSettings2 = this.collectMappingsFromVagrantfile();
            if (pathMappingSettings2 == null) {
                VagrantInstance.$$$reportNull$$$0(25);
            }
            return pathMappingSettings2;
        }
        if (pathMappingSettings == null) {
            VagrantInstance.$$$reportNull$$$0(24);
        }
        return pathMappingSettings;
    }

    private PathMappingSettings collectMappingsFromVagrantfile() {
        PathMappingSettings mappings;
        PathMappingSettings settings = new PathMappingSettings();
        VagrantFileConfig config = this.getVagrantFile();
        if (config != null && (mappings = config.getCustomMappings()) != null) {
            settings.addAll(mappings);
        }
        return settings;
    }

    @Nullable
    public VagrantFileConfig getVagrantFile() {
        return VagrantFileConfig.findInFolder(this.myFolder);
    }

    @NotNull
    public String getFolder() {
        String string = this.myFolder;
        if (string == null) {
            VagrantInstance.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public RemoteConnector toRemoteConnector(@NotNull Project project) {
        if (project == null) {
            VagrantInstance.$$$reportNull$$$0(27);
        }
        MyRemoteConnector myRemoteConnector = new MyRemoteConnector(project);
        if (myRemoteConnector == null) {
            VagrantInstance.$$$reportNull$$$0(28);
        }
        return myRemoteConnector;
    }

    @NotNull
    private static SyncedFolders parseSyncedFolders(@NotNull Path path) throws IOException {
        SyncedFolders syncedFolders;
        if (path == null) {
            VagrantInstance.$$$reportNull$$$0(29);
        }
        try {
            syncedFolders = SyncedFolders.Companion.parse(path.toFile());
        }
        catch (IOException e) {
            LOG.debug("Failed to parse synced_folders file \"" + path + "\"", (Throwable)e);
            throw e;
        }
        if (syncedFolders == null) {
            VagrantInstance.$$$reportNull$$$0(30);
        }
        return syncedFolders;
    }

    private void selectVmName(@NotNull Project project, final Consumer<? super RemoteCredentials> consumer) {
        if (project == null) {
            VagrantInstance.$$$reportNull$$$0(31);
        }
        List<String> names = this.getVagrantMachines();
        BaseListPopupStep<String> machineNames = new BaseListPopupStep<String>("Select Vagrant machine", names){

            public PopupStep onChosen(String vmName, boolean finalChoice) {
                try {
                    VagrantSshConfig cfg = VagrantInstance.this.getSshConfig(vmName);
                    consumer.consume((Object)cfg.toRemoteCredentials());
                }
                catch (Exception e) {
                    Messages.showErrorDialog((String)e.getMessage(), (String)"SSH Config Error");
                }
                return FINAL_CHOICE;
            }
        };
        UIUtil.invokeLaterIfNeeded(() -> VagrantInstance.lambda$selectVmName$8((ListPopupStep)machineNames, project));
    }

    @NotNull
    public List<String> getVagrantMachines() {
        List list;
        try {
            list = ContainerUtil.map((Collection)this.myVagrantStatusCache.getContent(this.createVagrantMachinesResolver()), VagrantStatus::getMachineName);
        }
        catch (IOException | RuntimeException e) {
            LOG.debug("Failed to get Vagrant machines status in \"" + this.myFolder + "\"", (Throwable)e);
            List<String> list2 = VagrantUtil.getVagrantMachines(this.myFolder);
            if (list2 == null) {
                VagrantInstance.$$$reportNull$$$0(33);
            }
            return list2;
        }
        if (list == null) {
            VagrantInstance.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    private Resolver<List<VagrantStatus>> createVagrantMachinesResolver() {
        Resolver<List<VagrantStatus>> resolver2 = path -> VagrantInstance.getCliVagrantStatus(this.myFolder);
        if (resolver2 == null) {
            VagrantInstance.$$$reportNull$$$0(34);
        }
        return resolver2;
    }

    private static /* synthetic */ void lambda$selectVmName$8(ListPopupStep machineNames, Project project) {
        ListPopup popup = JBPopupFactory.getInstance().createListPopup(machineNames);
        popup.showInScreenCoordinates((Component)WindowManager.getInstance().getIdeFrame(project).getComponent(), MouseInfo.getPointerInfo().getLocation());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantInstance";
                break;
            }
            case 5: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machines";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantStatus";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineIndex";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshConfig";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMachine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVagrantSshConfigFileCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createVagrantSshConfigResolver";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMachineName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedVagrantStatus";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCliVagrantStatus";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toVagrantStatus";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncedPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapping";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toRemoteConnector";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSyncedFolders";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantMachines";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createVagrantMachinesResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createVagrantSshConfigResolver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMachine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMachineName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findVagrantStatusForMachine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCliVagrantStatus";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toVagrantStatus";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSyncedPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toRemoteConnector";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseSyncedFolders";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "selectVmName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRemoteConnector
    implements RemoteConnector {
        @NotNull
        private final Project myProject;

        MyRemoteConnector(Project project) {
            if (project == null) {
                MyRemoteConnector.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public String getId() {
            return "vagrant:" + VagrantInstance.this.myFolder;
        }

        @NotNull
        public String getName() {
            String string = "Vagrant at " + VagrantInstance.this.myFolder;
            if (string == null) {
                MyRemoteConnector.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.CURRENT_VAGRANT;
            if (remoteConnectionType == null) {
                MyRemoteConnector.$$$reportNull$$$0(2);
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<? super RemoteCredentials> consumer) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    try {
                        VagrantSshConfig config = VagrantInstance.this.getSshConfig(null);
                        consumer.consume((Object)config.toRemoteCredentials());
                    }
                    catch (VagrantSupport.MultipleMachinesException e) {
                        VagrantInstance.this.selectVmName(this.myProject, (Consumer<? super RemoteCredentials>)consumer);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't get remote host credentials", e);
                }
            });
        }

        @NotNull
        public Object getConnectorKey() {
            String string = this.getName();
            if (string == null) {
                MyRemoteConnector.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantInstance$MyRemoteConnector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantInstance$MyRemoteConnector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

