/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.compass.CompassSassExtension;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanel;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanelImpl;
import org.jetbrains.plugins.sass.extensions.compass.CompassUtil;

public class CompassConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @Nullable
    private final Module myModule;
    @Nullable
    private final CompassSassExtension myCompassSassExtension;
    private final boolean myFullMode;
    @Nullable
    private final CompassSettings myCompassSettings;
    @Nullable
    private CompassSettingsPanel myPanel;

    public CompassConfigurable(@Nullable Module module, @Nullable CompassSassExtension compassSassExtension, boolean fullMode) {
        this.myModule = module;
        this.myCompassSassExtension = compassSassExtension;
        this.myFullMode = fullMode;
        this.myCompassSettings = module != null ? CompassSettings.getInstance(module) : null;
    }

    @NotNull
    public String getId() {
        if ("compass.support" == null) {
            CompassConfigurable.$$$reportNull$$$0(0);
        }
        return "compass.support";
    }

    @Nls
    public String getDisplayName() {
        return SASSBundle.message("compass.support.configurable.name");
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.project.settings.compass.support";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myPanel == null && this.myModule != null && this.myCompassSettings != null) {
            this.myPanel = this.createCompassSettingsPanel(this.myModule, this.myFullMode);
        }
        return this.myPanel != null ? this.myPanel.getComponent() : null;
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified(this.myCompassSettings);
    }

    public void apply() {
        if (this.myPanel != null) {
            boolean executablePathChanged = this.myPanel.isExecutablePathChanged(this.myCompassSettings);
            boolean enableOptionChanged = this.myPanel.isEnableOptionChanged(this.myCompassSettings);
            boolean configPathChanged = this.myPanel.isConfigFilePathChanged(this.myCompassSettings);
            this.myPanel.apply(this.myCompassSettings);
            if (this.myModule != null && this.myCompassSettings != null) {
                if (!this.myCompassSettings.isCompassSupportEnabled()) {
                    CompassUtil.removeCompassLibraryIfNeeded(this.myModule);
                }
                if ((enableOptionChanged || configPathChanged || executablePathChanged) && this.myCompassSassExtension != null) {
                    this.myCompassSassExtension.stopActivity(this.myModule);
                    this.myCompassSettings.setImportPaths(Collections.emptyList());
                    if (this.myCompassSassExtension.isAvailableInModule(this.myModule)) {
                        this.myCompassSassExtension.startActivity(this.myModule);
                    }
                }
            }
        }
    }

    @NotNull
    protected CompassSettingsPanel createCompassSettingsPanel(@NotNull Module module, boolean fullMode) {
        if (module == null) {
            CompassConfigurable.$$$reportNull$$$0(1);
        }
        List<String> variants = ApplicationManager.getApplication().isUnitTestMode() ? Collections.emptyList() : CompassUtil.getExecutableFilesVariants();
        CompassSettingsPanelImpl compassSettingsPanelImpl = new CompassSettingsPanelImpl(module, variants, CompassUtil.getConfigFileVariants(module), fullMode);
        if (compassSettingsPanelImpl == null) {
            CompassConfigurable.$$$reportNull$$$0(2);
        }
        return compassSettingsPanelImpl;
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset(this.myCompassSettings);
        }
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompassSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCompassSettingsPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

