/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfigDetector;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TslintUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");
    public static final String PACKAGE_NAME = "tslint";
    public static final String TSLINT_JSON = "tslint.json";
    public static final String TYPESCRIPT_PLUGIN_OLD_PACKAGE_NAME = "tslint-language-service";
    public static final String TYPESCRIPT_PLUGIN_PACKAGE_NAME = "typescript-tslint-plugin";
    public static final String[] CONFIG_FILE_NAMES = new String[]{"tslint.json", "tslint.yaml", "tslint.yml"};

    private TslintUtil() {
    }

    public static boolean isConfigFile(@NotNull VirtualFile file) {
        if (file == null) {
            TslintUtil.$$$reportNull$$$0(0);
        }
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        CharSequence name = file.getNameSequence();
        for (String fileName : CONFIG_FILE_NAMES) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            TslintUtil.$$$reportNull$$$0(1);
        }
        return JSLinterConfigFileUtil.hasConfigFiles((Project)project, (String[])CONFIG_FILE_NAMES);
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsInScope(@NotNull Project project) {
        if (project == null) {
            TslintUtil.$$$reportNull$$$0(2);
        }
        List list = JSLinterConfigFileUtil.findAllConfigs((Project)project, (String[])CONFIG_FILE_NAMES);
        if (list == null) {
            TslintUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getConfig(@NotNull TsLintState state, @NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (state == null) {
            TslintUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TslintUtil.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            TslintUtil.$$$reportNull$$$0(6);
        }
        return TslintUtil.doGetConfig(state, project, virtualFile);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public static VirtualFile getConfig(@NotNull TsLintState state, @NotNull VirtualFile virtualFile) {
        if (state == null) {
            TslintUtil.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            TslintUtil.$$$reportNull$$$0(8);
        }
        return TslintUtil.doGetConfig(state, null, virtualFile);
    }

    private static VirtualFile doGetConfig(@NotNull TsLintState state, @Nullable Project project, @NotNull VirtualFile virtualFile) {
        if (state == null) {
            TslintUtil.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            TslintUtil.$$$reportNull$$$0(10);
        }
        if (state.isCustomConfigFileUsed()) {
            String configFilePath = state.getCustomConfigFilePath();
            if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                return null;
            }
            File configFile = new File(configFilePath);
            return VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
        }
        return project != null ? TslintUtil.lookupConfig(project, virtualFile) : TslintUtil.lookupConfig(virtualFile);
    }

    @Nullable
    public static VirtualFile lookupConfig(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            TslintUtil.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            TslintUtil.$$$reportNull$$$0(12);
        }
        for (TsLintConfigDetector detector : TsLintConfigDetector.TS_LINT_CONFIG_DETECTOR_EP.getExtensionList()) {
            TsLintConfigDetector.TsLintConfigs setup = detector.detectConfigs(project, virtualFile);
            if (setup == null) continue;
            return setup.getTsLintConfig();
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    @Nullable
    public static VirtualFile lookupConfig(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            TslintUtil.$$$reportNull$$$0(13);
        }
        return JSLinterConfigFileUtil.findFileUpToFileSystemRoot((VirtualFile)virtualFile, (String[])CONFIG_FILE_NAMES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/TslintUtil";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/TslintUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsInScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConfigFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsInScope";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetConfig";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lookupConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

