/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExtendedNotificationBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.Component;
import java.util.Collections;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.jetbrains.annotations.NotNull;

public class RemoteRenameAction
extends DumbAwareAction {
    public RemoteRenameAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoteRenameAction.$$$reportNull$$$0(0);
        }
        boolean b = RemoteRenameAction.isEnabled(e.getDataContext());
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(b);
        } else {
            e.getPresentation().setEnabled(b);
        }
    }

    private static boolean isEnabled(DataContext context) {
        ServerTreeNode[] serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(context);
        if (serverNodes == null || serverNodes.length != 1) {
            return false;
        }
        ServerTreeNode fileToRename = serverNodes[0];
        return !fileToRename.isRoot();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String nameToRename;
        if (e == null) {
            RemoteRenameAction.$$$reportNull$$$0(1);
        }
        final RemoteConnection connection = (RemoteConnection)e.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        FileObject[] serverObjects = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (serverObjects == null || serverObjects.length != 1) {
            return;
        }
        final FileObject fileToRenameObject = serverObjects[0];
        String oldName = fileToRenameObject.getName().getBaseName();
        final ServerTree tree = (ServerTree)((Object)e.getData(WebDeploymentDataKeys.SERVER_TREE));
        final Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        Project project = e.getProject();
        boolean isModalContext = (Boolean)e.getData(PlatformDataKeys.IS_MODAL_CONTEXT);
        String newName = Messages.showInputDialog((Component)((Object)tree), (String)WDBundle.message("enter.new.name.for.0", oldName), (String)WDBundle.message("rename.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)oldName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                if (StringUtil.isEmpty((String)inputString)) {
                    return false;
                }
                return !inputString.contains("\\") && !inputString.contains("/");
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        if (newName != null && !oldName.equals(nameToRename = newName.trim())) {
            PublishConfig publishConfig = project != null ? PublishConfig.getInstance(project) : new PublishConfig(null);
            new ExtendedNotificationBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project, (Component)((Object)tree)), publishConfig, server, WDBundle.message("rename.server.node", oldName, newName), isModalContext, (Component)((Object)tree), WDBundle.message("rename.task.title", new Object[0]), DeploymentRevisionTracker.DEAF, true){

                @Override
                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) {
                    TransferOperation.RemoteMoveOrCopy operation;
                    context.getProgressIndicator().checkCanceled();
                    context.getProgressIndicator().setText(WDBundle.message("processing.0", server.getPresentablePath(fileToRenameObject)));
                    try {
                        FileObject parent = fileToRenameObject.getParent();
                        final FileObject newFile = parent.resolveFile(nameToRename, NameScope.CHILD);
                        operation = new TransferOperation.RemoteMoveOrCopy(fileToRenameObject, newFile, fileToRenameObject.getType() == FileType.FOLDER, false, true){

                            @Override
                            public void execute(ExecutionContext context) throws FileSystemException {
                                super.execute(context);
                                context.scheduleForSelection(server.getRemotePath(newFile), (Object)tree);
                            }
                        };
                    }
                    catch (FileSystemException ex) {
                        return new TransferTask.ListBased.ResultWithErrors(Collections.emptyList(), new DeploymentPathUtils.ErrorsAndExclusions());
                    }
                    return new TransferTask.ListBased.ResultWithErrors(Collections.singletonList(operation), new DeploymentPathUtils.ErrorsAndExclusions());
                }

                @Override
                protected RemoteConnection getExistingConnection() {
                    return connection;
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/RemoteRenameAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

