/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.intellij.ws.rest.client.RestClientRequest;
import com.michaelbaranov.microba.calendar.DatePicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;
import org.apache.http.impl.cookie.BasicClientCookie;

public class RESTCookiesPanel
extends JPanel {
    private final CookieTableModel myTableModel;
    private final JBListTable myCookiesPanel;

    public RESTCookiesPanel(Project project, Disposable parent) {
        super(new BorderLayout());
        this.setBorder(JBUI.Borders.empty((int)5));
        this.myTableModel = new CookieTableModel();
        JBTable cookiesTable = new JBTable((TableModel)this.myTableModel);
        this.myCookiesPanel = new CookiesTable(cookiesTable, project, parent);
        this.add((Component)ToolbarDecorator.createDecorator((JTable)this.myCookiesPanel.getTable()).disableUpDownActions().createPanel(), "Center");
    }

    public void setCookies(Collection<Cookie> cookies) {
        this.myTableModel.setCookies(cookies);
        ((AbstractTableModel)this.myCookiesPanel.getTable().getModel()).fireTableDataChanged();
    }

    public void saveToRequest(RestClientRequest request) {
        for (BasicClientCookie cookie : this.myTableModel.myCookies) {
            request.addBiscuit((Cookie)cookie);
        }
    }

    public void loadFromRequest(RestClientRequest request) {
        this.myTableModel.myCookies.clear();
        for (RestClientRequest.Biscuit biscuit : request.biscuits) {
            BasicClientCookie cookie = new BasicClientCookie(biscuit.getName(), biscuit.getValue());
            cookie.setDomain(biscuit.getDomain());
            cookie.setPath(biscuit.getPath());
            if (biscuit.getDate() != -1L) {
                cookie.setExpiryDate(new Date(biscuit.getDate()));
            }
            this.myTableModel.myCookies.add(cookie);
        }
        this.myTableModel.fireTableStructureChanged();
    }

    private int getMaxLength(int column, int forcedMax) {
        int max = 0;
        for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
            Object at = this.myTableModel.getValueAt(i, column);
            String text = at instanceof Date ? DateFormatUtil.formatDateTime((Date)((Date)at)) : (String)at;
            max = Math.max(max, text != null ? text.length() : 4);
        }
        return Math.min(max, forcedMax);
    }

    private static String cutIfLong(String string, int size) {
        return string.length() > size ? string.substring(0, size - 1) + "\u2026" : string;
    }

    private class CookiesTable
    extends JBListTable {
        private final Project myProject;

        CookiesTable(JBTable cookiesTable, Project project, Disposable parent) {
            super((JTable)cookiesTable, parent);
            this.myProject = project;
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return new JBTableRowRenderer(){

                public JComponent getRowRendererComponent(JTable table, int row, boolean selected, boolean focused) {
                    Cookie cookie = ((CookieTableModel)table.getModel()).getCookie(row);
                    String name = cookie.getName();
                    String value = RESTCookiesPanel.cutIfLong(cookie.getValue(), 100);
                    String domain = cookie.getDomain() != null ? cookie.getDomain() : "none";
                    String path = RESTCookiesPanel.cutIfLong(cookie.getPath() != null ? cookie.getPath() : "none", 20);
                    Date date = cookie.getExpiryDate();
                    String text = " Name: " + name + StringUtil.repeat((String)" ", (int)(RESTCookiesPanel.this.getMaxLength(0, 100) - name.length())) + "   ";
                    text = text + "Domain: " + domain + StringUtil.repeat((String)" ", (int)(RESTCookiesPanel.this.getMaxLength(2, 100) - domain.length())) + "   ";
                    text = text + "Path: " + path + StringUtil.repeat((String)" ", (int)(RESTCookiesPanel.this.getMaxLength(3, 20) - path.length())) + "   ";
                    text = text + "Expires: " + (date != null ? DateFormatUtil.formatDateTime((Date)date) : "session") + "\n";
                    text = text + " Value: " + value;
                    final JComponent renderer = JBListTable.createEditorTextFieldPresentation((Project)CookiesTable.this.myProject, (FileType)PlainTextFileType.INSTANCE, (String)text, (boolean)selected, (boolean)focused);
                    ((EditorTextField)renderer.getComponent(0)).addSettingsProvider(editor -> {
                        editor.setOneLineMode(false);
                        editor.setColorsScheme((EditorColorsScheme)new DelegateColorScheme(editor.getColorsScheme()){

                            public float getLineSpacing() {
                                return 1.2f;
                            }
                        });
                    });
                    Dimension size = renderer.getPreferredSize();
                    renderer.setPreferredSize(new Dimension(size.width, size.height * 2));
                    JPanel result = new JPanel(new BorderLayout());
                    JPanel rendererPanel = new JPanel(new BorderLayout()){

                        @Override
                        public void setBackground(Color color) {
                            super.setBackground(color);
                            renderer.setBackground(color);
                            for (Component child : renderer.getComponents()) {
                                child.setBackground(color);
                            }
                        }
                    };
                    rendererPanel.add((Component)renderer, "Center");
                    result.add((Component)rendererPanel, "Center");
                    JLabel rowLabel = new JLabel("  " + (row + 1) + ". ");
                    if (!UIUtil.isUnderDarcula()) {
                        rowLabel.setForeground(UIUtil.getInactiveTextColor());
                    }
                    result.add((Component)rowLabel, "West");
                    return result;
                }
            };
        }

        protected JBTableRowEditor getRowEditor(final int row) {
            return new JBTableRowEditor(){
                private EditorTextField myNameEditor;
                private EditorTextField myValueEditor;
                private EditorTextField myDomainEditor;
                private EditorTextField myPathEditor;
                private DatePicker myDatePicker;

                public void prepareEditor(JTable table, int row2) {
                    this.setLayout(new GridLayout(1, 4));
                    this.myNameEditor = this.createEditor(row2, 0, "Name:");
                    this.myValueEditor = this.createEditor(row2, 1, "Value:");
                    this.myDomainEditor = this.createEditor(row2, 2, "Domain:");
                    this.myPathEditor = this.createEditor(row2, 3, "Path:");
                    this.myDatePicker = new DatePicker((Date)RESTCookiesPanel.this.myTableModel.getValueAt(row2, 4), DateFormatUtil.getDateTimeFormat().getDelegate()){

                        public void removeNotify() {
                            CookiesTable.this.stopEditing();
                            super.removeNotify();
                        }
                    };
                    this.myDatePicker.setKeepTime(true);
                    this.myDatePicker.setStripTime(false);
                    this.add(2.createLabeledPanel((String)"Expiry date:", (JComponent)this.myDatePicker));
                }

                private EditorTextField createEditor(int row2, int column, String name) {
                    String value = (String)RESTCookiesPanel.this.myTableModel.getValueAt(row2, column);
                    EditorTextField field = new EditorTextField(value != null ? value : "");
                    field.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, column));
                    this.add(2.createLabeledPanel((String)name, (JComponent)field));
                    return field;
                }

                public JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column) {
                            if (column == 0) {
                                return myNameEditor.getText().trim();
                            }
                            if (column == 1) {
                                return myValueEditor.getText().trim();
                            }
                            if (column == 2) {
                                return myDomainEditor.getText().trim();
                            }
                            if (column == 3) {
                                return myPathEditor.getText().trim();
                            }
                            if (column == 4) {
                                return myDatePicker.getDate();
                            }
                            throw new IllegalArgumentException("No such column " + column);
                        }
                    };
                }

                public JComponent getPreferredFocusedComponent() {
                    String cookieName = row >= RESTCookiesPanel.this.myTableModel.getRowCount() ? null : (String)RESTCookiesPanel.this.myTableModel.getValueAt(row, 0);
                    return StringUtil.isEmpty(cookieName) ? this.myNameEditor.getFocusTarget() : this.myValueEditor.getFocusTarget();
                }

                public JComponent[] getFocusableComponents() {
                    return new JComponent[]{this.myNameEditor.getFocusTarget(), this.myValueEditor.getFocusTarget(), this.myDomainEditor.getFocusTarget(), this.myPathEditor.getFocusTarget()};
                }
            };
        }
    }

    private static class CookieTableModel
    extends AbstractTableModel
    implements ItemRemovable,
    EditableModel {
        List<BasicClientCookie> myCookies = new ArrayList<BasicClientCookie>();
        private static final CookieIdentityComparator COMPARATOR = new CookieIdentityComparator();

        private CookieTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.myCookies.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Cookie cookie = (Cookie)this.myCookies.get(row);
            if (column == 0) {
                return cookie.getName();
            }
            if (column == 1) {
                return cookie.getValue();
            }
            if (column == 2) {
                return cookie.getDomain();
            }
            if (column == 3) {
                return cookie.getPath();
            }
            if (column == 4) {
                return cookie.getExpiryDate();
            }
            return null;
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            BasicClientCookie cookie = this.myCookies.get(row);
            if (column == 0) {
                BasicClientCookie replacement = new BasicClientCookie((String)o, cookie.getValue());
                replacement.setDomain(cookie.getDomain());
                replacement.setPath(cookie.getPath());
                replacement.setExpiryDate(cookie.getExpiryDate());
                this.myCookies.remove(row);
                this.myCookies.add(row, replacement);
            } else if (column == 1) {
                cookie.setValue((String)o);
            } else if (column == 2) {
                cookie.setDomain((String)o);
            } else if (column == 3) {
                cookie.setPath((String)o);
            } else if (column == 4) {
                cookie.setExpiryDate((Date)o);
            }
            this.fireTableCellUpdated(row, column);
        }

        public void addRow() {
            this.myCookies.add(new BasicClientCookie("", ""));
            int row = this.myCookies.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void removeRow(int idx) {
            this.myCookies.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public Cookie getCookie(int row) {
            return (Cookie)this.myCookies.get(row);
        }

        public void setCookies(Collection<Cookie> cookies) {
            for (Cookie cookie : cookies) {
                int index = ContainerUtil.indexOf(this.myCookies, ownCookie -> COMPARATOR.compare(cookie, (Cookie)ownCookie) == 0);
                if (index >= 0) {
                    this.myCookies.remove(index);
                    this.myCookies.add(index, (BasicClientCookie)cookie);
                    continue;
                }
                this.myCookies.add((BasicClientCookie)cookie);
            }
            this.fireTableStructureChanged();
        }
    }
}

