/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.converters.curl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.converters.curl.exceptions.CurlParseException;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final Set<String> validRequestOptions = ContainerUtil.newHashSet((Object[])new String[]{"HEAD", "POST", "PUT", "GET", "DELETE", "PATCH", "OPTIONS"});
    private static final String MULTIPART_FORM_HEADER_VALUE = "multipart/form-data";
    private static final String URLENCODED_HEADER_VALUE = "application/x-www-form-urlencoded";
    private static final Set<String> alwaysSetShortOptions = ContainerUtil.newHashSet((Object[])new String[]{"i", "v", "L"});
    private static final Set<String> alwaysSetLongOptions = ContainerUtil.newHashSet((Object[])new String[]{"verbose", "include", "location", "compressed"});
    private static final Set<String> knownLongOptions = ContainerUtil.newHashSet((Object[])new String[]{"url", "request", "header", "user", "form", "data", "data-raw", "data-binary", "data-ascii", "data-urlencode"});
    private static final Set<Character> knownShortOptions = ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf('X'), Character.valueOf('H'), Character.valueOf('u'), Character.valueOf('F'), Character.valueOf('d')});

    public static boolean isKnownLongOption(@NotNull String longOption) {
        if (longOption == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return knownLongOptions.contains(longOption);
    }

    public static boolean isKnownShortOption(@NotNull String shortOption) {
        if (shortOption == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return shortOption.length() > 0 && knownShortOptions.contains(Character.valueOf(shortOption.charAt(0)));
    }

    public static boolean isAlwaysSetLongOption(@NotNull String longOption) {
        if (longOption == null) {
            Utils.$$$reportNull$$$0(2);
        }
        return alwaysSetLongOptions.contains(longOption);
    }

    public static boolean isAlwaysSetShortOption(@NotNull String shortOption) {
        if (shortOption == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return alwaysSetShortOptions.contains(shortOption);
    }

    public static boolean isValidRequestOption(@NotNull String reqOption) {
        if (reqOption == null) {
            Utils.$$$reportNull$$$0(4);
        }
        return validRequestOptions.contains(reqOption);
    }

    public static boolean isLongOption(@NotNull String option) {
        if (option == null) {
            Utils.$$$reportNull$$$0(5);
        }
        return option.length() > 2 && option.startsWith("--");
    }

    public static boolean isShortOption(@NotNull String option) {
        if (option == null) {
            Utils.$$$reportNull$$$0(6);
        }
        return option.length() > 1 && option.startsWith("-") && !Utils.isLongOption(option);
    }

    @NotNull
    public static String updateContentTypeIfNeeded(@NotNull RestClientRequest request, @NotNull String headerValue, @NotNull String contentType) {
        if (request == null) {
            Utils.$$$reportNull$$$0(7);
        }
        if (headerValue == null) {
            Utils.$$$reportNull$$$0(8);
        }
        if (contentType == null) {
            Utils.$$$reportNull$$$0(9);
        }
        String updatedContentType = contentType;
        if (request.multipartBoundary != null) {
            if (contentType.equals(MULTIPART_FORM_HEADER_VALUE)) {
                updatedContentType = headerValue;
            }
        } else {
            updatedContentType = contentType.equals(URLENCODED_HEADER_VALUE) ? headerValue : contentType + ", " + headerValue;
        }
        String string = updatedContentType;
        if (string == null) {
            Utils.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static String deleteBackslashes(@Nullable String data) {
        return data != null ? data.replaceAll("\\\\", "") : null;
    }

    @NotNull
    public static String encodeData(@NotNull String data) {
        String encodedData;
        if (data == null) {
            Utils.$$$reportNull$$$0(11);
        }
        String content = data;
        String name = null;
        if (data.contains("=")) {
            if (data.indexOf("=") == 0) {
                content = data.substring(1);
            } else {
                String[] nameContent = data.split("=", 2);
                name = nameContent[0];
                content = nameContent[1];
            }
        }
        try {
            encodedData = URLEncoder.encode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CurlParseException.newUnsupportedEncodingException(e);
        }
        String string = name != null ? name + "=" + encodedData : encodedData;
        if (string == null) {
            Utils.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isCurlString(@NotNull String string) {
        int pos;
        if (string == null) {
            Utils.$$$reportNull$$$0(13);
        }
        int len = string.length();
        String correctFirstWord = "curl";
        if (len < 5) {
            return false;
        }
        for (pos = 0; pos < len && string.charAt(pos) <= ' '; ++pos) {
        }
        int correctFirstWordIndex = 0;
        while (pos < len && string.charAt(pos) == "curl".charAt(correctFirstWordIndex)) {
            ++pos;
            if (++correctFirstWordIndex != 4) continue;
            if (pos >= len || string.charAt(pos) > ' ') break;
            return true;
        }
        return false;
    }

    @NotNull
    public static String createCurlStringComment(@NotNull String curlString) {
        if (curlString == null) {
            Utils.$$$reportNull$$$0(14);
        }
        String string = String.format("# %s\n", curlString.trim().replaceAll("\\\\\\s|\\n", "\n#"));
        if (string == null) {
            Utils.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longOption";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortOption";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reqOption";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/converters/curl/Utils";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curlString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/converters/curl/Utils";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContentTypeIfNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurlStringComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKnownLongOption";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownShortOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysSetLongOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysSetShortOption";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidRequestOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLongOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isShortOption";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTypeIfNeeded";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "encodeData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCurlString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCurlStringComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

