/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCherryPicker
extends VcsCherryPicker {
    @NotNull
    private final Project myProject;

    public HgCherryPicker(@NotNull Project project) {
        if (project == null) {
            HgCherryPicker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            HgCherryPicker.$$$reportNull$$$0(1);
        }
        return vcsKey;
    }

    @NotNull
    public String getActionTitle() {
        if ("Graft" == null) {
            HgCherryPicker.$$$reportNull$$$0(2);
        }
        return "Graft";
    }

    public void cherryPick(@NotNull List<? extends VcsFullCommitDetails> commits) {
        if (commits == null) {
            HgCherryPicker.$$$reportNull$$$0(3);
        }
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots((RepositoryManager)HgUtil.getRepositoryManager(this.myProject), commits);
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            HgCherryPicker.processGrafting((HgRepository)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), commitDetails -> ((Hash)commitDetails.getId()).asString()));
        }
    }

    private static void processGrafting(@NotNull HgRepository repository, @NotNull List<String> hashes) {
        if (repository == null) {
            HgCherryPicker.$$$reportNull$$$0(4);
        }
        if (hashes == null) {
            HgCherryPicker.$$$reportNull$$$0(5);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        HgGraftCommand command = new HgGraftCommand(project, repository);
        HgCommandResult result = command.startGrafting(hashes);
        boolean hasConflicts = HgConflictResolver.hasConflicts(project, root);
        if (!hasConflicts && HgErrorUtil.isCommandExecutionFailed(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't  graft.");
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        while (hasConflicts) {
            new HgConflictResolver(project, updatedFiles).resolve(root);
            hasConflicts = HgConflictResolver.hasConflicts(project, root);
            if (!hasConflicts) {
                result = command.continueGrafting();
                hasConflicts = HgConflictResolver.hasConflicts(project, root);
                continue;
            }
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't continue grafting");
            break;
        }
        repository.update();
        root.refresh(true, true);
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            HgCherryPicker.$$$reportNull$$$0(6);
        }
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(this.myProject);
        return roots.stream().allMatch(r -> hgRepositoryManager.getRepositoryForRootQuick((VirtualFile)r) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/cherrypick/HgCherryPicker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/cherrypick/HgCherryPicker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processGrafting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canHandleForRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

