/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.branch.HgBranchUtil;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgReferenceValidator;
import org.zmlx.hg4idea.util.HgUtil;

public class HgTaskHandler
extends DvcsTaskHandler<HgRepository> {
    private final HgReferenceValidator myNameValidator;

    public HgTaskHandler(@NotNull Project project) {
        if (project == null) {
            HgTaskHandler.$$$reportNull$$$0(0);
        }
        super((AbstractRepositoryManager)ServiceManager.getService((Project)project, HgRepositoryManager.class), project, "bookmark");
        this.myNameValidator = HgReferenceValidator.getInstance();
    }

    protected void checkout(@NotNull String taskName, @NotNull List<? extends HgRepository> repos, @Nullable Runnable callInAwtLater) {
        if (taskName == null) {
            HgTaskHandler.$$$reportNull$$$0(1);
        }
        if (repos == null) {
            HgTaskHandler.$$$reportNull$$$0(2);
        }
        HgUpdateCommand.updateTo(!HgBranchUtil.getCommonBookmarks(repos).contains(taskName) ? "head() and not bookmark() and branch(\"" + taskName + "\")" : taskName, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<? extends HgRepository> repositories) {
        if (name == null) {
            HgTaskHandler.$$$reportNull$$$0(3);
        }
        if (repositories == null) {
            HgTaskHandler.$$$reportNull$$$0(4);
        }
        HgBookmarkCommand.createBookmarkAsynchronously(repositories, name, true);
    }

    protected String getActiveBranch(HgRepository repository) {
        String bookmark = repository.getCurrentBookmark();
        return bookmark == null ? repository.getCurrentBranch() : bookmark;
    }

    @NotNull
    protected Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull HgRepository repository) {
        if (repository == null) {
            HgTaskHandler.$$$reportNull$$$0(5);
        }
        Iterable names = ContainerUtil.concat((Iterable[])new Iterable[]{HgUtil.getSortedNamesWithoutHashes(repository.getBookmarks()), repository.getOpenedBranches()});
        List list = ContainerUtil.map((Iterable)names, s -> new VcsTaskHandler.TaskInfo(s, Collections.singleton(repository.getPresentableUrl())));
        if (list == null) {
            HgTaskHandler.$$$reportNull$$$0(6);
        }
        return list;
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<? extends HgRepository> repositories) {
        if (branch == null) {
            HgTaskHandler.$$$reportNull$$$0(7);
        }
        if (repositories == null) {
            HgTaskHandler.$$$reportNull$$$0(8);
        }
        String bookmarkRevisionArg = "bookmark(\"" + branch + "\")";
        FileDocumentManager.getInstance().saveAllDocuments();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (HgRepository hgRepository : repositories) {
            HgMergeCommand.mergeWith(hgRepository, bookmarkRevisionArg, updatedFiles, () -> {
                Project project = repository.getProject();
                VirtualFile repositoryRoot = repository.getRoot();
                try {
                    new HgCommitCommand(project, repository, "Automated merge with " + branch).executeInCurrentThread();
                    HgBookmarkCommand.deleteBookmarkSynchronously(project, repositoryRoot, branch);
                }
                catch (HgCommandException e) {
                    HgErrorUtil.handleException(project, e);
                }
                catch (VcsException e) {
                    VcsNotifier.getInstance((Project)project).notifyError("Exception during merge commit with " + branch, e.getMessage());
                }
            });
        }
    }

    protected boolean hasBranch(@NotNull HgRepository repository, @NotNull VcsTaskHandler.TaskInfo name) {
        if (repository == null) {
            HgTaskHandler.$$$reportNull$$$0(9);
        }
        if (name == null) {
            HgTaskHandler.$$$reportNull$$$0(10);
        }
        return HgUtil.getNamesWithoutHashes(repository.getBookmarks()).contains(name.getName()) || repository.getOpenedBranches().contains(name.getName());
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        if (branchName == null) {
            HgTaskHandler.$$$reportNull$$$0(11);
        }
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            HgTaskHandler.$$$reportNull$$$0(12);
        }
        String string = this.myNameValidator.cleanUpBranchName(suggestedName);
        if (string == null) {
            HgTaskHandler.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgTaskHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgTaskHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBranches";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkoutAsNewBranch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllBranches";
                break;
            }
            case 6: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeAndClose";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasBranch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBranchNameValid";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

