/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.layout.AbstractLayoutAction;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction {
    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        GraphBuilder builder = this.getBuilder(e);
        if (builder == null) {
            return;
        }
        Graph2DView view = AbstractGraphAction.getGraph2DView(graph);
        GraphSettings settings = builder.getGraphPresentationModel().getSettings();
        AbstractLayoutAction.doLayout(view, settings.getCurrentLayouter(), builder.getProject(), settings);
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph) {
        Project project = ApplyCurrentLayoutAction.getProject(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project != null && graph != null && graph.getNodeArray().length > 0 && ApplyCurrentLayoutAction.canLayout(this.getBuilder(e), project));
    }

    private static boolean canLayout(GraphBuilder graphBuilder, Project project) {
        if (graphBuilder == null) {
            return false;
        }
        try {
            GraphSettings settings = graphBuilder.getGraphPresentationModel().getSettings();
            return settings.getCurrentLayouter().canLayout(graphBuilder.getGraph());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

