/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.sdk.add.RemoteSdkCreationUtilKt;
import com.jetbrains.python.remote.sdk.add.wizard.AbstractFinishState;
import com.jetbrains.python.remote.sdk.add.wizard.CreateSshInterpreterWizardState;
import com.jetbrains.python.remote.sdk.add.wizard.DeploymentConfigurationUtil;
import com.jetbrains.python.remote.sdk.add.wizard.InternalStateListener;
import com.jetbrains.python.remote.sdk.add.wizard.NewDeploymentServerData;
import com.jetbrains.python.remote.sdk.add.wizard.ui.SshAdditionalConfigurationForm;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ValidationStatusListener;
import com.jetbrains.python.sdk.add.CreateSdkInterrupted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/FinishNewServerConfigurationState;", "Lcom/jetbrains/python/remote/sdk/add/wizard/AbstractFinishState;", "listener", "Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newDeploymentServerData", "Lcom/jetbrains/python/remote/sdk/add/wizard/NewDeploymentServerData;", "previousState", "Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;", "(Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Lcom/jetbrains/python/remote/sdk/add/wizard/NewDeploymentServerData;Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;)V", "form", "Lcom/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm;", "getForm", "()Lcom/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm;", "getListener", "()Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkFolderExists", "", "finish", "previous", "Companion", "intellij.python.remoteInterpreter"})
public final class FinishNewServerConfigurationState
extends AbstractFinishState {
    @NotNull
    private final SshAdditionalConfigurationForm form;
    @NotNull
    private final InternalStateListener listener;
    @Nullable
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    private final NewDeploymentServerData newDeploymentServerData;
    private final CreateSshInterpreterWizardState previousState;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public CreateSshInterpreterWizardState previous() {
        return this.previousState;
    }

    @Override
    @NotNull
    protected SshAdditionalConfigurationForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    public Sdk finish() {
        if (this.getForm().isUploadChanges()) {
            this.checkFolderExists();
        }
        try {
            Project project = this.getProject();
            Credentials credentials = this.newDeploymentServerData.getStoreCredentials();
            boolean bl = !this.newDeploymentServerData.getSaveCredentialsInPermanentStore();
            WebServerConfig webServerConfig = this.newDeploymentServerData.getWebServerConfig();
            String string = this.getForm().getInterpreterPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"form.interpreterPath");
            Sdk sdk = RemoteSdkCreationUtilKt.createSdkFromNewServerConfiguration(project, this.module, credentials, bl, webServerConfig, this.existingSdks, string, this.getForm().isRunAsRootViaSudo());
            this.savePathMappingSettingsOnFinish(this.newDeploymentServerData.getWebServerConfig());
            DeploymentConfigurationUtil.notifyLaterThatDeploymentConfigurationCreated(this.getProject(), this.newDeploymentServerData.getWebServerConfig());
            return sdk;
        }
        catch (RemoteSdkException e) {
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                LOG.debug((Throwable)e);
            }
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFolderExists() {
        void $this$mapNotNullTo$iv$iv;
        SftpChannel channel = ConnectionBuilder.withConnectionTimeout$default((ConnectionBuilder)RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)RemoteSdkCreationUtilKt.getRemoteCredentialsWithAuth(this.newDeploymentServerData.getWebServerConfig(), this.newDeploymentServerData.getStoreCredentials()), (Project)this.getProject(), null, (int)2, null), (long)0L, null, (int)2, null).openSftpChannel(60);
        boolean exists = false;
        List<DeploymentPathMapping> list = this.getForm().getDeploymentPathMappings();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"form.deploymentPathMappings");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DeploymentPathMapping it = (DeploymentPathMapping)element$iv$iv;
            boolean bl2 = false;
            DeploymentPathMapping deploymentPathMapping = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)deploymentPathMapping, (String)"it");
            if (deploymentPathMapping.getDeployPath() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        for (String root : roots) {
            RemoteFileObject file = channel.file(root);
            if (!file.exists()) continue;
            exists = true;
        }
        if (exists && Messages.showYesNoDialog((String)"Automatic upload will overwrite any remote files now, and whenever you make changes locally. Disable automatic upload to manage your files manually.", (String)"Directory Exists", (String)"Overwrite", (String)"Back", (Icon)Messages.getWarningIcon()) == 1) {
            throw (Throwable)new CreateSdkInterrupted();
        }
    }

    @Override
    @NotNull
    public InternalStateListener getListener() {
        return this.listener;
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.project;
    }

    public FinishNewServerConfigurationState(@NotNull InternalStateListener listener, @Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @NotNull NewDeploymentServerData newDeploymentServerData2, @NotNull CreateSshInterpreterWizardState previousState) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)newDeploymentServerData2, (String)"newDeploymentServerData");
        Intrinsics.checkParameterIsNotNull((Object)previousState, (String)"previousState");
        this.listener = listener;
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.newDeploymentServerData = newDeploymentServerData2;
        this.previousState = previousState;
        this.form = new SshAdditionalConfigurationForm(this.getProject(), this.newDeploymentServerData.getRemoteCredentialsWithAuth(), this.newDeploymentServerData.getUsername(), this.newDeploymentServerData.getHost(), this.newDeploymentServerData.getPort());
        this.getForm().setListener(new ValidationStatusListener(){

            @Override
            public void onValidationStatusChanged() {
                this.getListener().onControlsChanged();
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FinishNewServerConfigurationState.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Finis\u2026urationState::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/FinishNewServerConfigurationState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.remoteInterpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

