/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlNamedStubElementType<S extends SqlNamedElementStub<T>, T extends SqlElement>
extends SqlStubElementType<S, T> {
    protected final SqlReferenceElementType myType;

    public SqlNamedStubElementType(@NonNls @NotNull String debugName, @Nullable SqlReferenceElementType refType) {
        if (debugName == null) {
            SqlNamedStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
        this.myType = refType;
    }

    @Nullable
    public SqlReferenceElementType getTargetReferenceType() {
        return this.myType;
    }

    public void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlNamedStubElementType.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            SqlNamedStubElementType.$$$reportNull$$$0(2);
        }
        dataStream.writeName(((SqlNamedElementStub)((Object)stub)).getName());
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        if (this == SqlCompositeElementTypes.SQL_RETURNS_CLAUSE) {
            ASTNode parent2 = node.getTreeParent();
            IElementType pType = PsiUtilCore.getElementType((ASTNode)parent2);
            return pType instanceof IStubElementType && ((IStubElementType)pType).shouldCreateStub(parent2);
        }
        if (this == SqlCompositeElementTypes.SQL_TYPE_DEFINITION || this == SqlCompositeElementTypes.SQL_COLLECTION_TYPE_DEFINITION) {
            ASTNode parent3 = SqlNamedStubElementType.getSqlParent(node);
            IElementType elementType = PsiUtilCore.getElementType((ASTNode)parent3);
            ObjectKind pKind = SqlNamedStubElementType.getDefKind(parent3);
            return pKind != ObjectKind.BODY && pKind != ObjectKind.ROUTINE && pKind != null && elementType != SqlCompositeElementTypes.SQL_BLOCK_STATEMENT;
        }
        if (this.myType == null) {
            return false;
        }
        if (this.myType.getTargetKind() == ObjectKind.EXCEPTION) {
            return SqlNamedStubElementType.getDefKind(SqlNamedStubElementType.getSqlParent(node)) == ObjectKind.PACKAGE;
        }
        if (this.myType.getTargetKind() == ObjectKind.ARGUMENT) {
            ASTNode parent4 = SqlNamedStubElementType.getSqlParent(node);
            ASTNode gParent = SqlNamedStubElementType.getSqlParent(parent4);
            IElementType gpType = PsiUtilCore.getElementType((ASTNode)gParent);
            return PsiUtilCore.getElementType((ASTNode)parent4) == SqlCompositeElementTypes.SQL_PARAMETER_LIST && gpType instanceof IStubElementType && ((IStubElementType)gpType).shouldCreateStub(gParent);
        }
        if (this.myType.getTargetKind() == ObjectKind.ROUTINE) {
            SqlDefinitionStubElementType pType = (SqlDefinitionStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((ASTNode)SqlNamedStubElementType.getSqlParent(node)), SqlDefinitionStubElementType.class));
            SqlReferenceElementType refType = pType == null ? null : pType.getTargetReferenceType();
            return refType == null || refType.getTargetKind() != ObjectKind.BODY;
        }
        if (this.myType.getTargetKind() == SqlDbElementType.CURSOR) {
            return false;
        }
        if (this.myType.getTargetKind() == ObjectKind.VARIABLE) {
            ASTNode stubParent = SqlNamedStubElementType.getSqlStubParent(node);
            ObjectKind pKind = SqlNamedStubElementType.getDefKind(stubParent);
            if (pKind != null) {
                return pKind == ObjectKind.PACKAGE && SqlNamedStubElementType.shouldCreateStubFor(stubParent);
            }
            SqlFileElementType fileType = (SqlFileElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((ASTNode)SharedImplUtil.findFileElement((ASTNode)node)), SqlFileElementType.class));
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)((Object)ObjectUtils.tryCast((Object)(fileType == null ? null : fileType.getLanguage()), SqlLanguageDialectEx.class));
            return language != null && language.getDbms().isDb2();
        }
        return true;
    }

    @Nullable
    private static ObjectKind getDefKind(ASTNode node) {
        return SqlNamedStubElementType.getDefKind(PsiUtilCore.getElementType((ASTNode)node));
    }

    @Nullable
    private static ObjectKind getDefKind(IElementType elementType) {
        SqlDefinitionStubElementType type = (SqlDefinitionStubElementType)((Object)ObjectUtils.tryCast((Object)elementType, SqlDefinitionStubElementType.class));
        SqlReferenceElementType refType = type == null ? null : type.getTargetReferenceType();
        return refType == null ? null : refType.getTargetKind();
    }

    private static boolean shouldCreateStubFor(ASTNode node) {
        IElementType type = PsiUtilCore.getElementType((ASTNode)node);
        return type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node);
    }

    @Nullable
    protected static ASTNode getSqlParent(@Nullable ASTNode node) {
        ASTNode aSTNode = node = node == null ? null : node.getTreeParent();
        while (node != null && node.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
            node = node.getTreeParent();
        }
        return node;
    }

    @Nullable
    protected static ASTNode getSqlStubParent(@Nullable ASTNode node) {
        ASTNode aSTNode = node = node == null ? null : node.getTreeParent();
        while (node != null) {
            if (PsiUtilCore.getElementType((ASTNode)node) instanceof IStubElementType) {
                return node;
            }
            node = node.getTreeParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/stubs/SqlNamedStubElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

