/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.database.model.PsiTable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlIntroduceTableAliasIntention;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\nH\u0016J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlInlineTableAliasIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "()V", "findAsExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "asExpression", "isAvailable", "", "isSuitable", "intellij.database.sql.impl"})
public final class SqlInlineTableAliasIntention
extends BaseIntentionAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return "Inline table alias";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.isSuitable(this.findAsExpression(editor, file));
    }

    public final boolean isSuitable(@Nullable SqlAsExpression asExpression) {
        if (asExpression == null || !(asExpression.getExpression() instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlExpression sqlExpression = asExpression.getExpression();
        if (sqlExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        PsiElement element2 = ((SqlReferenceExpression)sqlExpression).resolve();
        if (!(element2 instanceof PsiTable)) {
            return false;
        }
        SqlResultSetExpression topExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, element2);
        if (topExpression == null) {
            return false;
        }
        SqlExpression sqlExpression2 = asExpression.getExpression();
        if (sqlExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        return !SqlNamesGenerator.collectExistingNames((PsiElement)topExpression, (Condition<? super PsiElement>)((Condition)new Condition<PsiElement>(asExpression){
            final /* synthetic */ SqlAsExpression $asExpression;

            public final boolean value(PsiElement it2) {
                if (Intrinsics.areEqual((Object)it2, (Object)this.$asExpression)) {
                    return true;
                }
                if (it2 instanceof SqlNameElement && Intrinsics.areEqual((Object)((SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)it2, SqlDefinition.class)), (Object)this.$asExpression)) {
                    return true;
                }
                return it2 instanceof SqlReferenceExpression;
            }
            {
                this.$asExpression = sqlAsExpression;
            }
        })).contains(((SqlReferenceExpression)sqlExpression2).getName());
    }

    private final SqlAsExpression findAsExpression(Editor editor, PsiFile file) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement element2 = file.findElementAt(offset);
        if (SqlIntroduceTableAliasIntention.Companion.shouldLookBehind(element2) && offset > 0) {
            element2 = file.findElementAt(offset - 1);
        }
        if (element2 == null) {
            return null;
        }
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAsExpression.class);
        if (asExpression == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)asExpression.getNameElement()), (PsiElement)element2, (boolean)false)) {
            return null;
        }
        asExpression.getExpression();
        return asExpression;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        SqlAsExpression sqlAsExpression = this.findAsExpression(editor, file);
        if (sqlAsExpression == null) {
            Intrinsics.throwNpe();
        }
        this.invoke(sqlAsExpression);
    }

    public final void invoke(@NotNull SqlAsExpression asExpression) throws IncorrectOperationException {
        Intrinsics.checkParameterIsNotNull((Object)asExpression, (String)"asExpression");
        SqlExpression sqlExpression = asExpression.getExpression();
        if (sqlExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        PsiElement psiElement = ((SqlReferenceExpression)sqlExpression).resolve();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.PsiTable");
        }
        PsiTable psiTable = (PsiTable)psiElement;
        SqlResultSetExpression sqlResultSetExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, (PsiElement)psiTable);
        if (sqlResultSetExpression == null) {
            Intrinsics.throwNpe();
        }
        SqlResultSetExpression topExpression = sqlResultSetExpression;
        SqlExpression sqlExpression2 = asExpression.getExpression();
        if (sqlExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        }
        SqlReferenceExpression expression = (SqlReferenceExpression)sqlExpression2;
        String text2 = expression.getText();
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlEditorOptions, (String)"SqlEditorOptions.getInstance()");
        SqlEditorOptions.QualificationType qualificationType = sqlEditorOptions.getTableQualification();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)qualificationType), (String)"SqlEditorOptions.getInstance().tableQualification");
        SqlEditorOptions.QualificationType tableQualification = qualificationType;
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)asExpression), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)topExpression)));
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(\u2026archScope(topExpression))");
        Iterable $this$forEach$iv = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlReferenceExpression referenceFromText;
            PsiElement psiElement2;
            PsiReference it2 = (PsiReference)element$iv;
            boolean bl = false;
            PsiReference psiReference = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference.getElement(), (String)"it.element");
            if (!(psiElement2 instanceof SqlReferenceExpression)) continue;
            PsiElement parent2 = ((SqlReferenceExpression)psiElement2).getParent();
            if (parent2 instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)parent2).getQualifierExpression(), (Object)psiElement2) && tableQualification != SqlEditorOptions.QualificationType.ALWAYS) {
                SqlIdentifier sqlIdentifier = ((SqlReferenceExpression)parent2).getIdentifier();
                String name2 = sqlIdentifier != null ? sqlIdentifier.getText() : null;
                SqlResultSetExpression top = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)parent2, (PsiElement)psiTable);
                if (name2 != null && top != null && !SqlNamesGenerator.collectExistingNames((PsiElement)top, (Condition<? super PsiElement>)((Condition)new Condition<PsiElement>(tableQualification, psiTable, asExpression, text2){
                    final /* synthetic */ SqlEditorOptions.QualificationType $tableQualification$inlined;
                    final /* synthetic */ PsiTable $psiTable$inlined;
                    final /* synthetic */ SqlAsExpression $asExpression$inlined;
                    final /* synthetic */ String $text$inlined;
                    {
                        this.$tableQualification$inlined = qualificationType;
                        this.$psiTable$inlined = psiTable;
                        this.$asExpression$inlined = sqlAsExpression;
                        this.$text$inlined = string;
                    }

                    public final boolean value(PsiElement node) {
                        PsiElement resolved;
                        SqlExpression qualifierExpression;
                        return node instanceof SqlReferenceExpression && (qualifierExpression = ((SqlReferenceExpression)node).getQualifierExpression()) instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)(resolved = ((SqlReferenceExpression)qualifierExpression).resolve()), (Object)this.$asExpression$inlined);
                    }
                })).contains(name2)) {
                    SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(name2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2);
                    if (sqlReferenceExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    parent2.replace((PsiElement)sqlReferenceExpression);
                    continue;
                }
            }
            if (SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2) == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)referenceFromText, (String)"SqlPsiElementFactory.cre\u2026lementType, psiElement)!!");
            psiElement2.replace((PsiElement)referenceFromText);
        }
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe((PsiElement)asExpression), expression.getReferenceElementType(), (PsiElement)asExpression);
        if (sqlReferenceExpression == null) {
            Intrinsics.throwNpe();
        }
        asExpression.replace((PsiElement)sqlReferenceExpression);
    }
}

