/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TreePattern;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.inspections.SqlResolveInspection;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCurrentSchemaInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        if ("SqlCurrentSchemaInspection" == null) {
            SqlCurrentSchemaInspection.$$$reportNull$$$0(0);
        }
        return "SqlCurrentSchemaInspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ObjectPath path;
        PsiFile topLevelFile;
        VirtualFile vfile;
        if (file == null) {
            SqlCurrentSchemaInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlCurrentSchemaInspection.$$$reportNull$$$0(2);
        }
        if (!isOnTheFly || !(file instanceof SqlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, vfile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile());
        ObjectPath objectPath = path = console == null ? null : console.getCurrentNamespace();
        if (path == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        TreePattern scope = console.getDataSource().getIntrospectionScope();
        if (DataSourceSchemaMapping.matches(scope, path)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DasObject nsp = (DasObject)QNameUtil.findByPath(console.getDataSource().getModel(), path).first();
        if (nsp != null && DataSourceSchemaMapping.isIntrospected(scope, nsp)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DbDataSource dbDataSource = DbPsiFacade.getInstance((Project)project).findDataSource(console.getDataSource().getUniqueId());
        ArrayList<SqlResolveInspection.IntrospectSchemaFix> fixes = new ArrayList<SqlResolveInspection.IntrospectSchemaFix>();
        if (dbDataSource != null) {
            fixes.add(new SqlResolveInspection.IntrospectSchemaFix(Collections.singletonList(Pair.create((Object)dbDataSource, (Object)path)), path.kind));
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, "Current " + DbPresentation.getPresentableName(path.kind, DbImplUtil.getDatabaseDialect((DbElement)dbDataSource)) + " is not introspected.", true, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    private static boolean isGenericExplicitly(PsiFile file) {
        VirtualFile vfile = file.getVirtualFile();
        if (ScratchFileService.isInScratchRoot((VirtualFile)vfile)) {
            return true;
        }
        SqlLanguageDialect dialect = SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(vfile, file.getProject());
        if (dialect == SqlDialects.getGenericDialect()) {
            return true;
        }
        if (dialect != null) {
            return false;
        }
        SqlDialectMappings instance = SqlDialectMappings.getInstance(file.getProject());
        return instance != null && instance.getDirectlyConfiguredMapping(null) == SqlDialects.getGenericDialect();
    }

    @Nullable
    public static SqlLanguageDialect getSuggestedLanguage(@NotNull IntentionAction fix) {
        MyQuickFix quickFix;
        if (fix == null) {
            SqlCurrentSchemaInspection.$$$reportNull$$$0(3);
        }
        return (quickFix = (MyQuickFix)((Object)ObjectUtils.tryCast((Object)fix, MyQuickFix.class))) == null ? null : quickFix.myDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlCurrentSchemaInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlCurrentSchemaInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMetric
    extends PsiRecursiveElementWalkingVisitor {
        int errors;
        int composites;

        private MyMetric() {
        }

        public double getMetric() {
            try {
                double d2 = this.errors == 0 ? (double)(this.composites * 4) : (double)this.composites / (double)this.errors;
                return d2;
            }
            finally {
                this.errors = 0;
                this.composites = 0;
            }
        }

        public void visitElement(PsiElement element2) {
            if (element2 instanceof PsiErrorElement) {
                ++this.errors;
            } else if (element2 instanceof SqlCompositeElement) {
                ++this.composites;
            }
            super.visitElement(element2);
        }
    }

    public static class MyQuickFix
    extends IntentionAndQuickFixAction {
        private final SqlLanguageDialect myDialect;

        public MyQuickFix(@Nullable SqlLanguageDialect dialect) {
            this.myDialect = dialect;
        }

        @NotNull
        public String getName() {
            String string = this.myDialect == null ? "Change dialect to..." : "Use " + this.myDialect.getDisplayName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            boolean injected;
            PsiFile topLevelFile;
            VirtualFile virtualFile;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((virtualFile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile()) == null) {
                return;
            }
            boolean bl = injected = topLevelFile != file;
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if (this.myDialect == null) {
                if (injected || !ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                    SqlDialectsConfigurable.openDialectsConfigurable(project, virtualFile);
                } else {
                    RelativePoint point = RelativePoint.fromScreen((Point)MouseInfo.getPointerInfo().getLocation());
                    ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<? extends VirtualFile>)JBIterable.of((Object)virtualFile));
                    if (editor == null || !editor.getComponent().isShowing()) {
                        popup.show(point);
                    } else {
                        JRootPane rootPane = editor.getComponent().getRootPane();
                        Component componentAt = rootPane.findComponentAt(point.getPoint((Component)rootPane));
                        if (componentAt instanceof HyperlinkLabel) {
                            popup.setMinimumSize(componentAt.getSize());
                            popup.showUnderneathOf(componentAt);
                        } else {
                            popup.showInBestPositionFor(editor);
                        }
                    }
                }
            } else {
                ChangeDialectAction.setDialectImpl(project, virtualFile, (Language)this.myDialect, injected);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlCurrentSchemaInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlCurrentSchemaInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

