/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FirstAndContinuePattern$WhenMappings;
import com.intellij.sql.formatter.model.FlowContinuePattern;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.StepResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/model/FirstAndContinuePattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "firstNodeMatcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "continuePattern", "Lcom/intellij/sql/formatter/model/FlowContinuePattern;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "(Lcom/intellij/sql/formatter/model/NodeMatcher;Lcom/intellij/sql/formatter/model/FlowContinuePattern;Lkotlin/jvm/functions/Function0;)V", "expandSingleNode", "", "getExpandSingleNode", "()Z", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "toString", "", "intellij.database.sql.impl"})
public final class FirstAndContinuePattern
extends FlowPattern {
    private final NodeMatcher firstNodeMatcher;
    private final FlowContinuePattern continuePattern;

    @Override
    @Nullable
    public IntRange process(@NotNull List<? extends ASTNode> nodes2, int since) {
        int n;
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int n2 = nodes2.size();
        if (since >= n2) {
            return null;
        }
        ASTNode firstNode = nodes2.get(since);
        if (!this.firstNodeMatcher.matches(firstNode)) {
            return null;
        }
        if (this.continuePattern.limitLength() == Integer.MAX_VALUE) {
            n = n2;
        } else {
            int n3 = since + this.continuePattern.limitLength();
            boolean bl = false;
            n = Math.min(n3, n2);
        }
        int nLimited = n;
        int acceptedTill = 0;
        int k = since + 1;
        while (k <= nLimited && acceptedTill == 0) {
            ASTNode node = k < n2 ? nodes2.get(k) : null;
            ++k;
            if (node != null) {
                IElementType t_k;
                if (node instanceof PsiErrorElement) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)node.getElementType(), (String)"node.elementType");
                if (t_k == TokenType.WHITE_SPACE) continue;
            }
            StepResult r = this.continuePattern.input(node);
            switch (FirstAndContinuePattern$WhenMappings.$EnumSwitchMapping$0[r.ordinal()]) {
                case 1: {
                    acceptedTill = -1;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    acceptedTill = k - 1;
                    break;
                }
                case 4: {
                    acceptedTill = k;
                }
            }
        }
        while (acceptedTill > since && this.continuePattern.rollback(nodes2.get(acceptedTill - 1))) {
            --acceptedTill;
        }
        return acceptedTill > since ? RangesKt.until((int)since, (int)acceptedTill) : null;
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.continuePattern.getRole();
    }

    @Override
    public boolean getExpandSingleNode() {
        return this.continuePattern.expandSingleNode();
    }

    @NotNull
    public String toString() {
        return "Continue with " + this.continuePattern;
    }

    public FirstAndContinuePattern(@NotNull NodeMatcher firstNodeMatcher, @NotNull FlowContinuePattern continuePattern, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkParameterIsNotNull((Object)firstNodeMatcher, (String)"firstNodeMatcher");
        Intrinsics.checkParameterIsNotNull((Object)continuePattern, (String)"continuePattern");
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        super(producer, null);
        this.firstNodeMatcher = firstNodeMatcher;
        this.continuePattern = continuePattern;
    }
}

