/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hive;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.hive.HiveDialectBase;
import com.intellij.sql.dialects.hive.HiveReservedKeywords;
import com.intellij.sql.dialects.hive.HiveTokens;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HiveDialect
extends HiveDialectBase {
    public static final HiveDialect INSTANCE = new HiveDialect();

    public HiveDialect() {
        super("HiveQL");
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            HiveDialect.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            HiveDialect.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            HiveDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            HiveDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.HIVE;
        if (dbms == null) {
            HiveDialect.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    @Override
    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = HiveDialect.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                HiveDialect.$$$reportNull$$$0(5);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, true);
        if (treePattern == null) {
            HiveDialect.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        ObjectKind kind;
        if (element2 == null) {
            HiveDialect.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            HiveDialect.$$$reportNull$$$0(8);
        }
        if (!super.processReservedEntitiesWithType(name2, element2, resolve, processor)) {
            return false;
        }
        if (processor.isExpected(ObjectKind.COLUMN) && DbImplUtil.isDataTable(kind = SqlImplUtil.getQualifierKind(element2))) {
            if (!HiveDialect.processReservedEntitiesWithTypeSimple(LazyData.INPUT_FILE_NAME, this.stringType(), name2, element2, resolve, processor, true, null)) {
                return false;
            }
            if (!HiveDialect.processReservedEntitiesWithTypeSimple(LazyData.BLOCK_OFFSET_INSIDE_FILE, this.integerType(), name2, element2, resolve, processor, true, null)) {
                return false;
            }
        }
        return true;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            HiveDialect.$$$reportNull$$$0(9);
        }
        if (type == ObjectKind.MACRO && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type != ObjectKind.TABLE) {
            return super.shallResolve(o, type);
        }
        PsiElement clause = o.getParent();
        if (clause.getNode().getElementType() == HiveTypes.HIVE_IN_TABLE_CLAUSE) {
            return false;
        }
        return super.shallResolve(o, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/hive/HiveDialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/hive/HiveDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final ReservedEntity INPUT_FILE_NAME = new ReservedEntity("INPUT__FILE__NAME", ObjectKind.COLUMN);
        static final ReservedEntity BLOCK_OFFSET_INSIDE_FILE = new ReservedEntity("BLOCK__OFFSET__INSIDE__FILE", ObjectKind.COLUMN);
        static final TokenClasses ourClasses = new TokenClasses(HiveTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens(HiveTokens.class);
            ourReservedKeywords = SqlTokenRegistry.getTokens(HiveReservedKeywords.class);
        }
    }
}

