/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.greenplum;

import com.intellij.database.Dbms;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.greenplum.GPlumElementFactory;
import com.intellij.sql.dialects.greenplum.GPlumTokens;
import com.intellij.sql.dialects.greenplum.GPlumTypes;
import com.intellij.sql.dialects.postgres.Pg83Dialect;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GPlumDialect
extends Pg83Dialect {
    public static final GPlumDialect INSTANCE = new GPlumDialect();

    public GPlumDialect() {
        super("Greenplum");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.GREENPLUM;
        if (dbms == null) {
            GPlumDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            GPlumDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            GPlumDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            GPlumDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            GPlumDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            GPlumDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    protected List<ReservedEntity> getReservedObjects() {
        List<ReservedEntity> list = LazyData.ourObjects;
        if (list == null) {
            GPlumDialect.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        IElementType res2;
        if (name2 == null) {
            GPlumDialect.$$$reportNull$$$0(7);
        }
        return (res2 = GPlumElementFactory.findComposite(name2)) == null ? super.getFunctionParserExtension(name2) : res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/greenplum/GPlumDialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedObjects";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/greenplum/GPlumDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(GPlumTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final Set<String> ourExceptionNames;
        static final List<ReservedEntity> ourObjects;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
            ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_QUESTION_MARK, GPlumTypes.GPLUM_OP_ABS, SqlTokens.SQL_OP_NOT2, GPlumTypes.GPLUM_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, GPlumTypes.GPLUM_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2});
        }
    }
}

