/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectRefEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableRefEditor {
    private final DeModel myModel;
    @Nullable
    private final BasicModel myTargetModel;
    private final DatabaseObjectRefEditor<BasicTable> myDelegate;
    private DeTable myStubCache;

    public DatabaseTableRefEditor(@NotNull DeModel model, @NotNull DatabaseEditorContext context) {
        if (model == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myTargetModel = context.getModel();
        this.myDelegate = new DatabaseObjectRefEditor<BasicTable>(context){

            @Override
            protected Icon getIcon(@NotNull BasicTable item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DatabaseIcons.Table;
            }

            @Override
            @NotNull
            protected String getName(@NotNull BasicTable item) {
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = item.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            @Nullable
            protected String getParentName(@NotNull BasicTable item) {
                BasicElement parent2;
                if (item == null) {
                    1.$$$reportNull$$$0(3);
                }
                return (parent2 = item.getParent()) == null ? null : parent2.getName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getParentName";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myDelegate.setItems((JBIterable<BasicTable>)(this.myTargetModel == null ? JBIterable.empty() : this.myTargetModel.traverser().filter(BasicTable.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.TABLE))));
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField = this.myDelegate.getEditor();
        if (editorTextField == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(2);
        }
        return editorTextField;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate.getName();
        if (string == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DeTable getObject() {
        BasicTable res2 = this.myDelegate.getObject();
        if (res2 == null) {
            return null;
        }
        return (DeTable)this.myModel.getExportHelper().exportDeep(this.myTargetModel, res2, true);
    }

    public void setObject(@Nullable DeTable obj2) {
        this.myDelegate.setObject(obj2 == null ? null : obj2.name);
    }

    @NotNull
    public DeTable getObjectOrStub(@Nullable DeNamespace parent2) {
        DeTable res2 = this.getObject();
        if (res2 == null) {
            String name2 = this.getName();
            if (this.myStubCache == null || !this.myStubCache.name.equals(name2)) {
                this.myStubCache = DatabaseTableRefEditor.createStub(name2, parent2, this.myModel);
            }
            res2 = this.myStubCache;
        }
        DeTable deTable = res2;
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(4);
        }
        return deTable;
    }

    @NotNull
    public static DeTable createStub(@NotNull String name2, @Nullable DeNamespace parent2, @NotNull DeModel model) {
        if (name2 == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(6);
        }
        DeTable deTable = EditorModelUtil.setStub(new DeTable(name2, parent2, model));
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectOrStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

