/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.ThreeStateCheckBox;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseEditorBase
implements Disposable {
    protected boolean myUpdating;
    private final DatabaseEditorState myState;

    public DatabaseEditorBase(@NotNull DatabaseEditorState state2) {
        if (state2 == null) {
            DatabaseEditorBase.$$$reportNull$$$0(0);
        }
        this.myState = state2;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        if (databaseEditorContext == null) {
            DatabaseEditorBase.$$$reportNull$$$0(1);
        }
        return databaseEditorContext;
    }

    public Project getProject() {
        return this.getContext().getProject();
    }

    @NotNull
    public abstract EditorModelBase getModel();

    protected void updateFromModel() {
        this.myUpdating = true;
        try {
            this.updateFromModelImpl();
        }
        finally {
            this.myUpdating = false;
        }
    }

    protected void markInvalid() {
        this.myState.markInvalid(this);
    }

    protected void markValid() {
        this.myState.markValid(this);
    }

    public boolean areEditorsValid() {
        return this.myState.areAllEditorsValid();
    }

    protected abstract void updateFromModelImpl();

    protected static void setValue(@NotNull EditorTextField field, @NotNull String value) {
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(2);
        }
        if (value == null) {
            DatabaseEditorBase.$$$reportNull$$$0(3);
        }
        if (!value.equals(field.getText())) {
            field.setText(value);
        }
    }

    protected static void setValue(@NotNull JCheckBox field, boolean value) {
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(4);
        }
        if (value != field.isSelected()) {
            field.setSelected(value);
        }
    }

    protected static void setValue(@NotNull ThreeStateCheckBox field, ThreeState value) {
        ThreeStateCheckBox.State state2;
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(5);
        }
        ThreeStateCheckBox.State state3 = value == ThreeState.YES ? ThreeStateCheckBox.State.SELECTED : (state2 = value == ThreeState.NO ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        if (state2 != field.getState()) {
            field.setState(state2);
        }
    }

    protected static void setValue(@NotNull JTextField field, @NotNull String value) {
        if (field == null) {
            DatabaseEditorBase.$$$reportNull$$$0(6);
        }
        if (value == null) {
            DatabaseEditorBase.$$$reportNull$$$0(7);
        }
        if (!value.equals(field.getText())) {
            field.setText(value);
        }
    }

    @NotNull
    public abstract JComponent getComponent();

    @NotNull
    public abstract JComponent getPreferredFocusedComponent();

    public void dispose() {
        this.markValid();
    }

    @NotNull
    public String getObjectName(@Nullable DeObject ref) {
        String string = ref == null ? "" : this.getContext().getDialect().quoteIdentifier(ref.name, false, false);
        if (string == null) {
            DatabaseEditorBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    public DatabaseEditorState getState() {
        return this.myState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorBase";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

