/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialogsHelper {
    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(1);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(2);
        }
        EditorTextField editorTextField = DatabaseDialogsHelper.createLanguageEditorArea(project, dataSource.getDbms(), dataSource, searchPath, query, isViewer);
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(3);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull DatabaseEditorContext context, @Nullable SearchPath searchPath, @NotNull String query) {
        if (context == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(4);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(5);
        }
        EditorTextField editorTextField = DatabaseDialogsHelper.createLanguageEditorArea(context.getProject(), context.getDbms(), context.getDataSource(), searchPath, query, false);
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(6);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull Dbms dbms, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(8);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(9);
        }
        SqlLanguageDialect language = dataSource != null ? DbSqlUtil.getSqlDialect((DbElement)dataSource) : DbSqlUtil.getSqlDialect(dbms);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)query);
        psiFile.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)dataSource);
        psiFile.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)searchPath);
        EditorTextField area = DatabaseDialogsHelper.createEditorTextField(psiFile, false, isViewer);
        area.setFontInheritedFromLAF(false);
        area.addSettingsProvider(editor -> {
            editor.getSettings().setWheelFontChangeEnabled(true);
            editor.getSettings().setFoldingOutlineShown(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            editor.getSettings().setUseSoftWraps(true);
        });
        EditorTextField editorTextField = area;
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(10);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorField(PsiFile psiFile) {
        EditorTextField editorTextField = DatabaseDialogsHelper.createEditorTextField(psiFile, true, false);
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(11);
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createEditorTextField(PsiFile psiFile, boolean oneLine, boolean isViewer) {
        Project project = psiFile.getProject();
        Language dialect = psiFile.getLanguage();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        EditorTextField textField = new EditorTextField(document, project, psiFile.getFileType(), isViewer, oneLine);
        textField.addSettingsProvider(editor -> {
            DatabaseDialogsHelper.setSpecificSyntaxHighlighter(project, dialect, editor, psiFile.getVirtualFile());
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.getSettings().setLineNumbersShown(false);
        });
        EditorTextField editorTextField = textField;
        if (editorTextField == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(12);
        }
        return editorTextField;
    }

    public static void setSpecificSyntaxHighlighter(Project project, Language dialect, EditorEx editor, VirtualFile file) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)project, (VirtualFile)file);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
    }

    public static void setSyntaxHighlighter(@NotNull Project project, EditorEx editor) {
        VirtualFile file;
        SqlLanguageDialect dialect;
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(13);
        }
        if ((dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)(file = FileDocumentManager.getInstance().getFile((Document)editor.getDocument()))), SqlLanguageDialect.class)) == null) {
            dialect = SqlPsiFacade.getInstance((Project)project).getDefaultDialect();
        }
        DatabaseDialogsHelper.setSpecificSyntaxHighlighter(project, (Language)dialect, editor, file);
    }

    public static DdlBuilder createDdlBuilder(@NotNull DatabaseEditorContext context, boolean forCreate) {
        if (context == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(14);
        }
        return DatabaseDialogsHelper.createDdlBuilder(context.getProject(), context.getDialect(), context.getSqlDialect(), context.getCasingProvider(), forCreate).pushDefaultSchema(SearchPath.getCurrent((SearchPath)context.getSearchPath()));
    }

    public static DdlBuilder createDdlBuilder(@Nullable Project project, @NotNull DatabaseDialectEx dialect, SqlLanguageDialect sqlDialect, @Nullable CasingProvider provider, boolean forCreate) {
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(15);
        }
        return DatabaseDialogsHelper.createDdlBuilder(forCreate).withDialect(dialect).applyCodeStyle(project, sqlDialect).withCasing((CasingProvider)ObjectUtils.chooseNotNull((Object)provider, (Object)dialect));
    }

    public static DdlBuilder createDdlBuilder(@NotNull DbElement source, boolean forCreate) {
        if (source == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(16);
        }
        return DatabaseDialogsHelper.createDdlBuilder(forCreate).configureFor(source).pushDefaultSchema(ObjectPaths.of((DasObject)DbImplUtil.getSearchPathObject(source)));
    }

    public static DdlBuilder createDdlBuilder(final boolean forCreate) {
        return new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder newName(@NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.newName(newName);
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v0;
            }

            @Override
            @NotNull
            public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name2) {
                boolean suppress;
                if (name2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                boolean bl = suppress = object != null && this.isNameModifiedOrNew(object, name2);
                if (suppress) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.identifier(object, name2);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v1 = this;
                if (v1 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return v1;
            }

            @Override
            @NotNull
            public DdlBuilder constraintRef(@NotNull DasObject object) {
                boolean suppress;
                if (object == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (suppress = this.isNameModifiedOrNew(object, object.getName())) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.constraintRef(object);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return v0;
            }

            private boolean isNameModifiedOrNew(@Nullable DasObject obj2, @NotNull String name2) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return obj2 != null && !name2.equals(obj2.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelper$1";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "newName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "identifier";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "constraintRef";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "newName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "identifier";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "constraintRef";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "isNameModifiedOrNew";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.qualifyReferences(true).splitStatements(true).suppressQuoteIdentifiers(forCreate);
    }

    public static void setTextFieldLanguage(@NotNull EditorTextField field, @NotNull SqlLanguageDialect dialect) {
        if (field == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(17);
        }
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(18);
        }
        LightVirtualFile file = new LightVirtualFile("a.sql", (Language)dialect, (CharSequence)field.getText());
        field.setDocument(FileDocumentManager.getInstance().getDocument((VirtualFile)file));
    }

    public static void setupEnclosingScrollPane(@NotNull JScrollPane scrollPane) {
        if (scrollPane == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(19);
        }
        scrollPane.setBorder(null);
        JComponent view2 = (JComponent)scrollPane.getViewport().getView();
        view2.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        GridLayoutManager layoutManager = (GridLayoutManager)ObjectUtils.tryCast((Object)view2.getLayout(), GridLayoutManager.class);
        if (layoutManager != null) {
            layoutManager.setHGap(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageEditorArea";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageEditorField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageEditorArea";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSyntaxHighlighter";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDdlBuilder";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setTextFieldLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingScrollPane";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

