/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSqlUtil {
    private DbSqlUtil() {
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info) {
        DasObject delegate = info instanceof DbElement ? ((DbElement)info).getDelegate() : info;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element2) {
        SqlLanguageDialect language;
        if (element2 == null) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            if (element2 instanceof DbElement) {
                return DbSqlUtil.getSqlDialect((DbElement)element2);
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            language = LanguageUtil.getLanguageForPsi((Project)element2.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(@Nullable Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(0);
            }
            return condition;
        }
        Condition condition = file -> {
            ObjectKind kind;
            if (file.isDirectory() || !file.isValid()) {
                return false;
            }
            ObjectKind objectKind = !(file instanceof DatabaseElementVirtualFileImpl) ? null : (kind = ((DatabaseElementVirtualFileImpl)((Object)file)).isBusy() ? ObjectKind.NONE : ((DatabaseElementVirtualFileImpl)((Object)file)).getObjectKind());
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
            return file.getFileType() == SqlFileType.INSTANCE || LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        SqlFile sqlFile;
        if (file == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        if (attr == null) {
            DbSqlUtil.$$$reportNull$$$0(3);
        }
        return (T)((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class)) != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtil.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        return !delim.equals(";");
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        DdlBuilder.Colored colored = new DdlBuilder.Colored();
        DatabaseDialectEx dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXmlEntities((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getQueries(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        ScriptModel model = facade.createScriptModel(DbSqlUtil.createTemporaryFile(text2, project, language));
        List list = model.statements().transform(ScriptModelUtil.TO_TEXT).toList();
        List list2 = list;
        if (list2 == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        return list2;
        finally {
            Disposer.dispose((Disposable)model);
        }
    }

    @NotNull
    private static PsiFile createTemporaryFile(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("a", language, (CharSequence)text2);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            throw new AssertionError((Object)("language: " + language.getID() + "; text length: " + text2.length()));
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        return psiFile;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        JBIterable<DbDataSource> jBIterable = DbSqlUtil.getAppropriateDataSources(sqlFile, true, false);
        if (jBIterable == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (sqlFile == null) {
            DbSqlUtil.$$$reportNull$$$0(20);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)sqlFile.getProject());
        boolean isReadonly = sqlFile.getViewProvider().getVirtualFile() instanceof ReadOnlyLightVirtualFile;
        SqlLanguageDialect sqlDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect((PsiElement)sqlFile), (Object)SqlDialects.getGenericDialect());
        JBIterable resultAll = JBIterable.from((Iterable)facade.getDataSources()).filter(ds -> (!isReadonly || !(ds instanceof SqlDataSource)) && ds.isValid());
        JBIterable resultSelected = resultAll.filter(ds -> DbImplUtil.getDatabaseDialect((DbElement)ds).similarTo(sqlDialect.getDatabaseDialect()));
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)sqlFile);
        if (!isReadonly && forResolve && virtualFile != null && virtualFile.getFileType() == SqlFileType.INSTANCE && !(sqlDataSources = resultAll.filterMap(o -> o.getDelegate() instanceof SqlDataSource ? o : null).filter(o -> ((SqlDataSource)o.getDelegate()).containsFile(virtualFile)).collect()).isEmpty()) {
            JBIterable jBIterable = sqlDataSources;
            if (jBIterable == null) {
                DbSqlUtil.$$$reportNull$$$0(21);
            }
            return jBIterable;
        }
        JBIterable jBIterable = !matchingOnly && resultSelected.isEmpty() ? resultAll : resultSelected;
        if (jBIterable == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource dataSource) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        if (dataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        if (dataSource instanceof DbDataSource) {
            return (DbDataSource)dataSource;
        }
        return DbPsiFacade.getInstance((Project)project).findDataSource(dataSource.getUniqueId());
    }

    @Nullable
    public static DbElement findElement(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        if (path == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        return ((DbDataSourceImpl)dbDataSource).findElement(path);
    }

    @NotNull
    public static JBIterable<DasObject> findObjects(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        if (path == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        JBIterable<DasObject> jBIterable = ((DbDataSourceImpl)dbDataSource).findObjects(path);
        if (jBIterable == null) {
            DbSqlUtil.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable DataRequest request, @NotNull List<? extends DataConsumer.Column> columns) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(30);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        DataConsumer.Column tableColumn = null;
        if (!columns.isEmpty()) {
            for (DataConsumer.Column column2 : columns) {
                if (StringUtil.isNotEmpty((String)column2.table) && (tableColumn == null || Comparing.equal((String)column2.catalog, (String)tableColumn.catalog) && Comparing.equal((String)column2.schema, (String)tableColumn.schema) && Comparing.equal((String)column2.table, (String)tableColumn.table))) {
                    tableColumn = column2;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        DasTable table = null;
        if (language instanceof SqlLanguageDialect && queryText != null) {
            void var9_12;
            if (request instanceof ConsoleDataRequest && ((ConsoleDataRequest)request).resultType instanceof SqlTableType) {
                SqlTableType sqlTableType = (SqlTableType)((ConsoleDataRequest)request).resultType;
            } else {
                SqlTableType sqlTableType = DbSqlUtil.parseQueryType(project, (SqlLanguageDialect)language, dataSource, searchPath, queryText, null);
            }
            PsiElement element2 = var9_12 == null ? null : var9_12.getTypeElement();
            DasTable dasTable = table = element2 instanceof DasTable ? (DasTable)element2 : null;
            if (table == null && element2 instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)element2;
                String name2 = ref.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref.getReferencePart(ObjectKind.DATABASE);
                String schema = refSchema.isEmpty() && tableColumn != null && tableColumn.schema != null ? tableColumn.schema : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.catalog != null ? tableColumn.catalog : refCatalog;
                table = DbImplUtil.getModelHelper(Dbms.UNKNOWN).sqlCreateFakeTable(catalog, schema, name2);
            }
        }
        if (tableColumn != null && table != null) {
            String catalog;
            Dbms dbms = ((SqlLanguageDialect)language).getDbms();
            boolean dbIsSchema = dbms.isMysql() || dbms == Dbms.CLICKHOUSE;
            String schema = dbIsSchema ? DasUtil.NO_NAME : DasUtil.getSchema(table);
            String string = catalog = dbIsSchema ? DasUtil.getSchema(table) : DasUtil.getCatalog(table);
            if (StringUtil.isNotEmpty((String)tableColumn.table) && !table.getName().equals(tableColumn.table) || StringUtil.isNotEmpty((String)tableColumn.schema) && !schema.equals(tableColumn.schema) || StringUtil.isNotEmpty((String)tableColumn.catalog) && !catalog.isEmpty() && !catalog.equals(tableColumn.catalog)) {
                table = null;
            }
        }
        return table;
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type, null);
        int count2 = type.getColumnCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            String name2 = columnNames.get(i2);
            String typeName = type.getColumnType(i2).getDisplayName();
            columns.add(new DataConsumer.Column(i2, name2, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList<DataConsumer.Column> arrayList = columns;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates, forceQualify);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates, forceQualify);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(47);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(48);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(49);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(50);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(51);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project, DbSqlUtil.getSqlDialect(dialect)).withDialect(dialect);
        for (int i2 = 0; i2 < columnNames.size(); ++i2) {
            String name2 = columnNames.get(i2);
            String typeAlias = type.getColumnTypeAlias(i2);
            if (typeAlias != null && (duplicates.contains(name2) || forceQualify != null && ((Boolean)forceQualify.fun((Object)type, (Object)i2)).booleanValue())) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i2));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i2));
            builder.columnRef(name2);
            columnNames.set(i2, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList<String> columnNames = new ArrayList<String>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i2)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        THashSet duplicates = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        THashSet distinctNames = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (String name2 : names) {
            if (distinctNames.add(name2)) continue;
            duplicates.add(name2);
        }
        return duplicates;
    }

    @NotNull
    public static List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref) {
        String text2;
        if (ref == null) {
            DbSqlUtil.$$$reportNull$$$0(52);
        }
        if (!"*".equals(text2 = StringUtil.notNullize((String)ref.getText())) && !text2.endsWith(".*")) {
            PsiElement resolve = ref.getReference().resolve();
            List<Object> list = resolve == null ? Collections.emptyList() : Collections.singletonList(resolve);
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(53);
            }
            return list;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(54);
            }
            return list;
        }
        ArrayList<PsiElement> res2 = new ArrayList<PsiElement>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            res2.add(type.getColumnElement(i2));
        }
        ArrayList<PsiElement> arrayList = res2;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @Nullable
    public static SqlResultSetExpression parseQuery(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(56);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(57);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(58);
        }
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlFile sql = psiFacade.createROFile(language, (CharSequence)queryText, hostLanguage);
        SyntaxTraverser traverser2 = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sql);
        SqlResultSetExpression queryExpression = (SqlResultSetExpression)traverser2.filter(SqlResultSetExpression.class).first();
        if (queryExpression == null || queryExpression.getTextRange().getStartOffset() != 0) {
            return null;
        }
        SqlSelectIntoClause selectIntoClause = (SqlSelectIntoClause)traverser2.filter(SqlSelectIntoClause.class).first();
        if (selectIntoClause != null) {
            return null;
        }
        return queryExpression;
    }

    @Nullable
    public static SqlTableType parseQueryType(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String queryText, @Nullable Language hostLanguage) {
        SqlResultSetExpression sql;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(59);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(60);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(61);
        }
        if ((sql = DbSqlUtil.parseQuery(project, dialect, queryText, hostLanguage)) == null) {
            return null;
        }
        sql.getContainingFile().putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)dataSource);
        sql.getContainingFile().putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)searchPath);
        return (SqlTableType)ObjectUtils.tryCast((Object)sql.getSqlType(), SqlTableType.class);
    }

    public static boolean isResultEditable(@Nullable DataRequest request, DasTable detectedTable) {
        DasTable table;
        if (!(request instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request instanceof ConsoleDataRequest)) {
            return true;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((ConsoleDataRequest)request).resultType, SqlTableType.class);
        if (type == null) {
            return false;
        }
        PsiElement element2 = type.getTypeElement();
        Object object = element2 instanceof DasTable ? (DasTable)element2 : (table = element2 instanceof SqlReferenceExpression ? detectedTable : null);
        if (table == null || DasUtil.getColumns((DasObject)table).isEmpty()) {
            return false;
        }
        return DbImplUtil.isDataTable(table.getKind());
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s, @Nullable ObjectPath ns, @NotNull DasModel model) {
        ObjectPath objectName;
        ObjectKind kind;
        if (s == null) {
            DbSqlUtil.$$$reportNull$$$0(62);
        }
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(63);
        }
        IntrospectionScopeUpdater res2 = null;
        ObjectPath db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlSynonymDefinition statement : ((SyntaxTraverser)s.expand(Conditions.instanceOf(SqlAlterStatement.class))).filter(SqlSynonymDefinition.class)) {
            kind = statement.getKind();
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            SqlNameElement newName = statement.getNameElement();
            SqlReferenceExpression oldName = statement.getTargetReference();
            if (newName == null || oldName == null) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            ObjectPath parent2 = kind == ObjectKind.SCHEMA ? db : null;
            ObjectPath oldObjectName = ObjectPath.create((String)oldName.getName(), (ObjectKind)kind, (boolean)oldName.isQuotedIdentifier(), null, (ObjectPath)parent2);
            ObjectPath newObjectName = ObjectPath.create((String)newName.getName(), (ObjectKind)kind, (boolean)newName.isQuotedIdentifier(), null, (ObjectPath)parent2);
            res2.toRemove(oldObjectName);
            res2.toAdd(newObjectName);
        }
        for (SqlSynonymDefinition statement : s.filter(SqlCreateStatement.class)) {
            SqlNameElement element2;
            kind = statement.getKind();
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA || (element2 = statement.getNameElement()) == null) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create((String)element2.getName(), (ObjectKind)kind, (boolean)element2.isQuotedIdentifier(), null, (ObjectPath)(kind == ObjectKind.SCHEMA ? db : null));
            res2.toAdd(objectName);
        }
        for (SqlSynonymDefinition statement : s.filter(SqlDropStatement.class)) {
            ObjectKind kind2;
            SqlReferenceExpression expression = statement.getTargetExpression();
            if (expression == null || (kind2 = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create((String)expression.getName(), (ObjectKind)kind2, (boolean)expression.isQuotedIdentifier(), null, (ObjectPath)(kind2 == ObjectKind.SCHEMA ? db : null));
            res2.toRemove(objectName);
        }
        return res2;
    }

    @Nullable
    public static ObjectPath getCurrentDatabase(@NotNull DasModel model) {
        DasNamespace cur;
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(64);
        }
        if ((cur = model.getCurrentRootNamespace()) == null) {
            Iterator it2 = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it2.hasNext()) {
                return null;
            }
            cur = (DasNamespace)it2.next();
            if (it2.hasNext()) {
                return null;
            }
        }
        return cur.getKind() == ObjectKind.DATABASE ? ObjectPaths.of((DasObject)cur) : null;
    }

    @Nullable
    private static ObjectPath getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(65);
        }
        return ns.findParent(ObjectKind.DATABASE, false);
    }

    public static ObjectName getName(@Nullable DasObject object) {
        return object == null ? null : new ObjectName(object.getName(), DbSqlUtil.isQuoted(object));
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable String name2, boolean quoted, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtil.$$$reportNull$$$0(66);
        }
        if (name2 == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(67);
            }
            return condition;
        }
        NameChecker checker = new NameChecker(name2, quoted, provider, null);
        Condition condition = object -> (id == null || id.equalsIgnoreCase(ObjectPaths.getIdentity(object))) && checker.checkName(object, null);
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(68);
        }
        return condition;
    }

    public static boolean isQuoted(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtil.isQuoted((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlDefinition) {
            return ((SqlDefinition)object).isNameQuoted();
        }
        if (object instanceof SqlNameElement) {
            return DbSqlUtil.isQuoted((SqlNameElement)object);
        }
        if (object instanceof BasicElement) {
            return BasicPaths.isQuoted((BasicElement)object);
        }
        return true;
    }

    public static boolean isSqlObject(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtil.isSqlObject((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlElement) {
            return true;
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameScripted();
        }
        return false;
    }

    public static boolean isQuoted(@Nullable SqlNameElement element2) {
        return element2 != null && element2.isQuotedIdentifier();
    }

    public static boolean isSqlElement(@NotNull DbElement element2) {
        DbDataSource dataSource;
        if (element2 == null) {
            DbSqlUtil.$$$reportNull$$$0(69);
        }
        return element2 != (dataSource = element2.getDataSource()) && dataSource.getDelegate() instanceof SqlDataSource;
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DbElement element2) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element2 == null ? null : (DasObject)ObjectUtils.tryCast((Object)element2.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlElement(element2.getDataSource(), dasObject);
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DbDataSource dataSource, @Nullable DasObject dasObject) {
        if (dataSource == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbElement element2) {
        DbDataSourceImpl dataSource = element2 == null ? null : (DbDataSourceImpl)((Object)ObjectUtils.tryCast((Object)element2.getDataSource(), DbDataSourceImpl.class));
        SqlLanguageDialect sqlLanguageDialect = dataSource == null ? SqlDialects.getGenericDialect() : dataSource.getSqlDialect();
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(70);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res2;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(71);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtil.findSqlDialect(dialect)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(72);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Dbms dbms) {
        SqlLanguageDialect res2;
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(73);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtil.findSqlDialect(dbms)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(74);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(75);
        }
        return DbSqlUtil.findSqlDialect(dialect.getDbms());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(76);
        }
        return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(dbms);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable LocalDataSource dataSource) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(dataSource);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(77);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @NotNull DasDataSource databaseSystem) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(78);
        }
        if (databaseSystem == null) {
            DbSqlUtil.$$$reportNull$$$0(79);
        }
        if (databaseSystem instanceof DbDataSource) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)((DbDataSource)databaseSystem));
            if (sqlLanguageDialect == null) {
                DbSqlUtil.$$$reportNull$$$0(80);
            }
            return sqlLanguageDialect;
        }
        if (databaseSystem instanceof LocalDataSource) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((LocalDataSource)databaseSystem);
            if (sqlLanguageDialect == null) {
                DbSqlUtil.$$$reportNull$$$0(81);
            }
            return sqlLanguageDialect;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(databaseSystem.getUniqueId());
        SqlLanguageDialect sqlLanguageDialect = dataSource == null ? SqlDialects.getGenericDialect() : DbSqlUtil.getSqlDialect((DbElement)dataSource);
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(82);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        String defaultDialect = dataSource.getDefaultDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)defaultDialect) ? null : SqlDialects.findDialectById(defaultDialect);
        return result2 != null ? result2 : DbSqlUtil.guessSqlDialect(dataSource);
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseDialectEx dbDialect = connectionInfo == null ? null : DbImplUtil.guessDatabaseDialect(connectionInfo);
        return dbDialect == null ? null : DbSqlUtil.findSqlDialect(dbDialect);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DatabaseDriver driver) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(driver);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(83);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable DatabaseDriver driver) {
        if (driver == null) {
            return null;
        }
        String dialectId = driver.getSqlDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)dialectId) ? null : SqlDialects.findDialectById(dialectId);
        return result2 != null ? result2 : DbSqlUtil.getSqlDialect(DbImplUtil.getDbms(driver));
    }

    @Deprecated
    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getGenericSqlSettings((Project)project);
        Case keywordCaseMode = SqlCodeStyleSettings.getCaseMode((int)codeStyleSettings.KEYWORD_CASE);
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project, @NotNull Language dialect) {
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(84);
        }
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect);
        Case keywordCaseMode = SqlCodeStyleSettings.getCaseMode((int)codeStyleSettings.KEYWORD_CASE);
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean isSqlFile(@NotNull PsiFile file) {
        if (file == null) {
            DbSqlUtil.$$$reportNull$$$0(85);
        }
        return file instanceof SqlFile || file.getFileType() == SqlFileType.INSTANCE;
    }

    public static boolean stringsAreEscapedWithSlash(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(86);
        }
        return dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isRedshift() || dbms.isSnowflake();
    }

    public static boolean supportsEscapeStringLiterals(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(87);
        }
        return dbms.isGreenplum() || dbms == Dbms.POSTGRES || dbms.isVertica();
    }

    @Nullable
    public static String toStringLiteral(@Nullable String value, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(88);
        }
        return DbSqlUtil.toStringLiteral(value, dbms, false, "", "");
    }

    @Nullable
    @Contract(value="!null, _, _, _, _ -> !null")
    public static String toStringLiteral(@Nullable String value, @NotNull Dbms dbms, boolean escapeSqlRegexSymbols, @Nullable String prefix, @Nullable String suffix) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(89);
        }
        if (value == null) {
            return null;
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
        SqlRegexDecorator sqlRegexDecorator = escapeSqlRegexSymbols && helper.supportsEscape() ? SqlRegexDecorator.WITH_ESCAPE_CLAUSE : (escapeSqlRegexSymbols ? SqlRegexDecorator.DEFAULT : SqlRegexDecorator.NONE);
        return DbSqlUtil.toStringLiteralInner(value, dbms, sqlRegexDecorator, StringUtil.notNullize((String)prefix), StringUtil.notNullize((String)suffix));
    }

    @NotNull
    private static String toStringLiteralInner(@NotNull String value, @NotNull Dbms dbms, @NotNull SqlRegexDecorator sqlRegexDecorator, @NotNull String prefix, @NotNull String suffix) {
        if (value == null) {
            DbSqlUtil.$$$reportNull$$$0(90);
        }
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(91);
        }
        if (sqlRegexDecorator == null) {
            DbSqlUtil.$$$reportNull$$$0(92);
        }
        if (prefix == null) {
            DbSqlUtil.$$$reportNull$$$0(93);
        }
        if (suffix == null) {
            DbSqlUtil.$$$reportNull$$$0(94);
        }
        if ((value.contains("\n") || value.contains("\t") || value.contains("\r")) && (DbSqlUtil.stringsAreEscapedWithSlash(dbms) || DbSqlUtil.supportsEscapeStringLiterals(dbms))) {
            value = StringUtil.escapeBackSlashes((String)value);
            value = sqlRegexDecorator.decorateInner(value, dbms);
            value = StringUtil.escapeChar((String)value, (char)'\'');
            value = StringUtil.escapeLineBreak((String)value);
            value = value.replace("\t", "\\t");
            value = "'" + prefix + value + suffix + "'";
            value = DbSqlUtil.supportsEscapeStringLiterals(dbms) ? "e" + value : value;
        } else {
            value = sqlRegexDecorator.decorateInner(value, dbms);
            String escapeChar = DbSqlUtil.stringsAreEscapedWithSlash(dbms) ? "\\" : "'";
            value = value.replace("'", escapeChar + "'");
            value = "'" + prefix + value + suffix + "'";
            value = dbms.isMicrosoft() ? 'N' + value : value;
        }
        String string = sqlRegexDecorator.decorateOuter(value, dbms);
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(95);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 2: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 23: 
            case 30: 
            case 33: 
            case 38: 
            case 42: 
            case 47: 
            case 56: 
            case 59: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 31: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 34: 
            case 39: 
            case 43: 
            case 48: 
            case 60: 
            case 71: 
            case 75: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 35: 
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 73: 
            case 76: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlRegexDecorator";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesForResolve";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSources";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 41: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToColumnList";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 70: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralInner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlFileAttributeAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "delimiterNeedsSpacing";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForResolve";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSources";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "resolveToColumnList";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "parseQuery";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isSqlElement";
                break;
            }
            case 71: 
            case 73: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findSqlDialect";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "areKeywordsLowerCase";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isSqlFile";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "stringsAreEscapedWithSlash";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "supportsEscapeStringLiterals";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteral";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SqlRegexDecorator {
        NONE(false, false),
        DEFAULT(true, false),
        WITH_ESCAPE_CLAUSE(true, true);

        private final boolean escapeSqlRegex;
        private final boolean appendEscapeClause;

        private SqlRegexDecorator(boolean escapeSqlRegex, boolean appendEscapeClause) {
            this.escapeSqlRegex = escapeSqlRegex;
            this.appendEscapeClause = appendEscapeClause;
        }

        @NotNull
        String decorateInner(@NotNull String value, @NotNull Dbms dbms) {
            if (value == null) {
                SqlRegexDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(1);
            }
            if (!this.escapeSqlRegex) {
                String string = value;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(2);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
            if (!DbSqlUtil.stringsAreEscapedWithSlash(dbms) && !helper.supportsEscape()) {
                value = StringUtil.escapeBackSlashes((String)value);
            }
            String string = (String)helper.escapeSqlRegex((Object)value, true);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String decorateOuter(@NotNull String value, @NotNull Dbms dbms) {
            if (value == null) {
                SqlRegexDecorator.$$$reportNull$$$0(4);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(5);
            }
            if (!this.appendEscapeClause) {
                String string = value;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(6);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
            if (value.indexOf(helper.getEscapeChar()) == -1) {
                String string = value;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = value + " escape '" + helper.getEscapeChar() + "'";
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbSqlUtil$SqlRegexDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbSqlUtil$SqlRegexDecorator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateInner";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateOuter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateInner";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateOuter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

