/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeObject {
    @NotNull
    public String name;
    @NotNull
    public DeModel model;
    @Nullable
    public String comment;
    @Nullable
    private Object editedObject;
    public boolean lightExported;
    public Set<DeObject> lightChildren;
    public final Map<Key, Object> additional;
    public final transient Map<Key, Object> flags;

    @Nullable
    protected Object getEditedObject() {
        return this.editedObject;
    }

    public boolean hasEdited() {
        return this.editedObject != null;
    }

    @NotNull
    public String getPrevName() {
        if (this.editedObject instanceof DeObject) {
            String string = ((DeObject)this.editedObject).getName();
            if (string == null) {
                DeObject.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.editedObject instanceof BasicElement) {
            String string = ((BasicElement)this.editedObject).getName();
            if (string == null) {
                DeObject.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            DeObject.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected ObjectKind getPrevKind(@NotNull ObjectKind def) {
        DeObject de;
        if (def == null) {
            DeObject.$$$reportNull$$$0(3);
        }
        if ((de = this.getEditedDeObject()) != null) {
            ObjectKind objectKind = de.getKind();
            if (objectKind == null) {
                DeObject.$$$reportNull$$$0(4);
            }
            return objectKind;
        }
        BasicElement basic = this.getEditedBasic();
        if (basic != null) {
            ObjectKind objectKind = basic.getKind();
            if (objectKind == null) {
                DeObject.$$$reportNull$$$0(5);
            }
            return objectKind;
        }
        ObjectKind objectKind = def;
        if (objectKind == null) {
            DeObject.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Nullable
    public DeObject getEditedDeObject() {
        return (DeObject)ObjectUtils.tryCast((Object)this.editedObject, DeObject.class);
    }

    @Nullable
    public BasicElement getEditedBasic() {
        return (BasicElement)ObjectUtils.tryCast((Object)this.editedObject, BasicElement.class);
    }

    @Nullable
    public BasicElement unwrap() {
        Object tmp = this.editedObject;
        while (tmp instanceof DeObject) {
            tmp = ((DeObject)tmp).editedObject;
        }
        return (BasicElement)tmp;
    }

    public void setEditedObject(@Nullable DeObject editedObject) {
        this.editedObject = editedObject;
    }

    public void setEditedObject(@Nullable BasicElement editedObject) {
        this.editedObject = editedObject;
    }

    protected DeObject(@NotNull DeModel model) {
        if (model == null) {
            DeObject.$$$reportNull$$$0(7);
        }
        this.name = "";
        this.lightChildren = null;
        this.additional = new HashMap<Key, Object>();
        this.flags = new HashMap<Key, Object>();
        this.model = model;
    }

    public DeObject(@NotNull String name2, @NotNull DeModel model) {
        if (name2 == null) {
            DeObject.$$$reportNull$$$0(8);
        }
        if (model == null) {
            DeObject.$$$reportNull$$$0(9);
        }
        this.name = "";
        this.lightChildren = null;
        this.additional = new HashMap<Key, Object>();
        this.flags = new HashMap<Key, Object>();
        this.name = name2;
        this.model = model;
    }

    @NotNull
    public abstract DeObject emptyClone(@NotNull DeModel var1);

    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj2, boolean withChildren, @NotNull DeCopier copier) {
        if (obj2 == null) {
            DeObject.$$$reportNull$$$0(10);
        }
        if (copier == null) {
            DeObject.$$$reportNull$$$0(11);
        }
        this.name = obj2.name;
        this.comment = obj2.comment;
        this.editedObject = obj2.editedObject;
        this.lightExported = true;
        if (withChildren) {
            this.copyChildrenFrom(obj2, copier);
        }
        DeObject deObject = this;
        if (deObject == null) {
            DeObject.$$$reportNull$$$0(12);
        }
        return deObject;
    }

    @NotNull
    public static <De extends DeObject> De copy(@NotNull De obj2, boolean withChildren, @NotNull DeCopier copier) {
        if (obj2 == null) {
            DeObject.$$$reportNull$$$0(13);
        }
        if (copier == null) {
            DeObject.$$$reportNull$$$0(14);
        }
        De De = copier.copy(obj2, withChildren);
        if (De == null) {
            DeObject.$$$reportNull$$$0(15);
        }
        return De;
    }

    public void copyChildrenFrom(@NotNull DeObject obj2, @NotNull DeCopier copier) {
        if (obj2 == null) {
            DeObject.$$$reportNull$$$0(16);
        }
        if (copier == null) {
            DeObject.$$$reportNull$$$0(17);
        }
        this.lightExported = false;
    }

    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            DeObject.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @Nullable
    public abstract DeObject getParent();

    @NotNull
    public JBIterable<DeObject> getLightChildren() {
        JBIterable jBIterable = JBIterable.from(this.lightChildren);
        if (jBIterable == null) {
            DeObject.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    public void addLightChild(@NotNull DeObject child) {
        if (child == null) {
            DeObject.$$$reportNull$$$0(20);
        }
        if (this.lightChildren == null) {
            this.lightChildren = new LinkedHashSet<DeObject>();
        }
        this.lightChildren.add(child);
    }

    public final boolean isAltered(@NotNull DeObject other) {
        if (other == null) {
            DeObject.$$$reportNull$$$0(21);
        }
        return this.isAlteredIgnoringChild(other, Collections.emptySet(), Collections.emptySet());
    }

    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DeObject> otherChildren) {
        if (other == null) {
            DeObject.$$$reportNull$$$0(22);
        }
        if (children2 == null) {
            DeObject.$$$reportNull$$$0(23);
        }
        if (otherChildren == null) {
            DeObject.$$$reportNull$$$0(24);
        }
        return !this.name.equals(other.name) || !Comparing.equal((String)this.comment, (String)other.comment) || !ContainerUtil.diff(this.additional, other.additional).isEmpty();
    }

    public String toString() {
        return this.name + "(" + this.getClass().getSimpleName() + ")";
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DeObject.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public abstract ObjectKind getKind();

    @NotNull
    public JBIterable<DeObject> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable children2 = !this.lightExported ? this.getChildren() : this.getLightChildren();
        JBIterable jBIterable = kind == null ? children2 : children2.filter(o -> o.getKind() == kind);
        if (jBIterable == null) {
            DeObject.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    public short getPosition() {
        return this.getEditedObject() instanceof DasPositioned ? ((DasPositioned)this.getEditedObject()).getPosition() : (short)0;
    }

    @NotNull
    public ObjectPath getPath() {
        DeObject parent2 = this.getParent();
        ObjectName name2 = DeObject.create(this.model.getExportHelper().getContext().getDialect(), this);
        ObjectPath objectPath = ObjectPath.create((String)name2.name, (ObjectKind)this.getKind(), (boolean)name2.quoted, null, (ObjectPath)(parent2 == null ? null : parent2.getPath()));
        if (objectPath == null) {
            DeObject.$$$reportNull$$$0(27);
        }
        return objectPath;
    }

    private static ObjectName create(@NotNull DatabaseDialect dialect, @Nullable DeObject obj2) {
        if (dialect == null) {
            DeObject.$$$reportNull$$$0(28);
        }
        if (obj2 == null) {
            return null;
        }
        String name2 = obj2.getName();
        boolean quoted = dialect.isQuotedIdentifier(name2);
        name2 = dialect.unquoteIdentifier(name2);
        return new ObjectName(name2, quoted);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevName";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeObject";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevKind";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightChildren";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrevKind";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyChildrenFrom";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addLightChild";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAltered";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DeCopier {
        @Contract(value="null, _ -> null; !null, _ -> !null")
        public <De extends DeObject> De copy(De var1, boolean var2);
    }
}

