/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultNumericEditorFactory
extends FormatBasedGridCellEditorFactory {
    DefaultNumericEditorFactory() {
    }

    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Formatter format;
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(2);
        }
        if ((format = DefaultNumericEditorFactory.getFormat(grid, column2)) != null) {
            Formatter formatter = format;
            if (formatter == null) {
                DefaultNumericEditorFactory.$$$reportNull$$$0(3);
            }
            return formatter;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridModel model;
        DataConsumer.Column c2;
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(4);
        }
        if (row == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(5);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(6);
        }
        return ObjectFormatter.isNumericColumn(c2 = (DataConsumer.Column)ObjectUtils.notNull((Object)(model = grid.getDataModel(DataAccessType.DATABASE_DATA)).getColumn(column2))) && DefaultNumericEditorFactory.getFormat(grid, column2) != null ? 1 : 0;
    }

    @Nullable
    private static Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(8);
        }
        ObjectFormatter formatter = grid.getObjectFormatter();
        DataConsumer.Column c2 = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2));
        switch (ExtractorsUtil.guessJdbcType(c2)) {
            case -6: 
            case 4: 
            case 5: {
                return formatter.getNumberFormat();
            }
            case -5: {
                return formatter.getBigIntFormat();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return formatter.getDecimalFormat(c2);
            }
        }
        if (ObjectFormatter.isFloatingPoint(c2) || ObjectFormatter.isBigDecimal(c2)) {
            return formatter.getDecimalFormat(c2);
        }
        return null;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (project == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(9);
        }
        if (grid == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(10);
        }
        if (format == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(12);
        }
        NumericEditor numericEditor = new NumericEditor(project, grid, format, column2, value, nullValue, initiator, provider);
        if (numericEditor == null) {
            DefaultNumericEditorFactory.$$$reportNull$$$0(13);
        }
        return numericEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
            case 3: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NumericEditor
    extends FormatBasedGridCellEditor {
        NumericEditor(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object value, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator, @Nullable TextCompletionProvider provider) {
            if (project == null) {
                NumericEditor.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                NumericEditor.$$$reportNull$$$0(1);
            }
            if (format == null) {
                NumericEditor.$$$reportNull$$$0(2);
            }
            if (column2 == null) {
                NumericEditor.$$$reportNull$$$0(3);
            }
            super(project, grid, format, column2, value, nullValue, initiator, provider);
            this.getTextField().addSettingsProvider(editor -> DataGridUtil.configureNumericEditor(grid, (Editor)editor));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "format";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory$NumericEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

