/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.ScriptingSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.client.VisibleSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingClientDataConsumer
implements DataConsumer {
    private static final String ID_RESULT = "ResultTab";
    private static final String DEFAULT_TITLE = "Result";
    private static final Key<GridInfo> GRID_INFO_KEY = Key.create((String)"GRID_INFO_KEY");
    private static final Key<TableEditorBase> FILE_EDITOR_KEY = Key.create((String)"ResultPanel.MyTableFileEditor");
    private final Alarm myAlarm;
    private final PlaceInGrid myPlace;
    private final Supplier<VirtualFile> myFileSupplier;
    private final LogView<?> myView;
    private final Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> myHookUpFactory;
    private final Project myProject;
    private final VisibleSessionClient<?, ?> myClient;
    private int myMajorRequestCount;
    private int myMinorRequestCount;
    private Content myCurrentContent;
    private final MultiMap<DataRequest, Content> myPreparedContentMap;

    private ScriptingClientDataConsumer(@NotNull Project project, @NotNull VisibleSessionClient<?, ?> client, @NotNull PlaceInGrid place, @NotNull Supplier<VirtualFile> fileSupplier, @NotNull Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> hookUpFactory) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(0);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(2);
        }
        if (fileSupplier == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(3);
        }
        if (hookUpFactory == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(4);
        }
        this(project, client, place, fileSupplier, (LogView<?>)((VisibleSession)client.getSession()).getView(), hookUpFactory);
    }

    private ScriptingClientDataConsumer(@NotNull Project project, @NotNull VisibleSessionClient<?, ?> client, @NotNull PlaceInGrid place, @NotNull Supplier<VirtualFile> fileSupplier, @NotNull LogView<?> view2, @NotNull Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> hookUpFactory) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(5);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(6);
        }
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(7);
        }
        if (fileSupplier == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(8);
        }
        if (view2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(9);
        }
        if (hookUpFactory == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(10);
        }
        this.myPreparedContentMap = MultiMap.createWeakKey();
        this.myProject = project;
        this.myClient = client;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, client);
        this.myPlace = place;
        this.myFileSupplier = fileSupplier;
        this.myView = view2;
        this.myHookUpFactory = hookUpFactory;
        client.getMessageBus().addAuditor(new MyAuditor());
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, @NotNull ScriptingSessionClient client, @NotNull LogView<?> view2) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(11);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(12);
        }
        if (view2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(13);
        }
        PlaceInGrid place = client.getResultsPlaceInView();
        Supplier<VirtualFile> vfSupplier = client::getVirtualFile;
        Function huFun = client::createGridDataHookUp;
        ScriptingClientDataConsumer consumer2 = new ScriptingClientDataConsumer(project, client, place, vfSupplier, view2, (Function<Disposable, GridDataHookUp<DataConsumer.Row, DataConsumer.Column>>)huFun);
        client.getMessageBus().addConsumer(DataGridUtil.createEDTSafeWrapper(consumer2, client));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer2;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(14);
        }
        return scriptingClientDataConsumer;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, final @NotNull JdbcConsole client, @NotNull LogView<?> view2) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(15);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(16);
        }
        if (view2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(17);
        }
        Function hookUpFactory = client::createGridDataHookUp;
        PlaceInGrid place = client.getResultsPlaceInView();
        Supplier<VirtualFile> vFileGetter = client::getVirtualFile;
        ScriptingClientDataConsumer consumer2 = new ScriptingClientDataConsumer(project, (VisibleSessionClient)client, place, vFileGetter, view2, hookUpFactory){

            @Override
            protected boolean isClientValid() {
                return client.isValid();
            }
        };
        client.getMessageBus().addConsumer(new PreventingExtraResultsConsumer(DataGridUtil.createEDTSafeWrapper(consumer2, client)));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer2;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(18);
        }
        return scriptingClientDataConsumer;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, final @NotNull VisibleDatabaseSessionClient client) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(19);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(20);
        }
        ScriptingClientDataConsumer consumer2 = new ScriptingClientDataConsumer(project, (VisibleSessionClient)client, PlaceInGrid.center, () -> null, d2 -> {
            DatabaseSession session2 = (DatabaseSession)client.getSession();
            return GridDataHookUpManager.getInstance(project).createReadOnlyDatabaseHookUp((Disposable)d2, "", client.getDepartment(), session2);
        }){

            @Override
            protected boolean isClientValid() {
                return client.isValid();
            }
        };
        client.getMessageBus().addConsumer(new PreventingExtraResultsConsumer(DataGridUtil.createEDTSafeWrapper(consumer2, client)));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer2;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(21);
        }
        return scriptingClientDataConsumer;
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        Content content;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(22);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        this.myCurrentContent = null;
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        ScriptingClientDataConsumer.consumerFor(dataGrid).afterLastRowAdded(context, total);
    }

    public void resetOutputTabCounter() {
        this.myMajorRequestCount = 0;
        this.myMinorRequestCount = 0;
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(23);
        }
        if (!this.isClientValid() || !((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        Content content = this.myCurrentContent = this.getPreparedContentFor((DataRequest.Context)context, (int)resultSetIndex, (boolean)false).content;
        this.updateContentTitle(content, context, infos);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        this.myView.getUi().setBouncing(content, true);
        dataGrid.resetFilters();
        ScriptingClientDataConsumer.consumerFor(dataGrid).setColumns(context, resultSetIndex, infos, firstRowNum);
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
        Content content;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(24);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        ScriptingClientDataConsumer.consumerFor(dataGrid).addRows(context, rows);
    }

    @NotNull
    private PlaceInGrid getPlaceInGrid() {
        PlaceInGrid placeInGrid = this.myPlace;
        if (placeInGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(25);
        }
        return placeInGrid;
    }

    private String getNextTitle(int resultSetIndex) {
        StringBuilder title = new StringBuilder(DEFAULT_TITLE).append(" ").append(this.myMajorRequestCount);
        if (this.myMinorRequestCount > 1 || resultSetIndex > 1) {
            title.append("-").append(this.myMinorRequestCount);
        }
        if (resultSetIndex > 1) {
            title.append("-").append(resultSetIndex);
        }
        return title.toString();
    }

    protected boolean isClientValid() {
        return true;
    }

    private static boolean isGeneratedName(@NotNull Content content) {
        GridInfo info;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(26);
        }
        return (info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null && content.getDisplayName().startsWith(info.originalTitle);
    }

    private void onRequestTakesTimeEDT(@NotNull DataRequest.Context context) {
        ConsoleDataRequest request;
        SqlTableType type;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(27);
        }
        SqlTableType sqlTableType = type = (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class)) != null ? (SqlTableType)ObjectUtils.tryCast((Object)request.resultType, SqlTableType.class) : null;
        if (type == null || !((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        ContentInfo info = this.getPreparedContentFor(context, 1, true);
        Content content = info.content;
        if (!info.isNew) {
            return;
        }
        this.updateContentTitle(content, context, null);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        List<DataConsumer.Column> columns = DbSqlUtil.createColumnsFromType(this.myProject, dialect, type, "", "", "");
        ScriptingClientDataConsumer.consumerFor(dataGrid).setColumns(context, 1, (DataConsumer.Column[])ContainerUtil.toArray(columns, DataConsumer.Column[]::new), 1);
    }

    private void onRequestStartedEDT(@NotNull DataRequest.Context context) {
        int queryIndex;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(28);
        }
        if (!((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        if (!(context.request instanceof DataRequest.QueryRequest)) {
            return;
        }
        int n = queryIndex = context.request instanceof ConsoleDataRequest ? ((ConsoleDataRequest)context.request).queryIndex : 0;
        if (queryIndex == 0) {
            ++this.myMajorRequestCount;
            this.myMinorRequestCount = 1;
        } else {
            ++this.myMinorRequestCount;
        }
    }

    private void onRequestFinishedEDT(@NotNull DataRequest.Context context) {
        Collection contents;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(29);
        }
        if ((contents = this.myPreparedContentMap.remove((Object)context.request)) == null) {
            return;
        }
        for (Content content : contents) {
            if (!content.isValid()) continue;
            DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
            DataGridUtil.setProgressMessage(dataGrid, null);
        }
    }

    @Nullable
    private Content getValidCurrentContent() {
        return ((VisibleSession)this.myClient.getSession()).isValid() && this.myCurrentContent != null && this.myCurrentContent.isValid() ? this.myCurrentContent : null;
    }

    @NotNull
    private ContentInfo getPreparedContentFor(@NotNull DataRequest.Context context, int resultSetIndex, boolean fake) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(30);
        }
        Content preparedContent = resultSetIndex == 1 ? (Content)ContainerUtil.getFirstItem((Collection)this.myPreparedContentMap.get((Object)context.request)) : null;
        ContentInfo contentInfo = preparedContent != null && preparedContent.isValid() ? new ContentInfo(preparedContent, false) : this.reuseOrCreateContent(context);
        Content content = contentInfo.content;
        this.myPreparedContentMap.putValue((Object)context.request, (Object)content);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        if (!fake || contentInfo.isNew) {
            String title = this.getNextTitle(resultSetIndex);
            content.setDisplayName(title);
            content.setDescription(StringUtil.escapeXmlEntities((String)context.getQuery()));
        }
        DataGridUtil.setProgressMessage(dataGrid, "");
        this.myView.show(true, false).onSuccess(__ -> DbUIUtil.invokeLaterIfNeeded(() -> {
            if (content.isValid()) {
                content.getManager().setSelectedContent(content, false, false);
            }
        }));
        ContentInfo contentInfo2 = contentInfo;
        if (contentInfo2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(31);
        }
        return contentInfo2;
    }

    @NotNull
    private ContentInfo reuseOrCreateContent(@NotNull DataRequest.Context context) {
        Content oldContent;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(32);
        }
        Content resultContent = (oldContent = this.findContentToReuse(context)) == null ? this.createNewContent() : oldContent;
        GridInfo gridInfo = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)resultContent);
        gridInfo.grid.getDataHookup().getPageModel().setPageSize(DbImplUtil.getPageSize());
        gridInfo.originalTitle = DEFAULT_TITLE;
        gridInfo.major = this.myMajorRequestCount;
        gridInfo.minor = this.myMinorRequestCount;
        ContentInfo contentInfo = new ContentInfo(resultContent, oldContent == null);
        if (contentInfo == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(33);
        }
        return contentInfo;
    }

    @Nullable
    private Content findContentToReuse(@NotNull @NotNull @NotNull DataRequest.Context context) {
        boolean newTab;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(34);
        }
        Content[] contents = this.myView.getUi().getContents();
        Content resultContent = null;
        boolean bl = newTab = !(context.request instanceof ConsoleDataRequest) || ((ConsoleDataRequest)context.request).newTab;
        if (!newTab) {
            GridInfo curInfo = null;
            for (Content content : contents) {
                DataGrid dataGrid = ScriptingClientDataConsumer.getDataGrid(content);
                if (dataGrid == null || content.isPinned() || !ScriptingClientDataConsumer.isGeneratedName(content)) continue;
                GridInfo info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content);
                if (info.major == this.myMajorRequestCount || curInfo != null && curInfo.major <= info.major && (curInfo.major != info.major || curInfo.minor <= info.minor)) continue;
                resultContent = content;
                curInfo = info;
            }
        }
        return resultContent;
    }

    @NotNull
    private Content createNewContent() {
        DataGrid dataGrid = this.createTableResultPanel();
        Content content = this.addContent(this.myView.getUi(), dataGrid);
        GRID_INFO_KEY.set((UserDataHolder)content, (Object)new GridInfo(dataGrid));
        Disposer.register((Disposable)content, (Disposable)dataGrid);
        Content content2 = content;
        if (content2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(35);
        }
        return content2;
    }

    private void updateContentTitle(@NotNull Content content, @NotNull DataRequest.Context context, @Nullable DataConsumer.Column[] infos) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(36);
        }
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(37);
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        if (context.request instanceof ConsoleDataRequest && this.myClient instanceof JdbcConsole) {
            String name2;
            ConsoleDataRequest request = (ConsoleDataRequest)context.request;
            JdbcConsole console = (JdbcConsole)this.myClient;
            if (!console.isValid()) {
                return;
            }
            DasTable table = DbSqlUtil.detectTable(this.myProject, ((JdbcConsole)this.myClient).getLanguage(), DbSqlUtil.getDbDataSource(this.myProject, console.getDataSource()), console.getSearchPath(), context.getQuery(), request, infos == null ? Collections.emptyList() : Arrays.asList(infos));
            ((DatabaseGridDataHookUp)ObjectUtils.assertNotNull((Object)DataGridUtil.getDatabaseHookUp(dataGrid))).setDatabaseTable(table);
            DatabaseEditorHelper.configureEditorHeader(this.myProject, this.myFileSupplier.get(), (JComponent)ObjectUtils.tryCast((Object)dataGrid.getTopComponent(), EditorHeaderComponent.class));
            if (content.isPinned()) {
                return;
            }
            if (request.title != null) {
                name2 = request.title;
            } else if (table != null) {
                name2 = QNameUtil.getQualifiedName((DasObject)table);
            } else if (request.resultType instanceof SqlTableType && ((SqlTableType)request.resultType).getColumnCount() == 1) {
                name2 = ((SqlTableType)request.resultType).getDisplayName();
                if (name2.startsWith("(") && name2.endsWith(")")) {
                    name2 = name2.substring(1, name2.length() - 1);
                }
            } else {
                name2 = null;
            }
            if (name2 != null) {
                String adjustedName = StringUtil.firstLast((String)name2, (int)40);
                content.setDisplayName(new UniqueNameGenerator(Arrays.asList(this.myView.getUi().getContents()), c2 -> StringUtil.notNullize((String)(content == c2 ? null : c2.getDisplayName()))).generateUniqueName(adjustedName, "", "", " ", ""));
                ((GridInfo)ScriptingClientDataConsumer.GRID_INFO_KEY.get((UserDataHolder)content)).originalTitle = content.getDisplayName();
            }
        }
    }

    protected DataGrid createTableResultPanel() {
        Disposable hookUpParent = Disposer.newDisposable();
        final GridDataHookUp hookUp = (GridDataHookUp)this.myHookUpFactory.fun((Object)hookUpParent);
        ActionGroup popupGroup = DataGridUtil.getGridPopupActions();
        ActionGroup columnHeaderPopupGroup = DataGridUtil.getGridColumnHeaderPopupActions();
        TableResultPanel grid = new TableResultPanel(this.myProject, hookUp, popupGroup, popupGroup, columnHeaderPopupGroup, null, DataGrid.Place.EDITOR, true){
            {
                super(project, dataHookUp, popupActions, gutterPopupActions, columnHeaderPopupActions, cellEditorFactoryProvider, place, useConsoleFonts);
                new DumbAwareAction("escape"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Project project;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((project = e.getProject()) != null) {
                            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                        }
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        e.getPresentation().setEnabledAndVisible(!this.isEditing());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.registerCustomShortcutSet(27, 0, (JComponent)((Object)this.getTable()));
            }

            @Override
            @NotNull
            public String getDisplayName() {
                JBLoadingPanel component = this.getComponent();
                Content content = ScriptingClientDataConsumer.this.myView.getUi().getContentManager().getContent((JComponent)component);
                String string = "grid:" + (content == null ? "" : content.getTabName());
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected Object getData(@NotNull @NonNls String dataId) {
                if (dataId == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return ScriptingClientDataConsumer.this.getOrCreateEditorWrapper(this);
                }
                return super.getData(dataId);
            }

            @Override
            public boolean isReady() {
                return super.isReady() && this.isHookUpValid(this.getDataHookup());
            }

            private boolean isHookUpValid(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookup) {
                if (hookup == null) {
                    3.$$$reportNull$$$0(2);
                }
                return !(hookUp instanceof ConsoleGridDataHookUp) || ((ConsoleGridDataHookUp)hookup).isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hookup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isHookUpValid";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Disposer.register((Disposable)grid, (Disposable)hookUpParent);
        DataGridUtil.setupProgressIndicatingAuditor(grid);
        return grid;
    }

    private FileEditor getOrCreateEditorWrapper(final DataGrid resultPanel) {
        JComponent dataGridComponent = resultPanel.getComponent();
        TableEditorBase editor = (TableEditorBase)((Object)UIUtil.getClientProperty((Object)dataGridComponent, FILE_EDITOR_KEY));
        if (editor == null) {
            editor = new TableEditorBase(this.myProject){

                @Override
                @NotNull
                public DataGrid getDataGrid() {
                    DataGrid dataGrid = resultPanel;
                    if (dataGrid == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return dataGrid;
                }

                @Override
                @NotNull
                public String getName() {
                    if (!((VisibleSession)ScriptingClientDataConsumer.this.myClient.getSession()).isValid()) {
                        String string = super.getName();
                        if (string == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    for (Content content : ScriptingClientDataConsumer.this.myView.getUi().getContents()) {
                        if (ScriptingClientDataConsumer.getDataGrid(content) != resultPanel) continue;
                        String string = content.getTabName();
                        if (string == null) {
                            4.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    String string = super.getName();
                    if (string == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/database/run/ScriptingClientDataConsumer$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataGrid";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            dataGridComponent.putClientProperty(FILE_EDITOR_KEY, (Object)editor);
            Disposer.register((Disposable)resultPanel, (Disposable)editor);
        }
        return editor;
    }

    private Content addContent(RunnerLayoutUi ui, DataGrid dataGrid) {
        String contentId = "ResultTab#" + this.myMajorRequestCount + "." + this.myMinorRequestCount;
        Content content = ui.createContent(contentId, (ComponentWithActions)new ComponentWithActions.Impl(dataGrid.getComponent()), "", DatabaseIcons.Table, dataGrid.getPreferredFocusedComponent());
        content.setCloseable(true);
        content.setPinnable(true);
        DataGridUtil.addGridHeaderComponent(dataGrid, this.myFileSupplier.get());
        ui.addContent(content, 0, this.getPlaceInGrid(), false);
        return content;
    }

    @NotNull
    private static DataGrid getNotNullDataGrid(@NotNull Content content) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(38);
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getDataGrid(content);
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(39);
        }
        return dataGrid;
    }

    @Nullable
    public static DataGrid getDataGrid(@NotNull Content content) {
        GridInfo info;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(40);
        }
        return (info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null ? info.grid : null;
    }

    @NotNull
    private static DataConsumer consumerFor(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(41);
        }
        DataBusGridDataHookUp.DataBusLoader dataBusLoader = ((DataBusGridDataHookUp)ObjectUtils.assertNotNull((Object)DataGridUtil.getDataBusHookUp(dataGrid))).getLoader();
        if (dataBusLoader == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(42);
        }
        return dataBusLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSupplier";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer";
                break;
            }
            case 14: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "install";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceInGrid";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedContentFor";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "reuseOrCreateContent";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewContent";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullDataGrid";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "consumerFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onRequestTakesTimeEDT";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStartedEDT";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinishedEDT";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedContentFor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reuseOrCreateContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findContentToReuse";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTitle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullDataGrid";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "consumerFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PreventingExtraResultsConsumer
    extends DataConsumer.Wrapper {
        PreventingExtraResultsConsumer(@NotNull DataConsumer dataConsumer) {
            if (dataConsumer == null) {
                PreventingExtraResultsConsumer.$$$reportNull$$$0(0);
            }
            super(dataConsumer);
        }

        @Override
        public boolean accepts(DataRequest.Owner owner) {
            return !(owner instanceof ConsoleGridDataHookUp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataConsumer", "com/intellij/database/run/ScriptingClientDataConsumer$PreventingExtraResultsConsumer", "<init>"));
        }
    }

    private class MyAuditor
    extends DataAuditor.Adapter {
        private final Set<DataRequest> myPendingRequests = ContainerUtil.newConcurrentSet();

        private MyAuditor() {
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(0);
            }
            super.requestStarted(context);
            if (ScriptingClientDataConsumer.this.myAlarm.isDisposed()) {
                return;
            }
            this.myPendingRequests.add(context.request);
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (ScriptingClientDataConsumer.this.myAlarm.isDisposed()) {
                    return;
                }
                ScriptingClientDataConsumer.this.onRequestStartedEDT(context);
                ScriptingClientDataConsumer.this.myAlarm.addRequest(() -> {
                    if (ScriptingClientDataConsumer.this.myAlarm.isDisposed() || !this.myPendingRequests.contains(context.request)) {
                        return;
                    }
                    ScriptingClientDataConsumer.this.onRequestTakesTimeEDT(context);
                }, 1000L, ModalityState.any());
            });
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index2) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(1);
            }
            this.myPendingRequests.remove(context.request);
            ScriptingClientDataConsumer.this.myAlarm.cancelAllRequests();
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(2);
            }
            this.myPendingRequests.remove(context.request);
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(3);
            }
            this.myPendingRequests.remove(context.request);
            ScriptingClientDataConsumer.this.myAlarm.cancelAllRequests();
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (!((VisibleSession)ScriptingClientDataConsumer.this.myClient.getSession()).isValid()) {
                    return;
                }
                ScriptingClientDataConsumer.this.onRequestFinishedEDT(context);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$MyAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchStarted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContentInfo {
        final Content content;
        final boolean isNew;

        ContentInfo(@NotNull Content content, boolean aNew) {
            if (content == null) {
                ContentInfo.$$$reportNull$$$0(0);
            }
            this.content = content;
            this.isNew = aNew;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/run/ScriptingClientDataConsumer$ContentInfo", "<init>"));
        }
    }

    private static class GridInfo {
        final DataGrid grid;
        String originalTitle;
        int major;
        int minor;

        GridInfo(DataGrid grid) {
            this.grid = grid;
        }
    }
}

