/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementUsage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.usages.Usage;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.NotNull;

public class DbCustomUsageSearcher
extends CustomUsageSearcher
implements UsageTypeProvider {
    private static final UsageType SCHEMA_USAGE_TYPE = new UsageType(DatabaseMessages.message((String)"usage.type.schema", (Object[])new Object[0]));

    public void processElementUsages(@NotNull PsiElement element2, @NotNull Processor<Usage> processor, @NotNull FindUsagesOptions options) {
        if (element2 == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(2);
        }
        if (element2 instanceof SqlFile) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)element2.getProject()).getDataSources()) {
                DatabaseSystem delegate = dataSource.getDelegate();
                if (!(delegate instanceof SqlDataSource) || !((SqlDataSource)delegate).getFiles().contains(virtualFile) || processor.process((Object)new DbElementUsage(dataSource.getName(), (DbElement)dataSource))) continue;
                return;
            }
            return;
        }
        DasObject target2 = DbUtil.getDasObject((Object)element2);
        if (target2 == null || !(element2 instanceof DbElement)) {
            return;
        }
        DbElement dbTarget = (DbElement)element2;
        if (DbSqlUtil.isSqlElement(dbTarget)) {
            return;
        }
        DbDataSource dataSource = dbTarget.getDataSource();
        ObjectKind targetKind = target2.getKind();
        if (targetKind == ObjectKind.NONE) {
            return;
        }
        JBTreeTraverser traverser2 = dataSource.getDelegate().getModel().traverser();
        for (DasObject o : traverser2) {
            DbElement oo;
            ProgressManager.checkCanceled();
            if (!DbCustomUsageSearcher.referencesTarget(o, target2, targetKind) || processor.process((Object)DbCustomUsageSearcher.createUsage(oo = DbImplUtil.findElement(dataSource, o), dbTarget))) continue;
            return;
        }
    }

    public UsageType getUsageType(PsiElement element2) {
        if (element2 instanceof DbElement) {
            return SCHEMA_USAGE_TYPE;
        }
        return null;
    }

    public static boolean referencesTarget(@NotNull DasObject candidate, @NotNull DasObject target2, @NotNull ObjectKind targetKind) {
        if (candidate == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(4);
        }
        if (targetKind == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(5);
        }
        if (targetKind == ObjectKind.TABLE) {
            DasTable refTable;
            if (candidate instanceof DasForeignKey && target2.equals(refTable = ((DasForeignKey)candidate).getRefTable())) {
                return true;
            }
        } else if (targetKind == ObjectKind.COLUMN) {
            if (candidate instanceof DasConstraint) {
                if (ContainerUtil.find((Iterable)((DasConstraint)candidate).getColumnsRef().resolveObjects(), (Object)target2) != null) {
                    return true;
                }
                if (candidate instanceof DasForeignKey && ContainerUtil.find((Iterable)((DasForeignKey)candidate).getRefColumns().resolveObjects(), (Object)target2) != null) {
                    return true;
                }
            } else if (candidate instanceof DasIndex && ContainerUtil.find((Iterable)((DasIndex)candidate).getColumnsRef().resolveObjects(), (Object)target2) != null) {
                return true;
            }
        } else if (candidate instanceof DasSynonym && ((DasSynonym)candidate).resolveTarget() == target2) {
            return true;
        }
        return candidate instanceof BasicElement && target2 instanceof BasicElement && Iterables.contains(((BasicElement)candidate).getPredecessors(), (Object)target2);
    }

    private static Usage createUsage(@NotNull DbElement o, @NotNull DbElement resolveTo) {
        if (o == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(6);
        }
        if (resolveTo == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(7);
        }
        return DbElementUsage.create(o, resolveTo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementUsages";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "referencesTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

