/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbElementSelectInProvider
implements SelectInDatabaseView.Extension {
    @Override
    @Nullable
    public PsiElement findTarget(@NotNull SelectInContext context) {
        DbDataSource target2;
        VirtualFile file;
        if (context == null) {
            DbElementSelectInProvider.$$$reportNull$$$0(0);
        }
        if (DbImplUtil.isDatabaseVirtualFile(file = context.getVirtualFile())) {
            DbElement dbElement = DbImplUtil.findElement(context.getProject(), file);
            Object selector = context.getSelectorInFile();
            DataGridPomTarget.Column column2 = selector instanceof PsiElement ? DataGridPomTarget.unwrapColumn((PsiElement)selector) : null;
            DataConsumer.Column dataColumn = column2 == null ? null : column2.getColumn();
            DbColumn columnElement = dataColumn == null ? null : (DbColumn)DasUtil.findChild((DasObject)dbElement, DbColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)dataColumn.name);
            target2 = (DbElement)ObjectUtils.chooseNotNull(columnElement, (Object)dbElement);
        } else if (DbConsoleRootType.isConsoleFile(file)) {
            target2 = DbConsoleRootType.getDataSource(context.getProject(), file);
        } else {
            if (file.getFileType() instanceof DbStorageFileType) {
                DbDataSource existing = DbImplUtil.findDataSourceByFile(context.getProject(), file);
                return existing != null ? existing : PsiUtilCore.NULL_PSI_ELEMENT;
            }
            Project project = context.getProject();
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
            target2 = console != null ? DbPsiFacade.getInstance((Project)project).findDataSource(console.getDataSource().getUniqueId()) : null;
        }
        return target2;
    }

    @Override
    @Nullable
    public PsiElement tryCreateTarget(@NotNull SelectInContext context) {
        if (context == null) {
            DbElementSelectInProvider.$$$reportNull$$$0(1);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)context.getProject());
        List<VirtualFile> files = Collections.singletonList(context.getVirtualFile());
        for (DataSourceManager manager : DataSourceManager.getManagers((Project)context.getProject())) {
            for (DasDataSource system : manager.createDataSourceByFiles(files)) {
                DbDataSource dataSource = facade.findDataSource(system.getUniqueId());
                if (dataSource == null) continue;
                return dataSource;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/intellij/database/editor/DbElementSelectInProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCreateTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

