/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicSequence;
import org.jetbrains.annotations.Nullable;

public interface OraMixinTableColumn
extends BasicModTableColumn {
    @Override
    @Nullable
    public OraTable getTable();

    @Override
    @Nullable
    default public SequenceIdentity getSequenceIdentity() {
        OraTable table = this.getTable();
        if (table == null) {
            return null;
        }
        OraSchema schema = table.getSchema();
        if (schema == null) {
            return null;
        }
        long tableId = table.getObjectId();
        if (tableId <= 0L) {
            return null;
        }
        String sequenceName = "ISEQ$$_" + tableId;
        BasicSequence sequence = (BasicSequence)schema.getSequences().get(sequenceName);
        if (sequence == null) {
            return null;
        }
        return sequence.getSequenceIdentity();
    }
}

