/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.dataSource.connection.statements.TypedOutParameter;
import com.intellij.database.dialects.oracle.debugger.ApiResult;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.CallParams;
import com.intellij.database.dialects.oracle.debugger.DebugCommand;
import com.intellij.database.dialects.oracle.debugger.OracleBaseSession;
import com.intellij.database.dialects.oracle.debugger.OracleConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OracleDebugExecutionResult;
import com.intellij.database.dialects.oracle.debugger.OracleDebuggerEnumsKt;
import com.intellij.database.dialects.oracle.debugger.OracleDebuggingSession;
import com.intellij.database.dialects.oracle.debugger.OracleDebuggingSession$WhenMappings;
import com.intellij.database.dialects.oracle.debugger.OracleExecutingSession;
import com.intellij.database.dialects.oracle.debugger.OracleNamespace;
import com.intellij.database.dialects.oracle.debugger.OraclePosition;
import com.intellij.database.dialects.oracle.debugger.OracleProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OracleScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OracleStringArrayOutParameter;
import com.intellij.database.dialects.oracle.debugger.OracleUnknownPosition;
import com.intellij.database.dialects.oracle.debugger.PauseCommand;
import com.intellij.database.dialects.oracle.debugger.PauseReason;
import com.intellij.database.dialects.oracle.debugger.ProcessState;
import com.intellij.database.dialects.oracle.debugger.ResumeDebugCommand;
import com.intellij.database.dialects.oracle.debugger.StopCommand;
import com.intellij.database.dialects.oracle.debugger.TransferHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.StringKt;
import java.rmi.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\u0018\u0000 r2\u00020\u0001:\u0001rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010H\u001a\u00020\u0013H\u0002J\b\u0010I\u001a\u00020\u0013H\u0016J\b\u0010J\u001a\u00020\u0013H\u0002J\b\u0010K\u001a\u00020\u0013H\u0002J\u0010\u0010L\u001a\u00020\u00132\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020\u0013H\u0002J\u0010\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u0012H\u0002J\u0016\u0010S\u001a\u00020\u00132\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0002J!\u0010U\u001a\u00020\u00132\u0006\u0010V\u001a\u00020W2\n\b\u0002\u0010X\u001a\u0004\u0018\u00010NH\u0002\u00a2\u0006\u0002\u0010YJ^\u0010Z\u001a\u00020\u00132\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020_2\u0006\u0010a\u001a\u00020_2\u0006\u0010b\u001a\u00020N2\b\u0010c\u001a\u0004\u0018\u00010\u00122\b\u0010d\u001a\u0004\u0018\u00010\u00122\b\u0010e\u001a\u0004\u0018\u00010\u00122\u0006\u0010f\u001a\u00020\bH\u0002J\b\u0010g\u001a\u00020\u0013H\u0016J\u000e\u0010h\u001a\u00020\u00132\u0006\u0010i\u001a\u00020\u000fJ,\u0010j\u001a\u00020\u00132\u0006\u0010b\u001a\u00020N2\b\u0010c\u001a\u0004\u0018\u00010\u00122\b\u0010d\u001a\u0004\u0018\u00010\u00122\u0006\u0010^\u001a\u00020_H\u0002J,\u0010k\u001a\u00020\u001b2\u0006\u0010b\u001a\u00020N2\b\u0010c\u001a\u0004\u0018\u00010\u00122\b\u0010d\u001a\u0004\u0018\u00010\u00122\u0006\u0010^\u001a\u00020_H\u0002J\u0006\u0010l\u001a\u00020\u0013J\u0006\u0010m\u001a\u00020\u0013J\b\u0010n\u001a\u00020\u0013H\u0002J\b\u0010o\u001a\u00020\u0013H\u0002J\b\u0010p\u001a\u00020\u0013H\u0002J\u0018\u0010q\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017RP\u0010\u0018\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00130\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$RJ\u0010%\u001a2\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00130\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010$R\u001a\u0010*\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010\fR\u000e\u0010-\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u0002012\u0006\u00100\u001a\u000201@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001e\u00106\u001a\u0002052\u0006\u00100\u001a\u000205@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R$\u0010 \u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001f0BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0014\u0010E\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006s"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession;", "Lcom/intellij/database/dialects/oracle/debugger/OracleBaseSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "target", "Lcom/intellij/database/dialects/oracle/debugger/OracleExecutingSession;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/OracleExecutingSession;)V", "attached", "", "getAttached", "()Z", "setAttached", "(Z)V", "commandHolder", "Lcom/intellij/database/dialects/oracle/debugger/TransferHolder;", "Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;", "dbmsOutputConsumer", "Lkotlin/Function1;", "", "", "getDbmsOutputConsumer", "()Lkotlin/jvm/functions/Function1;", "setDbmsOutputConsumer", "(Lkotlin/jvm/functions/Function1;)V", "onEventInfo", "Lkotlin/Function2;", "", "Lcom/intellij/database/dialects/oracle/debugger/OraclePosition;", "Lkotlin/ParameterName;", "name", "stack", "Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "state", "getOnEventInfo$intellij_database_dialects_oracle", "()Lkotlin/jvm/functions/Function2;", "setOnEventInfo$intellij_database_dialects_oracle", "(Lkotlin/jvm/functions/Function2;)V", "onStateTransition", "oldState", "newState", "getOnStateTransition$intellij_database_dialects_oracle", "setOnStateTransition$intellij_database_dialects_oracle", "processIsActive", "getProcessIsActive", "setProcessIsActive", "processIsRunning", "processIsTerminated", "processIsWaiting", "<set-?>", "Lcom/intellij/database/dialects/oracle/debugger/PauseReason;", "reason", "getReason", "()Lcom/intellij/database/dialects/oracle/debugger/PauseReason;", "Lcom/intellij/database/dialects/oracle/debugger/ApiResult;", "result", "getResult", "()Lcom/intellij/database/dialects/oracle/debugger/ApiResult;", "getStack", "()Ljava/util/List;", "setStack", "(Ljava/util/List;)V", "getState", "()Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "setState", "(Lcom/intellij/database/dialects/oracle/debugger/ProcessState;)V", "stateHolder", "Ljava/util/concurrent/atomic/AtomicReference;", "getTarget", "()Lcom/intellij/database/dialects/oracle/debugger/OracleExecutingSession;", "tracePrefix", "getTracePrefix", "()Ljava/lang/String;", "attachToTargetSession", "close", "connectionBroken", "detachFromTargetSession", "doContinue", "breakFlags", "", "doSynchronize", "executeAndFetchResult", "Lcom/intellij/database/dialects/oracle/debugger/OracleDebugExecutionResult;", "block", "handleStack", "listing", "handleSyncOrContinue", "proc", "Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$SyncLikeProc;", "breaksFlags", "(Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$SyncLikeProc;Ljava/lang/Short;)V", "handleSyncResult", "resultCode", "", "reasonCode", "lineNr", "", "breakpoint", "stackDepth", "namespaceCode", "programSchema", "programName", "entryPointName", "terminated", "initRemote", "issueCommand", "command", "makeDefaultStack", "makeFrame", "performFinishLoop", "performMainLoop", "resetResult", "retrieveDbmsOutput", "retrieveStack", "stateChanged", "Companion", "intellij.database.dialects.oracle"})
public final class OracleDebuggingSession
extends OracleBaseSession {
    @NotNull
    private Function1<? super String, Unit> dbmsOutputConsumer;
    private boolean attached;
    private boolean processIsActive;
    private boolean processIsRunning;
    private boolean processIsWaiting;
    private boolean processIsTerminated;
    @NotNull
    private List<? extends OraclePosition> stack;
    @NotNull
    private PauseReason reason;
    @NotNull
    private ApiResult result;
    private final AtomicReference<ProcessState> stateHolder;
    private final TransferHolder<DebugCommand> commandHolder;
    @NotNull
    private Function2<? super ProcessState, ? super ProcessState, Unit> onStateTransition;
    @NotNull
    private Function2<? super List<? extends OraclePosition>, ? super ProcessState, Unit> onEventInfo;
    @NotNull
    private final OracleExecutingSession target;
    private static final String retrieveDbmsOutputBlock;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final Function1<String, Unit> getDbmsOutputConsumer() {
        return this.dbmsOutputConsumer;
    }

    public final void setDbmsOutputConsumer(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.dbmsOutputConsumer = function1;
    }

    public final boolean getAttached() {
        return this.attached;
    }

    public final void setAttached(boolean bl) {
        this.attached = bl;
    }

    public final boolean getProcessIsActive() {
        return this.processIsActive;
    }

    public final void setProcessIsActive(boolean bl) {
        this.processIsActive = bl;
    }

    @NotNull
    public final List<OraclePosition> getStack() {
        return this.stack;
    }

    public final void setStack(@NotNull List<? extends OraclePosition> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.stack = list;
    }

    @NotNull
    public final PauseReason getReason() {
        return this.reason;
    }

    @NotNull
    public final ApiResult getResult() {
        return this.result;
    }

    @NotNull
    public final ProcessState getState() {
        ProcessState processState = this.stateHolder.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)processState), (String)"stateHolder.get()");
        return processState;
    }

    private final void setState(ProcessState newState) {
        ProcessState oldState = this.stateHolder.getAndSet(newState);
        if (oldState != newState) {
            ProcessState processState = oldState;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)processState), (String)"oldState");
            this.stateChanged(processState, newState);
        }
    }

    @NotNull
    public final Function2<ProcessState, ProcessState, Unit> getOnStateTransition$intellij_database_dialects_oracle() {
        return this.onStateTransition;
    }

    public final void setOnStateTransition$intellij_database_dialects_oracle(@NotNull Function2<? super ProcessState, ? super ProcessState, Unit> function2) {
        Intrinsics.checkParameterIsNotNull(function2, (String)"<set-?>");
        this.onStateTransition = function2;
    }

    @NotNull
    public final Function2<List<? extends OraclePosition>, ProcessState, Unit> getOnEventInfo$intellij_database_dialects_oracle() {
        return this.onEventInfo;
    }

    public final void setOnEventInfo$intellij_database_dialects_oracle(@NotNull Function2<? super List<? extends OraclePosition>, ? super ProcessState, Unit> function2) {
        Intrinsics.checkParameterIsNotNull(function2, (String)"<set-?>");
        this.onEventInfo = function2;
    }

    @Override
    public void initRemote() {
        super.initRemote();
        this.trace("The session id: " + this.getSessionId());
        boolean bl = this.getSessionId() != 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-OracleDebuggingSession$initRemote$32 = false;
            String $i$a$-assert-OracleDebuggingSession$initRemote$32 = "The debugging session Id is zero";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OracleDebuggingSession$initRemote$32));
        }
        bl = this.target.getSessionId() != 0;
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The target session Id is zero";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.getSessionId() == this.target.getSessionId()) {
            String errorMessage = "The target and debug sessions are the same one. Impossible to debug.";
            this.getLog().error(errorMessage);
            throw (Throwable)new IllegalStateException(errorMessage);
        }
        this.attachToTargetSession();
    }

    private final void attachToTargetSession() {
        this.resetResult();
        String string = this.target.getDebugId();
        if (string == null) {
            throw (Throwable)new IllegalStateException("Cannot attach to the session that is not debuggable yet.");
        }
        String debugId = string;
        try {
            this.call(Companion.AttachProc.INSTANCE.getText(), debugId);
            this.trace("Attached to the target session");
            this.attached = true;
        }
        catch (Exception e) {
            this.attached = false;
            this.trace("Failed to attach: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            throw (Throwable)e;
        }
    }

    private final void detachFromTargetSession() {
        this.resetResult();
        if (this.attached) {
            this.callProcedure("dbms_debug.detach_session", new Object[0]);
            this.trace("Detached from the target session");
            this.attached = false;
        }
    }

    public final void issueCommand(@NotNull DebugCommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.commandHolder.offer(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performMainLoop() {
        this.processIsTerminated = false;
        this.trace("Entering the Main Loop");
        this.setState(ProcessState.STATE_STARTING_UP);
        int iteration = 0;
        try {
            this.doSynchronize();
            block13: while (!this.processIsTerminated && this.getState() != ProcessState.STATE_BROKEN) {
                ++iteration;
                try {
                    DebugCommand debugCommand;
                    DebugCommand command = this.commandHolder.take(this.getState() == ProcessState.STATE_RELAXING ? 1000L : 0L);
                    if (command != null) {
                        this.trace("Took command " + command);
                    }
                    if ((debugCommand = command) == null) {
                        switch (OracleDebuggingSession$WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
                            case 1: {
                                int n = 2;
                                int n2 = 32;
                                OracleDebuggingSession oracleDebuggingSession = this;
                                boolean bl = false;
                                short s = (short)(n | n2);
                                n = s;
                                n2 = 12;
                                bl = false;
                                s = (short)(n | n2);
                                oracleDebuggingSession.doContinue(s);
                                continue block13;
                            }
                            case 2: {
                                this.doSynchronize();
                                continue block13;
                            }
                            case 3: {
                                continue block13;
                            }
                            case 4: {
                                this.doContinue((short)0);
                                continue block13;
                            }
                        }
                        this.doContinue((short)2);
                        continue;
                    }
                    if (debugCommand instanceof ResumeDebugCommand) {
                        this.doContinue(((ResumeDebugCommand)command).getBreakFlags());
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)debugCommand, (Object)PauseCommand.INSTANCE)) continue;
                    this.doContinue((short)2);
                }
                catch (InterruptedException i2) {
                    this.trace("InterruptedException \u2014\u00a0attempting to stop the executing process");
                    this.commandHolder.offer(StopCommand.INSTANCE);
                }
                catch (SQLException e) {
                    int errorCode = e.getErrorCode();
                    this.trace("Error " + errorCode + " state " + e.getSQLState() + ": " + e.getMessage());
                    if (errorCode != 17008) continue;
                    this.connectionBroken();
                }
                catch (Throwable e) {
                    this.trace("Exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        finally {
            this.trace("Leaving the Main Loop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performFinishLoop() {
        this.processIsTerminated = false;
        this.trace("Entering the Finishing Loop");
        this.setState(ProcessState.STATE_FINISHING);
        int iteration = 0;
        try {
            this.doSynchronize();
            while (!this.processIsTerminated) {
                ++iteration;
                try {
                    this.doContinue((short)0);
                }
                catch (Throwable e) {
                    this.trace("Exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        finally {
            this.trace("Leaving the Finishing Loop");
        }
    }

    private final void doSynchronize() {
        this.resetResult();
        this.trace("doSynchronize");
        OracleDebuggingSession.handleSyncOrContinue$default(this, Companion.SynchronizeProc.INSTANCE, null, 2, null);
    }

    private final void doContinue(short breakFlags) {
        this.resetResult();
        this.trace("doContinue with flags = " + breakFlags);
        this.handleSyncOrContinue(Companion.ContinueProc.INSTANCE, breakFlags);
    }

    private final void handleSyncOrContinue(Companion.SyncLikeProc proc, Short breaksFlags) {
        Object[] objectArray;
        CallableStatementBasis basis = new CallableStatementBasis(proc.getText(), Integer.MAX_VALUE, proc.getOutParams());
        if (breaksFlags == null) {
            objectArray = new Number[]{};
        } else {
            Number[] numberArray = new Number[1];
            objectArray = numberArray;
            numberArray[0] = breaksFlags;
        }
        Object[] params = objectArray;
        CallableStatementData csd = new CallableStatementData(basis, OracleConnectionHelperKt.decorateInParameters(params));
        CallableSmartStatement executor = SmartStatements.Companion.poweredBy(this.getConnection()).call();
        this.trace("\texecuting\u2026");
        try {
            executor.noisy().execute(csd, (ExecutionMode)StandardExecutionMode.GENERIC, (Function1)new Function1<ResultsProducer, Unit>(this, proc){
                final /* synthetic */ OracleDebuggingSession this$0;
                final /* synthetic */ Companion.SyncLikeProc $proc;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    byte resultCode = (byte)((Number)producer.getParameterValue((OutParameter)this.$proc.getResult())).intValue();
                    byte reasonCode = (byte)((Number)producer.getParameterValue((OutParameter)this.$proc.getReason())).intValue();
                    int lineNr = ((Number)producer.getParameterValue((OutParameter)this.$proc.getLineNr())).intValue();
                    int breakpoint = ((Number)producer.getParameterValue((OutParameter)this.$proc.getBreakpoint())).intValue();
                    int stackDepth = ((Number)producer.getParameterValue((OutParameter)this.$proc.getStackDepth())).intValue();
                    short namespaceCode = (short)((Number)producer.getParameterValue((OutParameter)this.$proc.getNamespaceCode())).intValue();
                    String programSchema = (String)producer.getParameterValue((OutParameter)this.$proc.getProgramSchema());
                    String programName = (String)producer.getParameterValue((OutParameter)this.$proc.getProgramName());
                    String entryPointName = (String)producer.getParameterValue((OutParameter)this.$proc.getEntryPointName());
                    boolean terminated = (Boolean)producer.getParameterValue((OutParameter)this.$proc.getTerminated());
                    OracleDebuggingSession.access$handleSyncResult(this.this$0, resultCode, reasonCode, lineNr, breakpoint, stackDepth, namespaceCode, programSchema, programName, entryPointName, terminated);
                }
                {
                    this.this$0 = oracleDebuggingSession;
                    this.$proc = syncLikeProc;
                    super(1);
                }
            });
        }
        catch (SQLException e) {
            this.trace("error code " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        catch (ConnectException e) {
            this.trace("connect exception: " + e.getMessage());
            this.setState(ProcessState.STATE_BROKEN);
        }
        catch (Exception e) {
            this.trace("exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    static /* synthetic */ void handleSyncOrContinue$default(OracleDebuggingSession oracleDebuggingSession, Companion.SyncLikeProc syncLikeProc, Short s, int n, Object object) {
        if ((n & 2) != 0) {
            s = null;
        }
        oracleDebuggingSession.handleSyncOrContinue(syncLikeProc, s);
    }

    private final void handleSyncResult(byte resultCode, byte reasonCode, int lineNr, int breakpoint, int stackDepth, short namespaceCode, String programSchema, String programName, String entryPointName, boolean terminated) {
        ApiResult apiResult;
        this.trace("\thandling\u2026");
        PauseReason pauseReason = OracleDebuggerEnumsKt.getPAUSE_REASONS().get(reasonCode);
        if (pauseReason == null) {
            pauseReason = this.reason = PauseReason.REASON_UNEXPECTED;
        }
        if ((apiResult = OracleDebuggerEnumsKt.getAPI_RESULTS().get(resultCode)) == null) {
            apiResult = ApiResult.RESULT_UNEXPECTED;
        }
        this.result = apiResult;
        OracleNamespace namespace = OracleNamespace.Companion.byCode(namespaceCode);
        switch (OracleDebuggingSession$WhenMappings.$EnumSwitchMapping$1[this.result.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                return;
            }
            default: {
                return;
            }
        }
        this.processIsTerminated = terminated;
        if (this.processIsTerminated) {
            this.trace("Terminated");
            this.processIsActive = false;
            this.processIsRunning = false;
            this.processIsWaiting = false;
            this.stack = CollectionsKt.emptyList();
        } else {
            this.processIsActive = true;
            this.processIsRunning = this.reason == PauseReason.REASON_NONE;
            boolean bl = this.processIsWaiting = !this.processIsRunning;
        }
        this.setState(this.processIsTerminated ? (this.getState() == ProcessState.STATE_FINISHING || this.getState() == ProcessState.STATE_FINISHED ? ProcessState.STATE_FINISHED : ProcessState.STATE_COMPLETED) : (this.reason == PauseReason.REASON_STARTED && this.getState() == ProcessState.STATE_STARTING_UP ? ProcessState.STATE_STARTING_UP : (this.reason == PauseReason.REASON_RETURN && programName == null && programSchema == null ? ProcessState.STATE_COMPLETING : (this.reason == PauseReason.REASON_EXIT_KNL ? ProcessState.STATE_COMPLETING : (this.processIsRunning ? ProcessState.STATE_RUNNING : (this.processIsWaiting ? ProcessState.STATE_RELAXING : (this.processIsTerminated ? ProcessState.STATE_COMPLETED : this.getState())))))));
        if (stackDepth >= 2) {
            this.retrieveStack();
        } else {
            this.makeDefaultStack(namespaceCode, programSchema, programName, lineNr);
        }
        this.onEventInfo.invoke(this.stack, (Object)this.getState());
        if (this.processIsWaiting) {
            this.retrieveDbmsOutput();
        }
    }

    private final void retrieveStack() {
        try {
            Object[] objectArray = new Object[]{};
            Function1 function1 = retrieveStack.listing.1.INSTANCE;
            List listing2 = (List)OracleConnectionHelperKt.call(this.getConnection(), (CallDefinition)Companion.PrintBacktraceProc.INSTANCE, objectArray, function1);
            this.handleStack(listing2);
        }
        catch (SQLException e) {
            this.trace("Error during obtaining stack trace: error " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.trace("Exception during obtaining stack trace: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private final void handleStack(List<String> listing2) {
        ArrayList newStack = new ArrayList(listing2.size());
        for (String frameLine : CollectionsKt.asReversed(listing2)) {
            List frameElements = StringsKt.split$default((CharSequence)frameLine, (char[])new char[]{'\u0001'}, (boolean)false, (int)0, (int)6, null);
            OraclePosition frame = null;
            if (frameElements.size() >= 4) {
                Short s = StringsKt.toShortOrNull((String)((String)frameElements.get(0)));
                short namespaceCode = s != null ? s : OracleNamespace.NS_NONE.code;
                String programSchema = StringKt.nullize$default((String)((String)frameElements.get(1)), (boolean)false, (int)1, null);
                String programName = StringKt.nullize$default((String)((String)frameElements.get(2)), (boolean)false, (int)1, null);
                Integer n = StringsKt.toIntOrNull((String)((String)frameElements.get(3)));
                int lineNr = n != null ? n : 0;
                frame = this.makeFrame(namespaceCode, programSchema, programName, lineNr);
            } else {
                frame = new OracleUnknownPosition(OracleNamespace.NS_NONE, null, frameLine, 0);
            }
            Collection collection = newStack;
            boolean bl = false;
            collection.add(frame);
        }
        this.stack = newStack;
    }

    private final void makeDefaultStack(short namespaceCode, String programSchema, String programName, int lineNr) {
        OraclePosition singleFrame = this.makeFrame(namespaceCode, programSchema, programName, lineNr);
        this.stack = CollectionsKt.listOf((Object)singleFrame);
    }

    private final OraclePosition makeFrame(short namespaceCode, String programSchema, String programName, int lineNr) {
        OracleNamespace namespace = OracleNamespace.Companion.byCode(namespaceCode);
        return programSchema != null && programName != null ? (OraclePosition)new OracleProgramPosition(namespace, programSchema, programName, lineNr) : (namespace == OracleNamespace.NS_CURSOR && lineNr > 0 ? (OraclePosition)new OracleScriptPosition(lineNr) : (OraclePosition)new OracleUnknownPosition(namespace, programSchema, programName, lineNr));
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveDbmsOutput() {
        try {
            OracleDebugExecutionResult r = this.executeAndFetchResult(retrieveDbmsOutputBlock);
            Iterable iterable = r.getResult();
            boolean bl = false;
            if (!iterable.isEmpty()) {
                void $this$forEach$iv;
                iterable = r.getResult();
                Function1<? super String, Unit> action$iv = this.dbmsOutputConsumer;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    action$iv.invoke(element$iv);
                }
            }
            if (r.getError() != null) {
                this.trace("Failed to fetch dbms_output lines: " + r.getError());
            }
        }
        catch (SQLException e) {
            this.trace("Error during dbms_output lines fetching: error " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.trace("Exception during dbms_output lines fetching: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private final OracleDebugExecutionResult executeAndFetchResult(String block) {
        Pair p2 = OracleConnectionHelperKt.call(this.getConnection(), "{ call dbms_debug.execute(?, -1, 1, ?, ?) }", new OracleStringArrayOutParameter(2, "SYS.DBMS_DEBUG_VC2COLL"), new StringOutParam(3, 4000, null, 4, null), block);
        return new OracleDebugExecutionResult((List)p2.getFirst(), (String)p2.getSecond());
    }

    private final void connectionBroken() {
        this.setState(ProcessState.STATE_BROKEN);
        this.processIsActive = false;
        this.processIsRunning = false;
        this.processIsWaiting = false;
        this.processIsTerminated = true;
    }

    private final void resetResult() {
        this.reason = PauseReason.REASON_NONE;
        this.result = ApiResult.RESULT_OK;
    }

    private final void stateChanged(ProcessState oldState, ProcessState newState) {
        this.trace("state transition: " + (Object)((Object)oldState) + " -> " + (Object)((Object)newState));
        this.onStateTransition.invoke((Object)oldState, (Object)newState);
    }

    @Override
    public void close() {
        this.silently((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ OracleDebuggingSession this$0;

            public final void invoke() {
                OracleDebuggingSession.access$detachFromTargetSession(this.this$0);
            }
            {
                this.this$0 = oracleDebuggingSession;
                super(0);
            }
        }));
        super.close();
    }

    @Override
    @NotNull
    protected String getTracePrefix() {
        return "Debugging";
    }

    @NotNull
    public final OracleExecutingSession getTarget() {
        return this.target;
    }

    public OracleDebuggingSession(@NotNull DatabaseConnection connection2, @NotNull OracleExecutingSession target2) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        super(connection2);
        this.target = target2;
        this.dbmsOutputConsumer = (Function1)new Function1<String, Unit>(this.getLog()){

            public final void invoke(String p1) {
                ((Logger)this.receiver).info(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Logger.class);
            }

            public final String getName() {
                return "info";
            }

            public final String getSignature() {
                return "info(Ljava/lang/String;)V";
            }
        };
        this.stack = CollectionsKt.emptyList();
        this.reason = PauseReason.REASON_NONE;
        this.result = ApiResult.RESULT_OK;
        this.stateHolder = new AtomicReference<ProcessState>(ProcessState.STATE_ASLEEP);
        this.commandHolder = new TransferHolder();
        this.onStateTransition = onStateTransition.1.INSTANCE;
        this.onEventInfo = onEventInfo.1.INSTANCE;
    }

    static {
        Companion = new Companion(null);
        retrieveDbmsOutputBlock = "declare                                                      \n    lines sys.dbmsoutput_linesarray;                          \n    pp    sys.dbms_debug_vc2coll := sys.dbms_debug_vc2coll(); \n    cnt   integer := 100;                                     \nbegin                                                         \n    dbms_output.get_lines(lines, cnt);                        \n    pp.extend(cnt);                                           \n    for i in 1 .. cnt                                         \n        loop                                                  \n            pp(i) := lines(i);                                \n        end loop;                                             \n    :1 := pp;                                               \nend;                                                          ";
    }

    public static final /* synthetic */ void access$handleSyncResult(OracleDebuggingSession $this, byte resultCode, byte reasonCode, int lineNr, int breakpoint, int stackDepth, short namespaceCode, String programSchema, String programName, String entryPointName, boolean terminated) {
        $this.handleSyncResult(resultCode, reasonCode, lineNr, breakpoint, stackDepth, namespaceCode, programSchema, programName, entryPointName, terminated);
    }

    public static final /* synthetic */ void access$detachFromTargetSession(OracleDebuggingSession $this) {
        $this.detachFromTargetSession();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0005\u0005\u0006\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion;", "", "()V", "retrieveDbmsOutputBlock", "", "AttachProc", "ContinueProc", "PrintBacktraceProc", "SyncLikeProc", "SynchronizeProc", "intellij.database.dialects.oracle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$AttachProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "()V", "intellij.database.dialects.oracle"})
        private static final class AttachProc
        extends CallDefinition {
            public static final AttachProc INSTANCE;

            private AttachProc() {
                super("declare\n    dummy_value binary_integer;\nbegin\n    dbms_debug.attach_session(?);\n    dummy_value := dbms_debug.set_timeout(1);\n    dbms_debug.set_timeout_behaviour(dbms_debug.continue_on_timeout);\nend;    ");
            }

            static {
                AttachProc attachProc;
                INSTANCE = attachProc = new AttachProc();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$SynchronizeProc;", "Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$SyncLikeProc;", "()V", "intellij.database.dialects.oracle"})
        private static final class SynchronizeProc
        extends SyncLikeProc {
            public static final SynchronizeProc INSTANCE;

            private SynchronizeProc() {
                super("declare\n    ri dbms_debug.runtime_info;\nbegin\n    ? := dbms_debug.synchronize(ri, 14);\n    ? := ri.Reason;\n    ? := ri.Line#;\n    ? := ri.Breakpoint;\n    ? := ri.StackDepth;\n    ? := ri.program.Namespace;\n    ? := ri.program.Owner;\n    ? := ri.program.Name;\n    ? := ri.program.EntryPointName;\n    ? := ri.Terminated;\nend;", 0);
            }

            static {
                SynchronizeProc synchronizeProc;
                INSTANCE = synchronizeProc = new SynchronizeProc();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$ContinueProc;", "Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$SyncLikeProc;", "()V", "intellij.database.dialects.oracle"})
        private static final class ContinueProc
        extends SyncLikeProc {
            public static final ContinueProc INSTANCE;

            private ContinueProc() {
                super("declare\n    breaks binary_integer := ?;\n    ri     dbms_debug.runtime_info;\nbegin\n    ? := dbms_debug.continue(ri, breaks, 14);\n    ? := ri.Reason;\n    ? := ri.Line#;\n    ? := ri.Breakpoint;\n    ? := ri.StackDepth;\n    ? := ri.program.Namespace;\n    ? := ri.program.Owner;\n    ? := ri.program.Name;\n    ? := ri.program.EntryPointName;\n    ? := ri.Terminated;\nend;", 1);
            }

            static {
                ContinueProc continueProc;
                INSTANCE = continueProc = new ContinueProc();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0019\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$SyncLikeProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "text", "", "skip", "", "(Ljava/lang/String;I)V", "breakpoint", "Lcom/intellij/database/dataSource/connection/statements/TypedOutParameter;", "getBreakpoint", "()Lcom/intellij/database/dataSource/connection/statements/TypedOutParameter;", "entryPointName", "getEntryPointName", "lineNr", "getLineNr", "namespaceCode", "getNamespaceCode", "programName", "getProgramName", "programSchema", "getProgramSchema", "reason", "getReason", "result", "getResult", "stackDepth", "getStackDepth", "terminated", "", "getTerminated", "intellij.database.dialects.oracle"})
        private static abstract class SyncLikeProc
        extends CallDefinition {
            @NotNull
            private final TypedOutParameter<Integer> result;
            @NotNull
            private final TypedOutParameter<Integer> reason;
            @NotNull
            private final TypedOutParameter<Integer> lineNr;
            @NotNull
            private final TypedOutParameter<Integer> breakpoint;
            @NotNull
            private final TypedOutParameter<Integer> stackDepth;
            @NotNull
            private final TypedOutParameter<Integer> namespaceCode;
            @NotNull
            private final TypedOutParameter<String> programSchema;
            @NotNull
            private final TypedOutParameter<String> programName;
            @NotNull
            private final TypedOutParameter<String> entryPointName;
            @NotNull
            private final TypedOutParameter<Boolean> terminated;

            @NotNull
            public final TypedOutParameter<Integer> getResult() {
                return this.result;
            }

            @NotNull
            public final TypedOutParameter<Integer> getReason() {
                return this.reason;
            }

            @NotNull
            public final TypedOutParameter<Integer> getLineNr() {
                return this.lineNr;
            }

            @NotNull
            public final TypedOutParameter<Integer> getBreakpoint() {
                return this.breakpoint;
            }

            @NotNull
            public final TypedOutParameter<Integer> getStackDepth() {
                return this.stackDepth;
            }

            @NotNull
            public final TypedOutParameter<Integer> getNamespaceCode() {
                return this.namespaceCode;
            }

            @NotNull
            public final TypedOutParameter<String> getProgramSchema() {
                return this.programSchema;
            }

            @NotNull
            public final TypedOutParameter<String> getProgramName() {
                return this.programName;
            }

            @NotNull
            public final TypedOutParameter<String> getEntryPointName() {
                return this.entryPointName;
            }

            @NotNull
            public final TypedOutParameter<Boolean> getTerminated() {
                return this.terminated;
            }

            public SyncLikeProc(@NotNull String text2, int skip) {
                Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
                super(text2);
                this.result = CallParams.registerInt$default(this, skip + 1, 0, 2, null);
                this.reason = CallParams.registerInt$default(this, skip + 2, 0, 2, null);
                this.lineNr = CallParams.registerInt$default(this, skip + 3, 0, 2, null);
                this.breakpoint = CallParams.registerInt$default(this, skip + 4, 0, 2, null);
                this.stackDepth = CallParams.registerInt$default(this, skip + 5, 0, 2, null);
                this.namespaceCode = CallParams.registerInt$default(this, skip + 6, 0, 2, null);
                this.programSchema = CallParams.registerString$default(this, skip + 7, 60, null, 4, null);
                this.programName = CallParams.registerString$default(this, skip + 8, 60, null, 4, null);
                this.entryPointName = CallParams.registerString$default(this, skip + 9, 512, null, 4, null);
                this.terminated = CallParams.registerBitBool$default(this, skip + 10, false, 2, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleDebuggingSession$Companion$PrintBacktraceProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "()V", "listing", "Lcom/intellij/database/dataSource/connection/statements/TypedOutParameter;", "", "", "getListing", "()Lcom/intellij/database/dataSource/connection/statements/TypedOutParameter;", "intellij.database.dialects.oracle"})
        private static final class PrintBacktraceProc
        extends CallDefinition {
            @NotNull
            private static final TypedOutParameter<List<String>> listing;
            public static final PrintBacktraceProc INSTANCE;

            @NotNull
            public final TypedOutParameter<List<String>> getListing() {
                return listing;
            }

            private PrintBacktraceProc() {
                super("declare\n    bt sys.dbms_debug.backtrace_table;\n    pi sys.dbms_debug.program_info;\n    rt sys.dbms_debug_vc2coll;\n    s  string(1000);\n    z  constant char(1) := chr(1);\nbegin\n    sys.dbms_debug.print_backtrace(backtrace => bt);\n    rt := sys.dbms_debug_vc2coll();\n    if (bt.count >= 1) then\n        rt.extend(bt.count);\n        for i in 1 .. bt.count loop\n            pi := bt(i);\n            s := pi.namespace || z ||\n                 pi.owner || z ||\n                 pi.name || z ||\n                 pi.line# || z ||\n                 pi.libunittype || z ||\n                 pi.entrypointname || z;\n            rt(i) := s;\n        end loop;\n    end if;\n    ? := rt;\nend;");
            }

            static {
                PrintBacktraceProc printBacktraceProc;
                INSTANCE = printBacktraceProc = new PrintBacktraceProc();
                listing = printBacktraceProc.registerStringArray(1, "SYS.DBMS_DEBUG_VC2COLL");
            }
        }
    }
}

