/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.IntOutParam;
import com.intellij.database.dialects.oracle.debugger.OracleConnectionHelperKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00132\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001f\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010 J;\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001f\"\u00020\u0001\u00a2\u0006\u0002\u0010&J'\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00132\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001f\"\u00020\u0001\u00a2\u0006\u0002\u0010 J\b\u0010)\u001a\u00020\u0014H\u0016J\b\u0010*\u001a\u00020\u0014H\u0016J\u0016\u0010+\u001a\u00020\u00142\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140-H\u0004J\u000e\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OracleBaseSession;", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/database/dataSource/DatabaseConnection;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "sessionId", "", "getSessionId", "()I", "setSessionId", "(I)V", "traceConsumer", "Lkotlin/Function1;", "", "", "getTraceConsumer", "()Lkotlin/jvm/functions/Function1;", "setTraceConsumer", "(Lkotlin/jvm/functions/Function1;)V", "tracePrefix", "getTracePrefix", "()Ljava/lang/String;", "call", "statementText", "parameters", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "callFunction", "V", "function", "resultParam", "Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;", "(Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/IndexedOutParameter;[Ljava/lang/Object;)Ljava/lang/Object;", "callProcedure", "procedure", "close", "initRemote", "silently", "block", "Lkotlin/Function0;", "trace", "text", "intellij.database.dialects.oracle"})
public abstract class OracleBaseSession {
    @NotNull
    private final Logger log;
    @NotNull
    private Function1<? super String, Unit> traceConsumer;
    private int sessionId;
    @NotNull
    private final DatabaseConnection connection;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final Function1<String, Unit> getTraceConsumer() {
        return this.traceConsumer;
    }

    public final void setTraceConsumer(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.traceConsumer = function1;
    }

    public final int getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(int n) {
        this.sessionId = n;
    }

    public void initRemote() {
        this.sessionId = ((Number)this.callFunction("userenv('sessionId')", new IntOutParam(1, 0, 2, null), new Object[0])).intValue();
    }

    public final <V> V callFunction(@NotNull String function2, @NotNull IndexedOutParameter<V> resultParam, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull(resultParam, (String)"resultParam");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return OracleConnectionHelperKt.callFunction(this.connection, function2, resultParam, Arrays.copyOf(parameters, parameters.length));
    }

    public final void callProcedure(@NotNull String procedure, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        OracleConnectionHelperKt.callProcedure(this.connection, procedure, Arrays.copyOf(parameters, parameters.length));
    }

    protected final void call(@NotNull String statementText, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)statementText, (String)"statementText");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        OracleConnectionHelperKt.perform(this.connection, statementText, Arrays.copyOf(parameters, parameters.length));
    }

    public void close() {
        this.trace("Closing");
    }

    protected final void silently(@NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            block.invoke();
        }
        catch (Throwable e) {
            this.log.warn(e);
        }
    }

    public final void trace(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.traceConsumer.invoke((Object)(this.getTracePrefix() + ": " + text2));
    }

    @NotNull
    protected abstract String getTracePrefix();

    @NotNull
    public final DatabaseConnection getConnection() {
        return this.connection;
    }

    public OracleBaseSession(@NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        this.connection = connection2;
        Logger logger = Logger.getInstance((String)"com.intellij.database.oracle.Debugger");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"com.\u2026atabase.oracle.Debugger\")");
        this.log = logger;
        this.traceConsumer = (Function1)new Function1<String, Unit>(this.log){

            public final void invoke(String p1) {
                ((Logger)this.receiver).trace(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Logger.class);
            }

            public final String getName() {
                return "trace";
            }

            public final String getSignature() {
                return "trace(Ljava/lang/String;)V";
            }
        };
    }
}

