/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.mssql.plan.MsPlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsExplainPlanProvider
extends ExplainPlanProvider {
    public MsExplainPlanProvider(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(2);
        }
        if (dataSource == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(3);
        }
        if (statement == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return new MsPlanModelBuilder(owner, consumer2, statement);
    }

    @Override
    public DdlBuilder sqlExplainPlan(@NotNull LocalDataSource dataSource, @NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (dataSource == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(6);
        }
        if (statement == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(7);
        }
        builder.keywords("set", "showplan_text", "on").newStatement();
        builder.keywords("go").newLine();
        if (!analyze) {
            builder.keywords("set", "noexec", "on").newStatement();
        }
        builder.plain(statement).newStatement();
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        return builder;
    }

    @Override
    @Nullable
    public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner, final boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (owner == null) {
            MsExplainPlanProvider.$$$reportNull$$$0(8);
        }
        return new DataRequest.RawRequest(owner){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) throws Exception {
                BarrenStatement.QuietBarrenStatement<String> stmt = SmartStatements.poweredBy(connection2).simple().barren().quiet();
                if (!analyze) {
                    stmt.execute("set noexec off");
                }
                stmt.execute("set showplan_text off");
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createExplainRequest";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlExplainPlan";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "sqlPostExplainPlan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

