/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ms05ImportManager
extends ImportManager {
    public Ms05ImportManager(Dbms dbms) {
        this(dbms, "TEXT");
    }

    protected Ms05ImportManager(Dbms dbms, @NotNull String textType) {
        if (textType == null) {
            Ms05ImportManager.$$$reportNull$$$0(0);
        }
        super(dbms, textType, 1, true, true, false, true, new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT"));
    }

    @Override
    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(1);
        }
        ArrayList<String> result2 = new ArrayList<String>(this.getQueries(info, true));
        this.alterIndices(info, result2, false);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            Ms05ImportManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(3);
        }
        ArrayList<String> result2 = new ArrayList<String>(this.getQueries(info, false));
        this.alterIndices(info, result2, true);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            Ms05ImportManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ImportManager.ConnectionStateSwitch> getConnectionStateSwitches(@NotNull ImportInfo info) {
        ImportAction.ImportEditorContext context;
        MsTable table;
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(5);
        }
        MsTable msTable = table = (context = (ImportAction.ImportEditorContext)ObjectUtils.tryCast((Object)info.getContext(), ImportAction.ImportEditorContext.class)) == null ? null : (MsTable)ObjectUtils.tryCast((Object)DbImplUtil.getMaybeBasicElement((DasObject)context.getElement()), MsTable.class);
        if (table == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                Ms05ImportManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<AutoValueDescriptor> columnsForInsert = info.getConsumersForInsert();
        PositioningNamingFamily columns = table.getColumns();
        for (AutoValueDescriptor descriptor : columnsForInsert) {
            MsTableColumn column2 = (MsTableColumn)columns.get(descriptor.getName());
            if (column2 == null || column2.getSequenceIdentity() == null) continue;
            List<ImportManager.ConnectionStateSwitch> list = Collections.singletonList(new IdentityInsertsSwitch(table, this));
            if (list == null) {
                Ms05ImportManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            Ms05ImportManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void alterIndices(@NotNull ImportInfo info, @NotNull List<String> result2, boolean enable) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            Ms05ImportManager.$$$reportNull$$$0(10);
        }
        DasTable table = info.cache().getBasicTable();
        for (DasIndex index2 : table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class)) {
            result2.add(this.alterIndex(info, index2, enable));
        }
    }

    private String alterIndex(@NotNull ImportInfo info, @NotNull DasIndex index2, boolean enable) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(11);
        }
        if (index2 == null) {
            Ms05ImportManager.$$$reportNull$$$0(12);
        }
        return this.alter(this.createBuilder(info.getContext()), "INDEX", (DasObject)index2).space().keyword("ON").space().qualifiedRef((DasObject)Objects.requireNonNull(index2.getTable())).space().keyword(enable ? "REBUILD" : "DISABLE").getStatement();
    }

    @Override
    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || !DataSourceUiUtil.isMsSql2008(productVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/Ms05ImportManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/Ms05ImportManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionStateSwitches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionStateSwitches";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "alterIndices";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "alterIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IdentityInsertsSwitch
    implements ImportManager.ConnectionStateSwitch {
        private final BasicTable myTable;
        private final ImportManager myManager;
        private boolean myResult;

        IdentityInsertsSwitch(@NotNull BasicTable table, @NotNull ImportManager manager) {
            if (table == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(1);
            }
            this.myTable = table;
            this.myManager = manager;
        }

        @Override
        public void turnOn(@NotNull DatabaseConnection connection2) {
            if (connection2 == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(2);
            }
            String statement = this.generateStatement(true);
            this.myResult = SmartStatements.poweredBy(connection2).simple(Configuration.sourced(SmartStatements.Source.SYSTEM)).barren().quiet().execute(statement).isRight();
        }

        @Override
        public void turnOff(@NotNull DatabaseConnection connection2) {
            if (connection2 == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(3);
            }
            if (!this.myResult) {
                return;
            }
            String statement = this.generateStatement(false);
            SimpleSmartStatement ss = SmartStatements.poweredBy(connection2).simple(Configuration.sourced(SmartStatements.Source.SYSTEM));
            ss.barren().quiet().execute(statement);
        }

        @NotNull
        private String generateStatement(boolean on) {
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(this.myManager.getDbms()), (DasObject)this.myTable);
            builder.keywords("SET", "IDENTITY_INSERT").space().qualifiedRef(this.myTable).space().keyword(on ? "ON" : "OFF");
            String string = builder.getStatement();
            if (string == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mssql/Ms05ImportManager$IdentityInsertsSwitch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mssql/Ms05ImportManager$IdentityInsertsSwitch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "turnOn";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "turnOff";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

