/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTsqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected AbstractTsqlDialect(TypeHelper typeHelper, Casing casing) {
        super(typeHelper, casing);
    }

    @Override
    public String quoteIdentifier(String identifier, boolean force, boolean suppress, @NotNull Casing casing) {
        if (casing == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(0);
        }
        if (identifier.length() >= 2 && identifier.charAt(0) == '@') {
            return identifier;
        }
        return super.quoteIdentifier(identifier, force, suppress, casing);
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(1);
        }
        return valuesCapability;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(2);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 2, false);
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.DATABASE;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Map<String, Object> map2;
        Object db;
        if (system == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(5);
        }
        if (connection2 == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(6);
        }
        return (db = (map2 = DbImplUtil.resultRowAsMap(connection2, "select db_name() as a", new String[0])).get("a")) == null ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)db.toString(), (ObjectKind)ObjectKind.DATABASE));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(7);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.DATABASE) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(8);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/AbstractTsqlDialect";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/AbstractTsqlDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

