/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.dialects.exasol.model.ExaDatabase;
import com.intellij.database.dialects.exasol.model.ExaForeignTable;
import com.intellij.database.dialects.exasol.model.ExaLikeSchema;
import com.intellij.database.dialects.exasol.model.ExaMixinVirtualSchema;
import com.intellij.database.dialects.exasol.model.ExaModMixinVirtualSchema;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExaVirtualSchema
extends ExaLikeSchema,
ExaMixinVirtualSchema,
ExaModMixinVirtualSchema {
    @Override
    @Nullable
    default public ExaDatabase getDatabase() {
        return this.getParent();
    }

    @Override
    @Nullable
    public ExaDatabase getParent();

    @Override
    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends ExaVirtualSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends ExaForeignTable> getTables();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.FOREIGN_TABLE);
        if (list == null) {
            ExaVirtualSchema.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModNamingIdentifyingFamily<? extends ExaForeignTable>> list = Collections.singletonList(this.getTables());
        if (list == null) {
            ExaVirtualSchema.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public String getComment();

    @NotNull
    public List<NameValue> getProperties();

    @Nullable
    public String getAdapterSchema();

    @Nullable
    public String getAdapterName();

    @Nullable
    public Date getLastRefresh();

    @Nullable
    public String getLastRefreshBy();

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        String lastRefreshBy;
        Date lastRefresh;
        String adapterName;
        String adapterSchema;
        List<NameValue> properties2;
        String owner;
        boolean current;
        Date introspectionTimestamp;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer2 == null) {
            ExaVirtualSchema.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer2.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if (current = this.isCurrent()) {
            consumer2.accept("Current", PropertyConverter.export(current));
        }
        if ((owner = this.getOwner()) != null) {
            consumer2.accept("Owner", PropertyConverter.export(owner));
        }
        if (!(properties2 = this.getProperties()).isEmpty()) {
            consumer2.accept("Properties", PropertyConverter.exportListOfNameValue(properties2));
        }
        if ((adapterSchema = this.getAdapterSchema()) != null) {
            consumer2.accept("AdapterSchema", PropertyConverter.export(adapterSchema));
        }
        if ((adapterName = this.getAdapterName()) != null) {
            consumer2.accept("AdapterName", PropertyConverter.export(adapterName));
        }
        if ((lastRefresh = this.getLastRefresh()) != null) {
            consumer2.accept("LastRefresh", PropertyConverter.export(lastRefresh));
        }
        if ((lastRefreshBy = this.getLastRefreshBy()) != null) {
            consumer2.accept("LastRefreshBy", PropertyConverter.export(lastRefreshBy));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Outdated", "IntrospectionTimestamp", "Current", "Owner", "Properties", "AdapterSchema", "AdapterName", "LastRefresh", "LastRefreshBy", "Substituted");
        if (list == null) {
            ExaVirtualSchema.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setProperties(@NotNull List<NameValue> var1);

    default public void setProperties(NameValue ... properties2) {
        this.setProperties(Arrays.asList(properties2));
    }

    public void setAdapterSchema(@Nullable String var1);

    public void setAdapterName(@Nullable String var1);

    public void setLastRefresh(@Nullable Date var1);

    public void setLastRefreshBy(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            ExaVirtualSchema.$$$reportNull$$$0(4);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String introspectionTimestamp = _properties.get("IntrospectionTimestamp");
        String current = _properties.get("Current");
        String owner = _properties.get("Owner");
        String properties2 = _properties.get("Properties");
        String adapterSchema = _properties.get("AdapterSchema");
        String adapterName = _properties.get("AdapterName");
        String lastRefresh = _properties.get("LastRefresh");
        String lastRefreshBy = _properties.get("LastRefreshBy");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString(name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setIntrospectionTimestamp(introspectionTimestamp != null ? PropertyConverter.importDate(introspectionTimestamp) : null);
        this.setCurrent(current != null ? PropertyConverter.importBoolean(current) : false);
        this.setOwner(owner != null ? PropertyConverter.importString(owner) : null);
        this.setProperties(properties2 != null ? PropertyConverter.importListOfNameValue(properties2) : Collections.emptyList());
        this.setAdapterSchema(adapterSchema != null ? PropertyConverter.importString(adapterSchema) : null);
        this.setAdapterName(adapterName != null ? PropertyConverter.importString(adapterName) : null);
        this.setLastRefresh(lastRefresh != null ? PropertyConverter.importDate(lastRefresh) : null);
        this.setLastRefreshBy(lastRefreshBy != null ? PropertyConverter.importString(lastRefreshBy) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/exasol/model/ExaVirtualSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/exasol/model/ExaVirtualSchema";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

