/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaDefaults;
import com.intellij.database.dialects.cassandra.model.defaults.CassTableDefaults;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.properties.CassIndexColumn;
import com.intellij.database.model.properties.CassKeyColumn;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.dialects.cassandra.psi.CassSqlPrimaryKeyDefinition;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlWhereClauseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0019\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002J+\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020\u001f2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0)\"\u00020*H\u0002\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u0004\u0018\u00010%2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u001e\u0010-\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0006\u0010\u0007\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020/2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\b2\u0006\u00102\u001a\u000203H\u0002\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/cassandra/CassObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "buildFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildKey", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "buildLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "buildMatView", "Lcom/intellij/database/dialects/cassandra/model/CassMatView;", "buildRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "buildSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "buildTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "buildTrigger", "Lcom/intellij/database/dialects/cassandra/model/CassTrigger;", "findBoolean", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "findDouble", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Double;", "findMap", "", "findPrevSibling", "element", "skip", "", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/psi/PsiElement;", "findReferenceNameInNextSiblings", "getClusteringColOrder", "", "Lcom/intellij/database/model/properties/CassKeyColumn$Companion$ClusteringOrder;", "Lcom/intellij/sql/dialects/cassandra/psi/CassSqlPrimaryKeyDefinition;", "getClusteringOrder", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "getName", "resolve", "intellij.database.dialects.cassandra"})
public final class CassObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof CassTable) {
            this.buildLikeTable((CassLikeTable)obj2, source);
        } else if (basicModElement instanceof CassTableColumn) {
            this.buildTableColumn((CassTableColumn)obj2, source);
        } else if (basicModElement instanceof CassMatView) {
            this.buildMatView((CassMatView)obj2, source);
        } else if (basicModElement instanceof CassKey) {
            this.buildKey((CassKey)obj2, source);
        } else if (basicModElement instanceof CassFunction) {
            this.buildFunction((CassFunction)obj2, source);
        } else if (basicModElement instanceof CassAggregate) {
            this.buildAggregate((CassAggregate)obj2, source);
        } else if (basicModElement instanceof CassTrigger) {
            this.buildTrigger((CassTrigger)obj2, source);
        } else if (basicModElement instanceof CassRole) {
            this.buildRole((CassRole)obj2, source);
        } else if (basicModElement instanceof CassSchema) {
            this.buildSchema((CassSchema)obj2, source);
        } else {
            super.build(obj2, source);
        }
    }

    private final void buildSchema(CassSchema obj2, DasObject source) {
        super.buildNamespace(obj2, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj2.setReplication(CassSchemaDefaults.INSTANCE.getReplication());
        obj2.setDurableWrites(true);
        PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)source, CassTypes.CASS_WITH_OPTIONS_CLAUSE);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026OPTIONS_CLAUSE) ?: return");
        PsiElement optionsClause = psiElement;
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement psiElement2 = optionsClause;
        PsiElement first$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            Object object;
            boolean bl;
            boolean bl2;
            IElementType iElementType;
            PsiElement el = tmp$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement3 = el.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement3 != null ? this.getElementType(psiElement3) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_REPLICATION)) {
                if (this.findMap(el) != null) {
                    bl2 = false;
                    bl = false;
                    Object replication = object;
                    boolean bl4 = false;
                    obj2.setReplication((String)replication);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DURABLE_WRITES)) continue;
            if (this.findBoolean(el) == null) continue;
            bl2 = false;
            bl = false;
            boolean durable_writes = (Boolean)object;
            boolean bl5 = false;
            obj2.setDurableWrites(durable_writes);
        }
    }

    private final void buildRole(CassRole obj2, DasObject source) {
        super.buildBasicElement(obj2, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj2.setSuperRole(false);
        obj2.setCanLogin(false);
        PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)source, CassTypes.CASS_WITH_OPTIONS_CLAUSE);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026OPTIONS_CLAUSE) ?: return");
        PsiElement optionsClause = psiElement;
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement psiElement2 = optionsClause;
        PsiElement first$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            Boolean bl;
            boolean bl2;
            boolean bl3;
            IElementType iElementType;
            PsiElement it2 = tmp$iv$iv;
            boolean bl4 = false;
            PsiElement psiElement3 = it2.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement3 != null ? this.getElementType(psiElement3) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SUPERUSER)) {
                if (this.findBoolean(it2) != null) {
                    bl3 = false;
                    bl2 = false;
                    boolean isSuperRole = bl;
                    boolean bl5 = false;
                    obj2.setSuperRole(isSuperRole);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LOGIN)) continue;
            if (this.findBoolean(it2) == null) continue;
            bl3 = false;
            bl2 = false;
            boolean canLogin = bl;
            boolean bl6 = false;
            obj2.setCanLogin(canLogin);
        }
    }

    private final void buildTrigger(CassTrigger obj2, DasObject source) {
        super.buildTrigger(obj2, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj2.setClassName(null);
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            String string;
            IElementType iElementType;
            PsiElement it2 = tmp$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it2.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_USING)) continue;
            if (this.findString(it2.getFirstChild()) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            String className = string;
            boolean bl4 = false;
            obj2.setClassName(className);
        }
    }

    private final void buildAggregate(CassAggregate obj2, DasObject source) {
        super.buildRoutine(obj2, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj2.setStateFunc(null);
        obj2.setFinalFunc(null);
        obj2.setStateType(ModelConsts.NO_DATA_TYPE);
        obj2.setInitCond(null);
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            SqlExpression expression;
            String funcName;
            String string;
            boolean bl;
            boolean bl2;
            IElementType iElementType;
            PsiElement it2 = tmp$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement = it2.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SFUNC)) {
                PsiElement psiElement2 = it2.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.firstChild");
                if (this.findReferenceNameInNextSiblings(psiElement2) != null) {
                    bl2 = false;
                    bl = false;
                    funcName = string;
                    boolean bl4 = false;
                    obj2.setStateFunc(funcName);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_FINALFUNC)) {
                PsiElement psiElement3 = it2.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it.firstChild");
                if (this.findReferenceNameInNextSiblings(psiElement3) != null) {
                    bl2 = false;
                    bl = false;
                    funcName = string;
                    boolean bl5 = false;
                    obj2.setFinalFunc(funcName);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_STYPE)) {
                SqlTypeElement typeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)it2.getFirstChild(), SqlTypeElement.class);
                if (typeElement == null) continue;
                obj2.setStateType(typeElement.getDataType());
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_INITCOND) || (expression = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)it2.getFirstChild(), SqlExpression.class)) == null) continue;
            obj2.setInitCond(expression.getText());
        }
    }

    private final String findReferenceNameInNextSiblings(PsiElement element2) {
        SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element2, SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        DasObject dasObject = this.resolve(ref);
        return dasObject != null ? dasObject.getName() : null;
    }

    private final void buildFunction(CassFunction obj2, DasObject source) {
        super.buildRoutine(obj2, source);
        if (!(source instanceof SqlCreateFunctionStatementImpl)) {
            return;
        }
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(obj2){
            final /* synthetic */ CassFunction $obj;

            public final void run() {
                this.$obj.setSourceText(null);
            }
            {
                this.$obj = cassFunction;
            }
        });
        obj2.setCalledOnNullInput(false);
        obj2.setLanguage(null);
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            IElementType iElementType;
            PsiElement it2 = tmp$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it2.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_AS)) {
                TextRange range;
                SqlStringLiteralExpression stringLiteral = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)it2, SqlStringLiteralExpression.class);
                if (stringLiteral == null) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)ElementManipulators.getValueTextRange((PsiElement)((PsiElement)stringLiteral)), (String)"ElementManipulators.getV\u2026eTextRange(stringLiteral)");
                ((BasicModModel)obj2.getModel()).writeSources(new Runnable(stringLiteral, range, this, obj2){
                    final /* synthetic */ SqlStringLiteralExpression $stringLiteral;
                    final /* synthetic */ TextRange $range;
                    final /* synthetic */ CassObjectBuilder this$0;
                    final /* synthetic */ CassFunction $obj$inlined;
                    {
                        this.$stringLiteral = sqlStringLiteralExpression;
                        this.$range = textRange;
                        this.this$0 = cassObjectBuilder;
                        this.$obj$inlined = cassFunction;
                    }

                    public final void run() {
                        String string = this.$stringLiteral.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringLiteral.text");
                        String string2 = string;
                        int n = this.$range.getStartOffset();
                        int n2 = this.$range.getEndOffset();
                        CassObjectBuilder cassObjectBuilder = this.this$0;
                        CassFunction cassFunction = this.$obj$inlined;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n, n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string5 = string4;
                        cassFunction.setSourceText(CassObjectBuilder.access$asComposite(cassObjectBuilder, string5, CompositeText.Kind.ORIGINAL_TEXT));
                    }
                });
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CALLED)) {
                obj2.setCalledOnNullInput(true);
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LANGUAGE)) continue;
            PsiElement psiElement2 = it2.getFirstChild();
            SqlTokenType sqlTokenType = SqlTokens.SQL_IDENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_IDENT");
            PsiElement lang = this.findSibling(psiElement2, (IElementType)sqlTokenType);
            if (lang == null) continue;
            obj2.setLanguage(lang.getText());
        }
    }

    private final void buildTableColumn(CassTableColumn obj2, DasObject source) {
        super.build(obj2, source);
        if (!(source instanceof SqlColumnDefinition)) {
            return;
        }
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement it2 = tmp$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.getElementType(it2), (Object)CassTypes.CASS_STATIC)) continue;
            obj2.setStaticColumn(true);
        }
    }

    private final void buildLikeTable(CassLikeTable obj2, DasObject source) {
        super.buildBasicElement(obj2, source);
        if (!(source instanceof PsiElement)) {
            return;
        }
        obj2.setComment(CassTableDefaults.INSTANCE.getComment());
        obj2.setBloomFilterFpChance(0.01);
        obj2.setCaching(CassTableDefaults.INSTANCE.getCaching());
        obj2.setCdc(false);
        obj2.setCompaction(CassTableDefaults.INSTANCE.getCompaction());
        obj2.setCompression(CassTableDefaults.INSTANCE.getCompression());
        obj2.setCrcCheckChance(1.0);
        obj2.setDclocalReadRepairChance(-1.0);
        obj2.setDefaultTimeToLive(0);
        obj2.setGcGraceSeconds(864000);
        obj2.setMaxIndexInterval(2048);
        obj2.setMemtableFlushPeriodInMs(0);
        obj2.setMinIndexInterval(128);
        obj2.setReadRepairChance(0.0);
        obj2.setSpeculativeRetry("99PERCENTILE");
        PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)source, CassTypes.CASS_WITH_OPTIONS_CLAUSE);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026OPTIONS_CLAUSE) ?: return");
        PsiElement optionsClause = psiElement;
        CassObjectBuilder this_$iv = this;
        boolean $i$f$forEachChild = false;
        CassObjectBuilder cassObjectBuilder = this_$iv;
        PsiElement psiElement2 = optionsClause;
        PsiElement first$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            double d2;
            Object object;
            boolean bl;
            boolean bl2;
            PsiElement el = tmp$iv$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)this.getElementType(el), (Object)SqlCompositeElementTypes.SQL_CLAUSE) ^ true) continue;
            PsiElement psiElement3 = el.getFirstChild();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"el.firstChild");
            IElementType iElementType = this.getElementType(psiElement3);
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMMENT)) {
                obj2.setComment(this.findString(el.getFirstChild()));
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_BLOOM_FILTER_FP_CHANCE)) {
                if (this.findDouble(el) != null) {
                    bl2 = false;
                    bl = false;
                    d2 = ((Number)object).doubleValue();
                    boolean bl4 = false;
                    obj2.setBloomFilterFpChance(d2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CACHING)) {
                if (this.findMap(el) != null) {
                    bl2 = false;
                    bl = false;
                    Object map2 = object;
                    boolean bl5 = false;
                    obj2.setCaching((String)map2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CDC)) {
                if (this.findBoolean(el) != null) {
                    bl2 = false;
                    bl = false;
                    boolean bl6 = (Boolean)object;
                    boolean bl7 = false;
                    obj2.setCdc(bl6);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMPACTION)) {
                if (this.findMap(el) != null) {
                    bl2 = false;
                    bl = false;
                    Object map3 = object;
                    boolean bl8 = false;
                    obj2.setCompaction((String)map3);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMPRESSION)) {
                if (this.findMap(el) != null) {
                    bl2 = false;
                    bl = false;
                    Object map4 = object;
                    boolean bl9 = false;
                    obj2.setCompression((String)map4);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CRC_CHECK_CHANCE)) {
                if (this.findDouble(el) != null) {
                    bl2 = false;
                    bl = false;
                    d2 = ((Number)object).doubleValue();
                    boolean bl10 = false;
                    obj2.setCrcCheckChance(d2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DCLOCAL_READ_REPAIR_CHANCE)) {
                if (this.findDouble(el) != null) {
                    bl2 = false;
                    bl = false;
                    d2 = ((Number)object).doubleValue();
                    boolean bl11 = false;
                    obj2.setDclocalReadRepairChance(d2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DEFAULT_TIME_TO_LIVE)) {
                if (this.findInt(el) != null) {
                    bl2 = false;
                    bl = false;
                    int n = ((Number)object).intValue();
                    boolean bl12 = false;
                    obj2.setDefaultTimeToLive(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_GC_GRACE_SECONDS)) {
                if (this.findInt(el) != null) {
                    bl2 = false;
                    bl = false;
                    int n = ((Number)object).intValue();
                    boolean bl13 = false;
                    obj2.setGcGraceSeconds(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MAX_INDEX_INTERVAL)) {
                if (this.findInt(el) != null) {
                    bl2 = false;
                    bl = false;
                    int n = ((Number)object).intValue();
                    boolean bl14 = false;
                    obj2.setMaxIndexInterval(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MEMTABLE_FLUSH_PERIOD_IN_MS)) {
                if (this.findInt(el) != null) {
                    bl2 = false;
                    bl = false;
                    int n = ((Number)object).intValue();
                    boolean bl15 = false;
                    obj2.setMemtableFlushPeriodInMs(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MIN_INDEX_INTERVAL)) {
                if (this.findInt(el) != null) {
                    bl2 = false;
                    bl = false;
                    int n = ((Number)object).intValue();
                    boolean bl16 = false;
                    obj2.setMinIndexInterval(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_READ_REPAIR_CHANCE)) {
                if (this.findDouble(el) != null) {
                    bl2 = false;
                    bl = false;
                    d2 = ((Number)object).doubleValue();
                    boolean bl17 = false;
                    obj2.setReadRepairChance(d2);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SPECULATIVE_RETRY)) continue;
            if (this.findString(el.getFirstChild()) == null) continue;
            bl2 = false;
            bl = false;
            Object it2 = object;
            boolean bl18 = false;
            obj2.setSpeculativeRetry((String)it2);
        }
    }

    private final CassKeyColumn.Companion.ClusteringOrder getClusteringOrder(SqlReferenceExpression ref) {
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((PsiElement)ref));
        return Intrinsics.areEqual((Object)(psiElement != null ? this.getElementType(psiElement) : null), (Object)SqlCommonKeywords.SQL_DESC) ? CassKeyColumn.Companion.ClusteringOrder.DESC : CassKeyColumn.Companion.ClusteringOrder.ASC;
    }

    private final void buildKey(CassKey obj2, DasObject source) {
        Object object;
        String it2;
        Collection<CassKeyColumn> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        super.buildKey(obj2, source);
        obj2.setPrimary(true);
        obj2.setName("primary key");
        if (!(source instanceof CassSqlPrimaryKeyDefinition)) {
            return;
        }
        MultiRef<? extends DasTypedObject> multiRef = ((CassSqlPrimaryKeyDefinition)source).getClusteringColumnsRef();
        Intrinsics.checkExpressionValueIsNotNull(multiRef, (String)"source.clusteringColumnsRef");
        List<String> clusteringColNames = this.collectNames(multiRef);
        Map<String, CassKeyColumn.Companion.ClusteringOrder> clusteringColOrder = this.getClusteringColOrder((CassSqlPrimaryKeyDefinition)source);
        Iterable iterable = clusteringColNames;
        CassKey cassKey = obj2;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = clusteringColOrder;
            if (object2 == null || (object2 = object2.get(it2)) == null) {
                object2 = CassKeyColumn.Companion.ClusteringOrder.ASC;
            }
            object = new CassKeyColumn(it2, (CassKeyColumn.Companion.ClusteringOrder)((Object)object2));
            collection.add((CassKeyColumn)object);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        MultiRef<DasTypedObject> multiRef2 = ((CassSqlPrimaryKeyDefinition)source).getColumnsRef();
        Intrinsics.checkExpressionValueIsNotNull(multiRef2, (String)"source.columnsRef");
        $this$map$iv = this.collectNames(multiRef2);
        collection = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            CassKeyColumn cassKeyColumn = new CassKeyColumn(it2, null);
            object.add(cassKeyColumn);
        }
        object = (List)destination$iv$iv;
        cassKey.setColumns(CollectionsKt.plus(collection, (Iterable)((Iterable)object)));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, CassKeyColumn.Companion.ClusteringOrder> getClusteringColOrder(CassSqlPrimaryKeyDefinition source) {
        Object v5;
        block8: {
            SqlTableDefinition sqlTableDefinition = (SqlTableDefinition)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)source), SqlTableDefinition.class);
            if (sqlTableDefinition == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlTableDefinition, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
            SqlTableDefinition tableDef = sqlTableDefinition;
            PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)tableDef, CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            if (psiElement == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026NS_CLAUSE) ?: return null");
            PsiElement optionsClause = psiElement;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)optionsClause, SqlClause.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026e, SqlClause::class.java)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlClause it2 = (SqlClause)element$iv;
                boolean bl = false;
                SqlClause sqlClause = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlClause, (String)"it");
                PsiElement psiElement2 = sqlClause.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.firstChild");
                if (!Intrinsics.areEqual((Object)this.getElementType(psiElement2), (Object)CassTypes.CASS_CLUSTERING)) continue;
                v5 = element$iv;
                break block8;
            }
            v5 = null;
        }
        SqlClause sqlClause = v5;
        if (sqlClause != null) {
            SqlClause sqlClause2 = sqlClause;
            boolean bl = false;
            boolean bl2 = false;
            SqlClause el = sqlClause2;
            boolean bl3 = false;
            SqlReferenceList referenceList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)el), SqlReferenceList.class);
            Object object = referenceList;
            if (object != null && (object = object.getReferenceList()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void ref;
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    void v8 = ref;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"ref");
                    Pair pair = new Pair((Object)this.getName((SqlReferenceExpression)v8), (Object)this.getClusteringOrder((SqlReferenceExpression)ref));
                    collection.add(pair);
                }
                object = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                if (object == null) {
                } else {
                    return object;
                }
            }
            Object v9 = null;
            throw null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIndex(@NotNull BasicModIndex obj2, @NotNull DasObject source) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (obj2 instanceof BasicModNamedElement) {
            this.buildNamedElement((BasicModNamedElement)((Object)obj2), source);
        }
        if (!(source instanceof PsiElement) || !(obj2 instanceof CassIndex)) {
            return;
        }
        List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList((SqlReferenceList)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)source), SqlReferenceList.class));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"SqlImplUtil.getReference\u2026ferenceList::class.java))");
        List<SqlReferenceExpression> list2 = list;
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IElementType iElementType;
            void expression;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = expression;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"expression");
            PsiElement psiElement = (PsiElement)v1;
            IElementType[] iElementTypeArray = new IElementType[2];
            IElementType iElementType2 = CassTypes.CASS_LEFT_PAREN;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"CASS_LEFT_PAREN");
            iElementTypeArray[0] = iElementType2;
            IElementType iElementType3 = TokenType.WHITE_SPACE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"WHITE_SPACE");
            iElementTypeArray[1] = iElementType3;
            PsiElement prevSibling = this.findPrevSibling(psiElement, iElementTypeArray);
            String modifier = prevSibling == null ? null : (Intrinsics.areEqual((Object)(iElementType = this.getElementType(prevSibling)), (Object)CassTypes.CASS_FULL) ? "full" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_KEYS) ? "keys" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_ENTRIES) ? "entries" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_VALUES) ? "values" : null))));
            CassIndexColumn cassIndexColumn = new CassIndexColumn(this.getName((SqlReferenceExpression)expression), modifier);
            collection.add(cassIndexColumn);
        }
        List columns = (List)destination$iv$iv;
        ((CassIndex)obj2).setColumns(columns);
    }

    private final PsiElement findPrevSibling(PsiElement element2, IElementType ... skip) {
        PsiElement prevSibling;
        for (prevSibling = element2.getPrevSibling(); prevSibling != null && ArraysKt.contains((Object[])skip, (Object)this.getElementType(prevSibling)); prevSibling = prevSibling.getPrevSibling()) {
        }
        return prevSibling;
    }

    private final String getName(SqlReferenceExpression ref) {
        Object object = this.resolve(ref);
        if (object == null || (object = object.getName()) == null) {
            String string = ref.getName();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ref.name");
        }
        return object;
    }

    private final DasObject resolve(SqlReferenceExpression ref) {
        ResolveResult[] resolveResultArray = ref.multiResolve(false);
        int n = resolveResultArray.length;
        for (int j = 0; j < n; ++j) {
            ResolveResult result2;
            ResolveResult resolveResult = result2 = resolveResultArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResult, (String)"result");
            PsiElement element2 = resolveResult.getElement();
            if (!(element2 instanceof DasObject)) continue;
            return (DasObject)element2;
        }
        return null;
    }

    private final Boolean findBoolean(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        if (object != null && (object = object.getText()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object text2 = object2;
            boolean bl3 = false;
            Object object3 = text2;
            boolean bl4 = false;
            Object object4 = object3;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            switch (string) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            return null;
        }
        return null;
    }

    private final Double findDouble(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toDoubleOrNull((String)object) : null;
    }

    private final String findMap(PsiElement source) {
        IElementType iElementType = CassTypes.CASS_SET_OR_MAP_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"CASS_SET_OR_MAP_LITERAL");
        PsiElement psiElement = this.findChild(source, iElementType);
        return psiElement != null ? psiElement.getText() : null;
    }

    private final void buildMatView(CassMatView obj2, DasObject source) {
        SqlWhereClauseImpl whereClause;
        this.buildLikeTable(obj2, source);
        if (!(source instanceof SqlCreateViewStatement)) {
            return;
        }
        SqlFromClause fromClause = (SqlFromClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)source), SqlFromClause.class);
        if (fromClause != null) {
            SqlExpression sqlExpression = fromClause.getFromExpression();
            obj2.setBaseTableName(sqlExpression != null ? sqlExpression.getText() : null);
        }
        if ((whereClause = (SqlWhereClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)source), SqlWhereClauseImpl.class)) != null) {
            String string;
            String string2 = whereClause.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"whereClause.text");
            String string3 = string2;
            int n = "where".length();
            CassMatView cassMatView = obj2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string = string5;
            n = 0;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string6)).toString();
            cassMatView.setWhereClause(string);
        }
    }

    public static final /* synthetic */ SimpleCompositeText access$asComposite(CassObjectBuilder $this, String $this$access_u24asComposite, CompositeText.Kind kind) {
        return $this.asComposite($this$access_u24asComposite, kind);
    }
}

