/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\bJ(\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/Dbms;)V", "builder", "Lcom/intellij/sql/database/SqlObjectBuilder;", "getBuilder", "()Lcom/intellij/sql/database/SqlObjectBuilder;", "facade", "Lcom/intellij/sql/psi/SqlPsiFacade;", "Lorg/jetbrains/annotations/NotNull;", "getFacade", "()Lcom/intellij/sql/psi/SqlPsiFacade;", "language", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getLanguage", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "createROFile", "Lcom/intellij/sql/psi/SqlFile;", "src", "", "statements", "Lcom/intellij/util/containers/JBIterable;", "T", "clazz", "Ljava/lang/Class;", "traverse", "Lcom/intellij/psi/SyntaxTraverser;", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.base"})
public final class IntrospectorSqlHelper {
    @NotNull
    private final SqlPsiFacade facade;
    @NotNull
    private final SqlLanguageDialect language;
    @NotNull
    private final SqlObjectBuilder builder;

    @NotNull
    public final SqlPsiFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final SqlLanguageDialect getLanguage() {
        return this.language;
    }

    @NotNull
    public final SqlObjectBuilder getBuilder() {
        return this.builder;
    }

    private final SqlFile createROFile(String src) {
        SqlFile sqlFile = this.facade.createROFile(this.language, (CharSequence)src);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlFile, (String)"facade.createROFile(language, src)");
        return sqlFile;
    }

    private final SyntaxTraverser<PsiElement> traverse(String src) {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.createROFile(src)));
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(createROFile(src))");
        return syntaxTraverser;
    }

    @NotNull
    public final <T> JBIterable<T> statements(@NotNull String src, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        JBIterable jBIterable = ((SyntaxTraverser)this.traverse(src).expandAndSkip((Condition)statements.1.INSTANCE)).filter(clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"traverse(src).expandAndS\u2026Statement }.filter(clazz)");
        return jBIterable;
    }

    @NotNull
    public final /* synthetic */ <T> JBIterable<T> statements(@NotNull String src) {
        int $i$f$statements = 0;
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.statements(src, Object.class);
    }

    public IntrospectorSqlHelper(@NotNull Project project, @NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlPsiFacade, (String)"SqlPsiFacade.getInstance(project)");
        this.facade = sqlPsiFacade;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dbms)");
        this.language = sqlLanguageDialect;
        Object object = SqlObjectBuilder.EP.forDbms(dbms);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        this.builder = (SqlObjectBuilder)object;
    }
}

