/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseLogViewService;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.session.BaseLogView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "sessionIfSupported", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSessionIfSupported", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/database/console/session/DatabaseSession;", "isSelected", "", "e", "setSelected", "", "state", "update", "Companion", "MyDataAuditor", "intellij.database.dialects.base"})
public final class ProcessDbmsOutputAction
extends ToggleAction {
    private static final Key<MyDataAuditor> DBMS_LISTENER;
    private static final int BYTES_TO_LOAD = 0x100000;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DatabaseSession session2 = this.getSessionIfSupported(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(session2 != null);
        if (session2 != null) {
            super.update(e);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DatabaseSession databaseSession = this.getSessionIfSupported(e);
        return (databaseSession != null ? (MyDataAuditor)databaseSession.getUserData(DBMS_LISTENER) : null) != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        block2: {
            DatabaseSession session2;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                DatabaseSession databaseSession = this.getSessionIfSupported(e);
                if (databaseSession == null) {
                    return;
                }
                session2 = databaseSession;
                if (!state2) break block1;
                MyDataAuditor listener = new MyDataAuditor(session2);
                Disposer.register((Disposable)session2, (Disposable)listener);
                session2.getMessageBus().addAuditor(listener);
                session2.putUserData(DBMS_LISTENER, listener);
                break block2;
            }
            MyDataAuditor myDataAuditor = (MyDataAuditor)session2.getUserData(DBMS_LISTENER);
            if (myDataAuditor == null) break block2;
            MyDataAuditor myDataAuditor2 = myDataAuditor;
            boolean bl = false;
            boolean bl2 = false;
            MyDataAuditor listener = myDataAuditor2;
            boolean bl3 = false;
            session2.putUserData(DBMS_LISTENER, null);
            Disposer.dispose((Disposable)listener);
        }
    }

    private final DatabaseSession getSessionIfSupported(@NotNull AnActionEvent $this$sessionIfSupported) {
        DatabaseSession databaseSession;
        DatabaseSession databaseSession2 = DatabaseSessionManager.findSession($this$sessionIfSupported);
        if (databaseSession2 != null) {
            DatabaseSession databaseSession3 = databaseSession2;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseSession it2 = databaseSession3;
            boolean bl3 = false;
            LocalDataSource localDataSource = (LocalDataSource)it2.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"it.target");
            Dbms dbms = localDataSource.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"it.target.dbms");
            Dbms dbms2 = dbms;
            databaseSession = dbms2.isOracle() || Intrinsics.areEqual((Object)dbms2, (Object)Dbms.DB2_LUW) ? databaseSession3 : null;
        } else {
            databaseSession = null;
        }
        return databaseSession;
    }

    static {
        Companion = new Companion(null);
        Key key2 = Key.create((String)"DBMS_LISTENER");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<MyDataAuditor>(\"DBMS_LISTENER\")");
        DBMS_LISTENER = key2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "Lcom/intellij/database/datagrid/DataAuditor$Adapter;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "dbmsOutputPrefix", "", "dispose", "", "execute", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "statements", "Lcom/intellij/database/dataSource/connection/statements/SmartStatements;", "statement", "requestFinished", "requestStarted", "intellij.database.dialects.base"})
    private static final class MyDataAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private final String dbmsOutputPrefix;
        private final DatabaseSession session;

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection2 = databaseConnection;
            this.execute(context, SmartStatements.Companion.poweredBy(connection2), "{call " + this.dbmsOutputPrefix + "dbms_output.enable(1048576)}");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection2 = databaseConnection;
            String sql = "{call " + this.dbmsOutputPrefix + "dbms_output.get_line(?, ?)}";
            CallableStatementBasis data = new StatementParameters().parameter(1, 12).parameter(2, 4).asCallBasis(sql);
            SmartStatements statements2 = SmartStatements.Companion.poweredBy(connection2);
            Configuration configuration = Configuration.Companion.sourced(SmartStatements.Source.SYSTEM);
            try {
                AutoCloseable autoCloseable = statements2.call(configuration).reuse(data);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    ReusableSmartStatement call2 = (ReusableSmartStatement)autoCloseable;
                    boolean bl2 = false;
                    int status = 0;
                    do {
                        AutoCloseable autoCloseable2 = call2.noisy().execute(StatementParameters.Companion.getEmpty(), StandardExecutionMode.GENERIC);
                        boolean bl3 = false;
                        Throwable throwable2 = null;
                        try {
                            ClosableResultsProducer producer = (ClosableResultsProducer)autoCloseable2;
                            boolean bl4 = false;
                            Object first2 = producer.getParameterValue(1);
                            if (first2 instanceof String) {
                                DataRequest.Owner owner;
                                Object object = DatabaseLogViewService.getViewIfAny(this.session);
                                if (object != null && (object = ((BaseLogView)object).getHistoryLogger()) != null) {
                                    ((DataAuditor.PrintingAdapter)object).warn(context, (String)first2);
                                }
                                if (!((owner = context.request.owner) instanceof DatabaseSessionClientWithFile)) {
                                    owner = null;
                                }
                                if ((DatabaseSessionClientWithFile)owner != null) {
                                    DatabaseSessionClientWithFile databaseSessionClientWithFile;
                                    boolean bl5 = false;
                                    boolean bl6 = false;
                                    DatabaseSessionClientWithFile owner2 = databaseSessionClientWithFile;
                                    boolean bl7 = false;
                                    Object object2 = DatabaseLogViewService.getViewIfAny(owner2);
                                    if (object2 != null && (object2 = ((BaseLogView)object2).getHistoryLogger()) != null) {
                                        ((DataAuditor.PrintingAdapter)object2).warn(context, (String)first2);
                                    }
                                }
                            }
                            Object object = producer.getParameterValue(2);
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                            }
                            status = (Integer)object;
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                        }
                    } while (status == 0);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (SQLException sQLException) {
            }
            catch (Exception e) {
                context.reportException(e, null);
            }
            finally {
                this.execute(context, statements2, "{call " + this.dbmsOutputPrefix + "dbms_output.disable()}");
            }
        }

        private final void execute(DataRequest.Context context, SmartStatements statements2, String statement) {
            try {
                statements2.simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).barren().quiet().execute(statement);
            }
            catch (Exception e) {
                context.reportException(e, null);
            }
        }

        public void dispose() {
        }

        public MyDataAuditor(@NotNull DatabaseSession session2) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            this.session = session2;
            MyDataAuditor myDataAuditor = this;
            MyDataAuditor myDataAuditor2 = this;
            boolean bl = false;
            boolean bl2 = false;
            MyDataAuditor $this$run = myDataAuditor;
            boolean bl3 = false;
            LocalDataSource localDataSource = (LocalDataSource)$this$run.session.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"session.target");
            Dbms dbms = localDataSource.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"session.target.dbms");
            Dbms dbms2 = dbms;
            myDataAuditor2.dbmsOutputPrefix = string = dbms2.isOracle() ? "sys." : (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.DB2_LUW) ? "sysibmadm." : "");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$Companion;", "", "()V", "BYTES_TO_LOAD", "", "DBMS_LISTENER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "kotlin.jvm.PlatformType", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getConnection", "(Lcom/intellij/database/datagrid/DataRequest$Context;)Lcom/intellij/database/dataSource/DatabaseConnection;", "intellij.database.dialects.base"})
    public static final class Companion {
        @Nullable
        public final DatabaseConnection getConnection(@NotNull DataRequest.Context $this$connection) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)$this$connection), (String)"$this$connection");
            DataProducer dataProducer = $this$connection.producer;
            if (!(dataProducer instanceof JdbcEngine)) {
                dataProducer = null;
            }
            JdbcEngine jdbcEngine = (JdbcEngine)dataProducer;
            return jdbcEngine != null ? jdbcEngine.getCurrentConnection() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

