/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DataRequest {
    public static final TxMarker NONE = DataRequest.newTxMarker("NONE", null, false);
    public static final TxMarker AUTO_COMMIT = DataRequest.newTxMarker("AUTO_COMMIT", null, false);
    public static final TxMarker START_NEW = DataRequest.newTxMarker("START_NEW", null, false);
    public static final TxMarker IN_PROGRESS = DataRequest.newTxMarker("IN_PROGRESS", null, true);
    public final Owner owner;
    public final SearchPath path;
    private final AsyncPromise<Void> promise;
    private final NotNullLazyValue<TxMarker> myMarker;

    @NotNull
    public AsyncPromise<Void> getPromise() {
        AsyncPromise<Void> asyncPromise = this.promise;
        if (asyncPromise == null) {
            DataRequest.$$$reportNull$$$0(0);
        }
        return asyncPromise;
    }

    @NotNull
    public TxMarker getTxMarker() {
        TxMarker txMarker = (TxMarker)this.myMarker.getValue();
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(1);
        }
        return txMarker;
    }

    public boolean isAsyncFriendly() {
        return true;
    }

    @NotNull
    public static Owner newOwner() {
        final String title = "Owner:" + ((Class)ObjectUtils.assertNotNull((Object)ReflectionUtil.findCallerClass((int)2))).getSimpleName();
        Owner owner = new Owner(){

            public void dispose() {
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$1", "getDisplayName"));
            }
        };
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(2);
        }
        return owner;
    }

    @NotNull
    public static OwnerEx newOwnerEx(final @NotNull Project project) {
        if (project == null) {
            DataRequest.$$$reportNull$$$0(3);
        }
        final String title = "OwnerEx:" + ((Class)ObjectUtils.assertNotNull((Object)ReflectionUtil.findCallerClass((int)2))).getSimpleName();
        OwnerEx ownerEx = new OwnerEx(){
            final DataBus.Consuming messageBus;
            {
                this.messageBus = SimpleRequestBroker.newInstance(project, title).filterFor(this);
            }

            @Override
            public DataBus.Consuming getMessageBus() {
                return this.messageBus;
            }

            @Override
            @NotNull
            public TxMarker getCurrentTx() {
                TxMarker txMarker = NONE;
                if (txMarker == null) {
                    2.$$$reportNull$$$0(0);
                }
                return txMarker;
            }

            @Override
            public void setAutoCommit(boolean autoCommit) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void dispose() {
            }

            public String toString() {
                return this.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/datagrid/DataRequest$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentTx";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (ownerEx == null) {
            DataRequest.$$$reportNull$$$0(4);
        }
        return ownerEx;
    }

    @NotNull
    public static TxMarker getInitialTxMarker(boolean autoCommit) {
        TxMarker txMarker = autoCommit ? AUTO_COMMIT : START_NEW;
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(5);
        }
        return txMarker;
    }

    @NotNull
    public static TxMarker newTxMarker(@NotNull String title, @Nullable Owner owner) {
        if (title == null) {
            DataRequest.$$$reportNull$$$0(6);
        }
        TxMarker txMarker = DataRequest.newTxMarker(title, owner, false);
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(7);
        }
        return txMarker;
    }

    @NotNull
    public static TxMarker newTxMarker(final @NotNull String title, final @Nullable Owner owner, final boolean txInProgress) {
        if (title == null) {
            DataRequest.$$$reportNull$$$0(8);
        }
        TxMarker txMarker = new TxMarker(){

            @Override
            public Owner getOwner() {
                return owner;
            }

            @Override
            @NotNull
            public String toString() {
                String string = title;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isTransactionInProgress() {
                return owner != null || txInProgress;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$3", "toString"));
            }
        };
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(9);
        }
        return txMarker;
    }

    @NotNull
    public static DataRequest newCallRequest(@NotNull OwnerEx owner, @NotNull List<CallRequest.Statement> statements2, @Nullable SearchPath path) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(10);
        }
        if (statements2 == null) {
            DataRequest.$$$reportNull$$$0(11);
        }
        CallRequest callRequest = new CallRequest(owner, statements2, path);
        if (callRequest == null) {
            DataRequest.$$$reportNull$$$0(12);
        }
        return callRequest;
    }

    @NotNull
    public static DataRequest newLimitlessRequest(@NotNull OwnerEx owner, @NotNull String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(13);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(14);
        }
        QueryRequest queryRequest = new QueryRequest(owner, query, DataRequest.newConstraints(0, -1, 0, -1), null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(15);
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(16);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(17);
        }
        QueryRequest queryRequest = new QueryRequest(owner, query, DataRequest.newConstraints(), null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(18);
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query, int offset, int queryOffset, int pageSize, int resultSetIndex) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(19);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(20);
        }
        QueryRequest queryRequest = new QueryRequest(owner, query, DataRequest.newConstraints(offset, pageSize, queryOffset, resultSetIndex), null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(21);
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull Owner owner, @NotNull TxMarker txMarker, @NotNull String query, @NotNull Constraints constraints) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(22);
        }
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(23);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(24);
        }
        if (constraints == null) {
            DataRequest.$$$reportNull$$$0(25);
        }
        QueryRequest queryRequest = new QueryRequest(owner, txMarker, query, constraints, null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(26);
        }
        return queryRequest;
    }

    @NotNull
    public static DmlRequest newInsertRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(27);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(28);
        }
        InsertRequest insertRequest = new InsertRequest(owner, context);
        if (insertRequest == null) {
            DataRequest.$$$reportNull$$$0(29);
        }
        return insertRequest;
    }

    @NotNull
    public static DmlRequest newUpdateRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(30);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(31);
        }
        UpdateRequest updateRequest = new UpdateRequest(owner, context);
        if (updateRequest == null) {
            DataRequest.$$$reportNull$$$0(32);
        }
        return updateRequest;
    }

    @NotNull
    public static DmlRequest newDeleteRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(33);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(34);
        }
        DeleteRequest deleteRequest = new DeleteRequest(owner, context);
        if (deleteRequest == null) {
            DataRequest.$$$reportNull$$$0(35);
        }
        return deleteRequest;
    }

    public static DataRequest newCompositeRequest(@NotNull OwnerEx owner, @NotNull List<DmlRequest> requests) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(36);
        }
        if (requests == null) {
            DataRequest.$$$reportNull$$$0(37);
        }
        return new CompositeRequest(owner, requests);
    }

    @NotNull
    public static DataRequest newTxCommit(@NotNull OwnerEx owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(38);
        }
        TxRequest txRequest = new TxRequest(owner, TxCommand.COMMIT);
        if (txRequest == null) {
            DataRequest.$$$reportNull$$$0(39);
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newTxRollback(@NotNull OwnerEx owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(40);
        }
        TxRequest txRequest = new TxRequest(owner, TxCommand.ROLLBACK);
        if (txRequest == null) {
            DataRequest.$$$reportNull$$$0(41);
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newSchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath schema, boolean forced) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(42);
        }
        if (schema == null) {
            DataRequest.$$$reportNull$$$0(43);
        }
        SchemaSwitchRequest schemaSwitchRequest = new SchemaSwitchRequest(owner, schema, forced);
        if (schemaSwitchRequest == null) {
            DataRequest.$$$reportNull$$$0(44);
        }
        return schemaSwitchRequest;
    }

    @NotNull
    public static Context newContext(@NotNull OwnerEx owner, @Nullable DataProducer producer, String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(45);
        }
        Context context = new Context(producer, DataRequest.newRequest(owner, query), NONE){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/datagrid/DataRequest$4", "reportException"));
            }
        };
        if (context == null) {
            DataRequest.$$$reportNull$$$0(46);
        }
        return context;
    }

    public static Constraints newConstraints() {
        return DataRequest.newConstraints(0, DbImplUtil.getPageSize(), 0, 0);
    }

    public static Constraints newConstraints(int offset, int limit, int queryOffset, int resultSetIndex) {
        return new Constraints(offset, limit, queryOffset, "", resultSetIndex, Collections.emptyList());
    }

    protected DataRequest(@NotNull Owner owner, @NotNull TxMarker txMarker) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(47);
        }
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(48);
        }
        this.promise = new AsyncPromise();
        this.owner = owner;
        this.myMarker = NotNullLazyValue.createConstantValue((Object)txMarker);
        this.path = owner instanceof CustomSearchPathOwner ? ((CustomSearchPathOwner)owner).getSearchPath() : null;
    }

    protected DataRequest(@NotNull Owner owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(49);
        }
        this(owner, owner instanceof CustomSearchPathOwner ? ((CustomSearchPathOwner)owner).getSearchPath() : null);
    }

    protected DataRequest(@NotNull Owner owner, @Nullable SearchPath path) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(50);
        }
        this.promise = new AsyncPromise();
        this.owner = owner;
        this.myMarker = NotNullLazyValue.createValue(() -> owner instanceof OwnerEx ? ((OwnerEx)owner).getCurrentTx() : NONE);
        this.path = path;
    }

    public void accept(Visitor visitor2) {
        visitor2.visitRequest(this);
    }

    public static int getStartIdx(@NotNull Constraints constraints, int size) {
        if (constraints == null) {
            DataRequest.$$$reportNull$$$0(51);
        }
        if (constraints.absolutePosition >= 0) {
            return constraints.absolutePosition + 1;
        }
        return size + constraints.absolutePosition + 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 23: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 25: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxMarker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newOwner";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newOwnerEx";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialTxMarker";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newTxMarker";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newCallRequest";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newLimitlessRequest";
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "newRequest";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "newInsertRequest";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "newUpdateRequest";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeleteRequest";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newTxCommit";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newTxRollback";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newSchemaSwitchRequest";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "newContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newOwnerEx";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newTxMarker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newCallRequest";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newLimitlessRequest";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newRequest";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newInsertRequest";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "newUpdateRequest";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newDeleteRequest";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newCompositeRequest";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newTxCommit";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newTxRollback";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "newSchemaSwitchRequest";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getStartIdx";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Visitor {
        public void visitRequest(DataRequest r) {
        }

        public void visitCancel(Cancel r) {
            this.visitRequest(r);
        }

        public void visitTx(TxRequest r) {
            this.visitRequest(r);
        }

        public void visitDml(DmlRequest r) {
            this.visitRequest(r);
        }

        public void visitInsert(InsertRequest r) {
            this.visitDml(r);
        }

        public void visitUpdate(UpdateRequest r) {
            this.visitDml(r);
        }

        public void visitDelete(DeleteRequest r) {
            this.visitDml(r);
        }

        public void visitComposite(CompositeRequest r) {
            this.visitRequest(r);
        }

        public void visitRaw(RawRequest r) {
            this.visitRequest(r);
        }

        public void visitQuery(QueryRequest r) {
            this.visitRequest(r);
        }

        public void visitCall(CallRequest r) {
            this.visitRequest(r);
        }

        public void visitSchemaSwitch(SchemaSwitchRequest r) {
            this.visitRequest(r);
        }

        public void visitDisconnect(Disconnect r) {
            this.visitRequest(r);
        }
    }

    public static class Constraints {
        public final int absolutePosition;
        public final int limit;
        public final int queryOffset;
        public final String filter;
        public final int resultSetNumber;
        public final List<RowSortOrder<String>> orders;

        public Constraints(int absolutePosition, int limit, int queryOffset, String filter2, int resultSetNumber, List<RowSortOrder<String>> orders) {
            this.absolutePosition = absolutePosition;
            this.limit = limit;
            this.queryOffset = queryOffset;
            this.filter = filter2;
            this.resultSetNumber = resultSetNumber;
            this.orders = orders;
        }
    }

    public static abstract class TxContext
    extends Context {
        private static final int UNDEFINED = -2;
        private volatile int myIsolation;

        public TxContext(@Nullable DataProducer producer, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (request == null) {
                TxContext.$$$reportNull$$$0(0);
            }
            if (txMarker == null) {
                TxContext.$$$reportNull$$$0(1);
            }
            super(producer, request, txMarker);
            this.myIsolation = -2;
        }

        public void setIsolation(int isolation) {
            this.myIsolation = isolation;
        }

        public void updateIsolation(@NotNull TxIsolationOwner owner) {
            if (owner == null) {
                TxContext.$$$reportNull$$$0(2);
            }
            if (this.myIsolation != -2) {
                owner.setTxIsolation(this.myIsolation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "txMarker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataRequest$TxContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIsolation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface StatementContext {
        @NotNull
        public String getSql();
    }

    public static abstract class Context
    extends UserDataHolderBase {
        public final DataProducer producer;
        public final DataRequest request;
        public final TxMarker txMarker;
        public final ConcurrentLinkedDeque<StatementContext> statementContext;

        public Context(@Nullable DataProducer producer, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (request == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (txMarker == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.statementContext = new ConcurrentLinkedDeque();
            this.producer = producer;
            this.request = request;
            this.txMarker = txMarker;
        }

        @Nullable
        public StatementContext getStatementContext() {
            return this.statementContext.peek();
        }

        @NotNull
        public String getQuery() {
            StatementContext top = this.statementContext.peek();
            String string = top != null ? top.getSql() : (this.request instanceof QueryRequest ? ((QueryRequest)this.request).query : "");
            if (string == null) {
                Context.$$$reportNull$$$0(2);
            }
            return string;
        }

        public abstract void reportException(@NotNull Throwable var1, @Nullable Object var2);

        @Nullable
        public SearchPath getSearchPath() {
            return null;
        }

        public String toString() {
            return this.request + " in " + this.txMarker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "txMarker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataRequest$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataRequest$Context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TxMarker {
        @Nullable
        public Owner getOwner();

        @NotNull
        public String toString();

        public boolean isTransactionInProgress();
    }

    public static interface TxIsolationOwner
    extends OwnerEx {
        public int getTxIsolation();

        public void setTxIsolation(int var1);
    }

    public static interface CustomSearchPathOwner
    extends OwnerEx {
        @Nullable
        public SearchPath getSearchPath();

        default public boolean cleanup() {
            return true;
        }
    }

    public static interface DepartmentHolder {
        @NotNull
        public DatabaseDepartment getDepartment();
    }

    public static interface CrossSessionOwner
    extends CustomSearchPathOwner {
        @NotNull
        public Disposable getTxDisposable();

        @NotNull
        public Owner getParentOwner();
    }

    public static interface OwnerEx
    extends Owner {
        public DataBus.Consuming getMessageBus();

        @NotNull
        public TxMarker getCurrentTx();

        public void setAutoCommit(boolean var1);

        default public boolean isChildOf(@NotNull Owner owner) {
            if (owner == null) {
                OwnerEx.$$$reportNull$$$0(0);
            }
            return this == owner;
        }

        default public boolean isEphemeral() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$OwnerEx", "isChildOf"));
        }
    }

    public static interface Owner
    extends Disposable {
        @NotNull
        public String getDisplayName();
    }

    public static abstract class RawQueryRequest
    extends IsolatedQueryRequest {
        protected RawQueryRequest(OwnerEx owner, String query, Constraints constraints) {
            super(owner, query, constraints, null);
        }

        @Override
        public void setColumns(@NotNull Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                RawQueryRequest.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull Context context, int total) {
            if (context == null) {
                RawQueryRequest.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/datagrid/DataRequest$RawQueryRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class IsolatedQueryRequest
    extends QueryRequest
    implements DataConsumer {
        protected IsolatedQueryRequest(@NotNull Owner owner, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(2);
            }
            super(owner, query, constraints, params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpdateRequest
    extends DmlRequest {
        UpdateRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner, context);
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitUpdate(this);
        }
    }

    public static class CompositeRequest
    extends DataRequest {
        public final List<DmlRequest> requests;

        CompositeRequest(OwnerEx owner, List<DmlRequest> requests) {
            super(owner);
            this.requests = ContainerUtil.immutableList(new ArrayList<DmlRequest>(requests));
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitComposite(this);
        }
    }

    public static class DeleteRequest
    extends DmlRequest {
        DeleteRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner, context);
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitDelete(this);
        }
    }

    public static class InsertRequest
    extends DmlRequest {
        InsertRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner, context);
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitInsert(this);
        }
    }

    public static abstract class DmlRequest
    extends DataRequest {
        public final DmlMutationContext context;

        DmlRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner);
            this.context = context;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitDml(this);
        }
    }

    public static class CallRequest
    extends DataRequest {
        public final List<Statement> queries;

        protected CallRequest(@NotNull OwnerEx owner, @NotNull List<Statement> statements2, @Nullable SearchPath path) {
            if (owner == null) {
                CallRequest.$$$reportNull$$$0(0);
            }
            if (statements2 == null) {
                CallRequest.$$$reportNull$$$0(1);
            }
            super((Owner)owner, path);
            this.queries = statements2;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitCall(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statements";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$CallRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class Statement {
            public final String statement;
            public final TIntIntHashMap outParameters;
            public final TIntObjectHashMap inParameters;

            public Statement(@NotNull String statement) {
                if (statement == null) {
                    Statement.$$$reportNull$$$0(0);
                }
                this(statement, new TIntIntHashMap());
            }

            public Statement(@NotNull String statement, @NotNull TIntIntHashMap outParameters) {
                if (statement == null) {
                    Statement.$$$reportNull$$$0(1);
                }
                if (outParameters == null) {
                    Statement.$$$reportNull$$$0(2);
                }
                this(statement, outParameters, new TIntObjectHashMap());
            }

            public Statement(@NotNull String statement, @NotNull TIntIntHashMap outParameters, @NotNull TIntObjectHashMap inParameters) {
                if (statement == null) {
                    Statement.$$$reportNull$$$0(3);
                }
                if (outParameters == null) {
                    Statement.$$$reportNull$$$0(4);
                }
                if (inParameters == null) {
                    Statement.$$$reportNull$$$0(5);
                }
                this.statement = statement;
                this.outParameters = outParameters;
                this.inParameters = inParameters;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statement";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outParameters";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "inParameters";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/datagrid/DataRequest$CallRequest$Statement";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class QueryRequest
    extends DataRequest {
        public final String query;
        public final Constraints constraints;
        public final Object params;
        public final SqlDebugController controller;

        protected QueryRequest(@NotNull Owner owner, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                QueryRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                QueryRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                QueryRequest.$$$reportNull$$$0(2);
            }
            this(owner, query, constraints, params, null);
        }

        protected QueryRequest(@NotNull Owner owner, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params, @Nullable SqlDebugController controller) {
            if (owner == null) {
                QueryRequest.$$$reportNull$$$0(3);
            }
            if (query == null) {
                QueryRequest.$$$reportNull$$$0(4);
            }
            if (constraints == null) {
                QueryRequest.$$$reportNull$$$0(5);
            }
            super(owner);
            this.query = query;
            this.constraints = constraints;
            this.params = params;
            this.controller = controller;
        }

        protected QueryRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                QueryRequest.$$$reportNull$$$0(6);
            }
            if (marker == null) {
                QueryRequest.$$$reportNull$$$0(7);
            }
            if (query == null) {
                QueryRequest.$$$reportNull$$$0(8);
            }
            if (constraints == null) {
                QueryRequest.$$$reportNull$$$0(9);
            }
            super(owner, marker);
            this.query = query;
            this.constraints = constraints;
            this.params = params;
            this.controller = null;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitQuery(this);
        }

        public String toString() {
            return this.query + "@" + this.owner.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "marker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$QueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ConditionQueryRequest
    extends RawQueryRequest {
        public final RowQueryData rowQueryData;
        public final DasTable table;

        protected ConditionQueryRequest(@NotNull OwnerEx owner, @NotNull RowQueryData rowQueryData, @NotNull Constraints constraints, @Nullable DasTable table) {
            if (owner == null) {
                ConditionQueryRequest.$$$reportNull$$$0(0);
            }
            if (rowQueryData == null) {
                ConditionQueryRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                ConditionQueryRequest.$$$reportNull$$$0(2);
            }
            super(owner, rowQueryData.getSql(), constraints);
            this.rowQueryData = rowQueryData;
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rowQueryData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$ConditionQueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class RawRequest
    extends DataRequest {
        protected RawRequest(OwnerEx owner) {
            super(owner);
        }

        public abstract void processRaw(Context var1, DatabaseConnection var2) throws Exception;

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitRaw(this);
        }
    }

    public static class Disconnect
    extends DataRequest {
        public Disconnect(@NotNull Owner owner) {
            if (owner == null) {
                Disconnect.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitDisconnect(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$Disconnect", "<init>"));
        }
    }

    public static class SchemaSwitchRequest
    extends DataRequest {
        public final SearchPath pathToSwitch;
        public final boolean forced;

        protected SchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath path, boolean forced) {
            if (owner == null) {
                SchemaSwitchRequest.$$$reportNull$$$0(0);
            }
            if (path == null) {
                SchemaSwitchRequest.$$$reportNull$$$0(1);
            }
            super(owner);
            this.pathToSwitch = path;
            this.forced = forced;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitSchemaSwitch(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$SchemaSwitchRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Cancel
    extends DataRequest {
        public Cancel(@NotNull OwnerEx owner) {
            if (owner == null) {
                Cancel.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitCancel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$Cancel", "<init>"));
        }
    }

    public static class TxRequest
    extends DataRequest {
        public final TxCommand command;

        protected TxRequest(Owner owner, TxMarker marker, TxCommand command) {
            super(owner, marker);
            this.command = command;
        }

        protected TxRequest(OwnerEx owner, TxCommand command) {
            super(owner);
            this.command = command;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visitTx(this);
        }
    }

    public static enum TxCommand {
        COMMIT,
        ROLLBACK;

    }
}

