/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxParamEditor
extends ParamEditorBase<ComboBox> {
    private static final Pattern CONFIG_PATTERN = Pattern.compile("(?:^|,)((?:[^=,]|\\\\=)+)=((?:[^=,]|\\\\=)+)");
    private String myText;

    @Nullable
    private static List<Pair<String, String>> parseConfiguration(@Nullable String configuration) {
        if (StringUtil.isEmpty((String)configuration)) {
            return null;
        }
        ArrayList<Pair<String, String>> res2 = new ArrayList<Pair<String, String>>();
        Matcher matcher = CONFIG_PATTERN.matcher(configuration);
        int start = 0;
        while (matcher.find(start)) {
            if (matcher.start() != start) {
                return null;
            }
            start = matcher.end();
            res2.add((Pair<String, String>)Pair.create((Object)matcher.group(1), (Object)matcher.group(2)));
        }
        if (configuration.length() != start) {
            return null;
        }
        return res2;
    }

    @Nullable
    public static Pattern getPattern(@Nullable String configuration) {
        List<Pair<String, String>> parsed = ComboBoxParamEditor.parseConfiguration(configuration);
        if (parsed == null) {
            return null;
        }
        PatternBuilder builder = PatternBuilder.build("");
        boolean first2 = true;
        for (Pair<String, String> pair : parsed) {
            if (!first2) {
                builder.append("|");
            }
            first2 = false;
            builder.append(Pattern.quote((String)pair.second));
        }
        return builder.compile();
    }

    @NotNull
    private static List<Pair<String, String>> getItems(@Nullable String configuration) {
        List<Pair<String, String>> parsed = ComboBoxParamEditor.parseConfiguration(configuration);
        List<Object> list = parsed == null ? Collections.emptyList() : parsed;
        if (list == null) {
            ComboBoxParamEditor.$$$reportNull$$$0(0);
        }
        return list;
    }

    public ComboBoxParamEditor(@NotNull DataInterchange interchange, @Nullable String caption, @Nullable String configuration) {
        if (interchange == null) {
            ComboBoxParamEditor.$$$reportNull$$$0(1);
        }
        super(new ComboBox((ComboBoxModel)new CollectionComboBoxModel(ComboBoxParamEditor.getItems(configuration))), interchange, TypesRegistry.ParamEditor.FieldSize.MEDIUM, caption, new AnAction[0]);
        this.myText = "";
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value -> (String)value.first));
        ((ComboBox)this.getEditorComponent()).setEditable(false);
        ((ComboBox)this.getEditorComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem() != null) {
                    ComboBoxParamEditor.this.myText = StringUtil.notNullize((String)((Pair)e.getItem()).second.toString());
                }
                ComboBoxParamEditor.this.fireChanged();
            }
        });
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            ComboBoxParamEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text2) {
        if (text2 == null) {
            ComboBoxParamEditor.$$$reportNull$$$0(3);
        }
        this.myText = text2;
        int res2 = -1;
        int count2 = ((ComboBox)this.getEditorComponent()).getItemCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            Object item = ((ComboBox)this.getEditorComponent()).getItemAt(i2);
            Pair pair = (Pair)ObjectUtils.tryCast((Object)item, Pair.class);
            if (pair == null || !text2.equals(pair.second)) continue;
            res2 = i2;
            break;
        }
        ((ComboBox)this.getEditorComponent()).setSelectedIndex(res2);
    }

    @Override
    public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
        return TypesRegistry.ParamEditor.FieldSize.SMALL;
    }

    @Override
    public void setActive(boolean active) {
        ((ComboBox)this.getEditorComponent()).setBackground(ComboBoxParamEditor.getBackground(active));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/ComboBoxParamEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/ComboBoxParamEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

